<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

     <xsl:template match="/">
          <xsl:apply-templates select="Summary"/>
     </xsl:template>

     <!-- Style definition -->
     <xsl:template match="Summary">
       <xsl:variable name="LinkToTop" select="ItemLinkToTop"/>
          <html>
               <head>
                  <META http-equiv="content-type" content="text/html;charset=UTF-8" />
                    <style type="text/css">
                         <xsl:choose>
                              <xsl:when test="Lang = 'CH'">
                                   H1 { color: black; font-size: 17px; font-family: PMingLiU }
                                   H2 { color: black; font-size: 14px; font-family: PMingLiU }
                                   BODY { color: black; font-size: 12px; font-family: PMingLiU }
                                   TABLE { color: black; font-size: 12px; font-family: PMingLiU }
                                   A { color: blue; font-size: 12px; font-family: PMingLiU }
                                   P { color: black; font-size: 12px; font-family: PMingLiU }
                              </xsl:when>
                              <xsl:when test="Lang = 'JP'">
                                   H1 { color: black; font-size: 17px; font-family: MS UI Gothic }
                                   H2 { color: black; font-size: 14px; font-family: MS UI Gothic }
                                   BODY { color: black; font-size: 12px; font-family: MS UI Gothic }
                                   TABLE { color: black; font-size: 12px; font-family: MS UI Gothic }
                                   A { color: blue; font-size: 12px; font-family: MS UI Gothic }
                                   P { color: black; font-size: 12px; font-family: MS UI Gothic }
                              </xsl:when>
                              <xsl:when test="Lang = 'KO'">
                                   H1 { color: black; font-size: 17px; font-family: Gulim }
                                   H2 { color: black; font-size: 14px; font-family: Gulim }
                                   BODY { color: black; font-size: 12px; font-family: Gulim }
                                   TABLE { color: black; font-size: 12px; font-family: Gulim }
                                   A { color: blue; font-size: 12px; font-family: Gulim }
                                   P { color: black; font-size: 12px; font-family: Gulim }
                              </xsl:when>
                              <xsl:when test="Lang = 'ZH'">
                                   H1 { color: black; font-size: 17px; font-family: SimSun }
                                   H2 { color: black; font-size: 14px; font-family: SimSun }
                                   BODY { color: black; font-size: 12px; font-family: SimSun }
                                   TABLE { color: black; font-size: 12px; font-family: SimSun }
                                   A { color: blue; font-size: 12px; font-family: SimSun }
                                   P { color: black; font-size: 12px; font-family: SimSun }
                              </xsl:when>
                              <xsl:otherwise>
                                   H1 { color: black; font-size: 17px; font-family: Verdana,Arial,Helvetica }
                                   H2 { color: black; font-size: 14px; font-family: Verdana,Arial,Helvetica }
                                   BODY { color: black; font-size: 10px; font-family: Verdana,Arial,Helvetica }
                                   TABLE { color: black; font-size: 10px; font-family: Verdana,Arial,Helvetica }
                                   A { color: blue; font-size: 10px; font-family: Verdana,Arial,Helvetica }
                                   P { color: black; font-size: 10px; font-family: Verdana,Arial,Helvetica }
                              </xsl:otherwise>
                         </xsl:choose>
						 <A name="top"></A>
                         P.break {page-break-before: always}
                    </style>
               </head>
               <body>
                    
					<table border="0" cellspacing="5"> 
                         <tr>
                              <td>
                                   <img>
                                        <xsl:attribute name="src">
                                             <xsl:value-of select="Logo"/>
                                        </xsl:attribute>
                                        <xsl:attribute name="alt">.</xsl:attribute>
                                        <xsl:attribute name="align">left</xsl:attribute>
                                   </img>
                              </td>
                              <td><br/>
                                   <h1>
                                        <xsl:value-of select="Title"/>
								   </h1>
                              </td>
                         </tr>
                    </table>

                    <br/>
                    <hr/>
                    <br />
                    <h3>
                         <xsl:value-of select="Overview"/>
                    </h3>

                    <table border="0">
                      <xsl:for-each select="OverViewItem">
                        <tr>
                          <td>
                            <b>
                              <xsl:value-of select="Name"/>
                            </b>
                          </td>
                          <td>
                            <xsl:value-of select="NameVal"/>
                          </td>
                        </tr>
                      </xsl:for-each>                         
                    </table>
                    <br/>
                    <br/>                   

					<!-- DISPLAY THE WARNING TITLES WITH LINKS TO THEIR FULL TEXT -->
                    <xsl:for-each select="SummarySections/Section">
						<xsl:if test="Title = 'Warnings' or Title = 'Symantec Backup Exec Information'">
						<h3>
						<xsl:value-of select="Title"/>
						</h3>
						<xsl:for-each select="Nodes/Item">	
							<table border="0"> 
								<tr>
                                  <td rowspan="2">
                                    <img>
                                      <xsl:attribute name="src">
                                        <xsl:value-of select="IMG"/>
                                      </xsl:attribute>
                                      <xsl:attribute name="alt">.</xsl:attribute>
                                      <xsl:attribute name="align">left</xsl:attribute>
                                    </img>
                                  </td>
                                  <td>
                                    <b>
                                     <A HREF="#{ItemTitle}">
									 <xsl:value-of select="ItemTitle"/>
									</A>
                                    </b>
                                  </td>
                                </tr>
							</table>                            
						</xsl:for-each>
						<br/>
                        <br/>
                        </xsl:if> 
						
						<!-- DISPLAY THE FULL TEXT FOR THE FOLLOWING... -->
						<xsl:if test="Title = 'Backup Exec Options' or Title = 'License keys:'">
							<h1>
                          <xsl:value-of select="Title"/>
                        </h1>
                        <table border="0">                              
                              <xsl:for-each select="Nodes/Item">
                                <tr>
                                  <td rowspan="2">
                                    <img>
                                      <xsl:attribute name="src">
                                        <xsl:value-of select="IMG"/>
                                      </xsl:attribute>
                                      <xsl:attribute name="alt">.</xsl:attribute>
                                      <xsl:attribute name="align">left</xsl:attribute>
                                    </img>
                                  </td>
                                  <td>
                                    <b>
                                      <xsl:value-of select="ItemTitle"/>
                                    </b>
                                  </td>
                                </tr>
                                <tr>
                                  <td>
                                    <xsl:value-of select="ItemText"/>
                                  </td>
                                </tr>                                
                              </xsl:for-each>

                         </table>
                        <br/>
                        <br/>
						</xsl:if>
                        
                    </xsl:for-each>
					
					<br/>
					<br/>
					<br/>
					
					<!-- DISPLAY DETAILS FOR WARNING AND INFORMATION -->
					<xsl:for-each select="SummarySections/Section">
                        <xsl:if test="Title = 'Warnings' or Title = 'Veritas System Recovery Memory Warning' or Title = 'Veritas System Recovery feature installation information.'
                                 or contains(Title, 'Veritas System Recovery')">
							
							<h3>
							  <xsl:value-of select="Title"/>
							</h3>
							
							<table border="0"> 
								<COLGROUP VALIGN="top"/>
								  <xsl:for-each select="Nodes/Item">
									<tr>
									  <td rowspan="2">
										<img>
										  <xsl:attribute name="src">
											<xsl:value-of select="IMG"/>
										  </xsl:attribute>
										  <xsl:attribute name="alt">.</xsl:attribute>
										  <xsl:attribute name="align">left</xsl:attribute>
										</img>
									  </td>
									  <td>
									  
										<b><big>
										  <xsl:value-of select="ItemTitle"/>
										</big></b>
										<A name="{ItemTitle}"></A>
									  </td>
									</tr>
									
									<tr>
									  <td>
										<xsl:value-of select="ItemText"/>
										<br/>
                      <A HREF="#top">
                        <xsl:value-of select="$LinkToTop"/>
                      </A>
										<br/>
										<br/>
									  </td>
									</tr> 
									
								  </xsl:for-each>

							 </table>
							<br/>
							<br/>
						</xsl:if>
                    </xsl:for-each>
               </body>
          </html>
     </xsl:template>
</xsl:stylesheet>