<?xml version='1.0'?>
<xsl:stylesheet  version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:msxml="urn:schemas-microsoft-com:xslt"
              xmlns:random="http://www.microsoft.com/msxsl"
              exclude-result-prefixes="msxml random">

  <msxml:script implements-prefix="random">
    function range(min, max)
    {
    var dist = max - min + 1;
    return Math.floor(Math.random() * dist + min);
    }
  </msxml:script>

  <xsl:template match="/">
    <HTML>
               <HEAD>
                    <META http-equiv='content-type' content='text/html;charset=UTF-8'> </META>
                    <STYLE TYPE="text/css">
							warning { color: #CC3333; font-size: 10px; font-family: Verdana,Arial,Helvetica }  
							caution { color: #FFCC33; font-size: 10px; font-family: Verdana,Arial,Helvetica }  
                         <xsl:choose>
                         <xsl:when test="Lang = 'JP'">
                              H1 { color: black; font-size: 17px; font-family: MS UI Gothic }
                              H2 { color: black; font-size: 14px; font-family: MS UI Gothic }
                              H3 { color: black; font-size: 12px; font-family: MS UI Gothic }
                              BODY { color: black; font-size: 12px; font-family: MS UI Gothic }
                              TABLE { color: black; font-size: 12px; font-family: MS UI Gothic }
                              A { color: blue; font-size: 12px; font-family: MS UI Gothic }
                              P { color: black; font-size: 12px; font-family: MS UI Gothic }
                         </xsl:when>
                         <xsl:otherwise>
                              H1 { color: black; font-size: 17px; font-family: Verdana,Arial,Helvetica }
                              H2 { color: black; font-size: 14px; font-family: Verdana,Arial,Helvetica }
                              H3 { color: black; font-size: 12px; font-family: MS UI Gothic }
                              BODY { color: black; font-size: 10px; font-family: Verdana,Arial,Helvetica }
                              TABLE { color: black; font-size: 10px; font-family: Verdana,Arial,Helvetica }
                              A { color: blue; font-size: 10px; font-family: Verdana,Arial,Helvetica }   
                              P { color: black; font-size: 10px; font-family: Verdana,Arial,Helvetica }  
                         </xsl:otherwise>
                         </xsl:choose>

                         P.break {page-break-before: always}
                    </STYLE>
                    <!--disable right clicks-->
                    <script language="Javascript1.2">
                      <xsl:comment>
      <![CDATA[
                         function disable()
 
                          {
 
                               if (document.all)
 
                               {
 
                                    return false;
 
                               }
 
                          }
                          document.oncontextmenu=disable;
                          document.oncontextmenu=new Function("return false");
 
 
                          function resetfilters(url)                           { 
                               document.getElementById("chkboxErrors").checked = false 
                               document.getElementById("chkboxWarnings").checked = false      
                               document.getElementById("chkboxInformation").checked = false        
                               ShowAll("info");         
                               ShowAll("error");        
                               ShowAll("warning");      
                               if (url != "")           
                               {         
                                     window.top.location = url;        
                                     window.scrollBy(0, -100);         
                               }         
                               return true;        
                           }             
                            function ShowAll(logtype)             
                           {        
                               var arr = document.getElementsByTagName('div')         
                               for(var i=0; i<arr.length;i++)          
                               {         
                                  var tagObj = arr.item(i);            
                                  var attributes = tagObj.className;        
                                  if(attributes == logtype)       
                                        arr[i].style.display = 'block';          
                               }         
                           }        
 
                           function HideAll(logtype)         
                           {        
                                    var arr = document.getElementsByTagName('div')         
                                    for(var i=0; i<arr.length;i++)          
                                    {         
                                            var tagObj = arr.item(i);            
                                            var attributes = tagObj.className;        
                                            if(attributes == logtype)       
                                              arr[i].style.display = 'none';          
                                    }         
                           }        
                           function filterlogs(logtype)      
                           {        
                               bChecked = document.getElementById("chkboxErrors").checked | document.getElementById("chkboxWarnings").checked | document.getElementById("chkboxInformation").checked;         
                               bUnChecked = false; 
                               if (bChecked == false)        
                                   bUnChecked = true;        
 
                               if (document.getElementById("chkboxErrors").checked)        
                                   ShowAll("error");         
                               else           
                                    HideAll("error");        
 
                               if (document.getElementById("chkboxWarnings").checked)           
                                    ShowAll("warning");      
                               else           
                                    HideAll("warning");      
 
                               if (document.getElementById("chkboxInformation").checked)        
                                    ShowAll("info");         
                               else           
                                    HideAll("info");         
 
                               if (bUnChecked == true)       
                               {         
                                    ShowAll("info");         
                                    ShowAll("error");        
                                    ShowAll("warning");      
                               }         
                               return true;        
                           }  
                                 ]]> 
    </xsl:comment>
                    </script>
               </HEAD>
               <body bgcolor="white">

               
               <xsl:apply-templates select="LogFile"/>
          
          </body>
     </HTML>
     </xsl:template>

     <xsl:template match="LogFile">
          
                 <BR/>

                 <h1>VxLogServer Generated Log Files</h1>
                 <BR/>
                 <HR/>
                <div class="JumpTo">
                  <BR/>
                </div>
                <div class="FilterOptions">
                 <left>
                   <h2>Filter Options</h2>
                 </left>
                 <table width="100%">
                   <tr>
                     <td>
                       <b>LogEntry Type: </b>
                     </td>
                     <td>
                       <label>
                         <input id="chkboxErrors" type="checkbox" onclick="filterlogs('error')" />Errors
                       </label>

                       <label>
                         <input id="chkboxWarnings" type="checkbox" onclick="filterlogs('warning')" />Warnings
                       </label>

                       <label>
                         <input id="chkboxInformation" type="checkbox" onclick="filterlogs('info')" />Information
                       </label>
                     </td>
                   </tr>
                   <tr>
                     <td align="left">
                       <input type="button" class="button" onclick="resetfilters('')" value="Reset Filters"/>
                     </td>
                   </tr>
                 </table>
                 <BR/>
                 <HR />
                </div>
                 <div class="LogSession">
                 <xsl:for-each select="Session">

                   <BR/>
                   <BR/>
                   <BR/>
                   <BR/>
			     <h1><xsl:value-of select="LogFileHeader"/></h1>                                               
                   <BR/>

                   <xsl:for-each select="logdata">
                     <xsl:variable name="myRandom" select="random:range(0, 9999999)"/>
                     <xsl:variable name="myDateTime" select="datetime"/>
                     <xsl:if test="type = '0'">
                              <div class="info">
                                <xsl:value-of select="$myDateTime"/> : <xsl:value-of select="msg"/>
                                <BR/>
                              </div>
                     </xsl:if>

                     <xsl:if test="type = '1'">
                              <div class="warning">
                              <b><font color="orange">
                                <a name="{$myDateTime},{$myRandom}" style="cursor:hand" onclick="resetfilters('#{$myDateTime},{$myRandom}')"> + </a>
                                <xsl:value-of select="$myDateTime"/> : <xsl:value-of select="msg"/>
                                </font></b>
                                <BR/>
                              </div>
                     </xsl:if>

                     <xsl:if test="type = '2'">
                              <div class="error">
                              <b><font color="red">
                                <a name="{$myDateTime},{$myRandom}" style="cursor:hand" onclick="resetfilters('#{$myDateTime},{$myRandom}')"> + </a>
                                <xsl:value-of select="$myDateTime"/> : <xsl:value-of select="msg"/>
                                </font></b>
                                <BR/>
                              </div>
                     </xsl:if>
                   </xsl:for-each>

                 </xsl:for-each>
                 <BR/>
                 <HR/>
                 <BR/>
                 <BR/>
                 </div>
              
          
     </xsl:template>

</xsl:stylesheet>