﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
#  Example Script: Un-mounts a volume from a .v2i file.
#
#  Objects Used: GenericMount object, Device object.
#  Initialize the following variables with appropriate values:
#               1. sV2iFile with the sV2i file name.
#               2. sDriveLetter with drive letter.
#-----------------------------------------------------------------------------------------

	$oGenericMount = $null
	$oDevice = $null
	$aMountedDevices = $null
	$sV2iFile = $null
	$sDriveLetter = $null
    
    #-----------------------------------------------------------------------------------------
    # Specify the path of .v2i file. 
    #         Drive letter.    
    #-----------------------------------------------------------------------------------------

    $sV2iFile = "E:/Images/SystemBackup002.v2i"
    $sV2iFile = $sV2iFile.ToLower()
	$sDriveLetter = "H:/"
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Create a GenericMount Automation object.
	#-----------------------------------------------------------------------------------------
	
    $oGenericMount = New-Object -ComObject "GenericMountService.GenericMount"
	$aMountedDevices = $oGenericMount.MountedDevices
    
    #-----------------------------------------------------------------------------------------
	# Step 2: Un-mount the drive.
	#-----------------------------------------------------------------------------------------
    
    if($aMountedDevices -is [Array])
    {
	    foreach($oDevice in $aMountedDevices)
        {
			if (($oDevice.FileSpec.ToLower() -eq $sV2iFile.ToLower()) -or
    			(($sV2iFile -eq "") -and ($oDevice.Mountpoint -eq $sDriveLetter)))
            {
				Write-Host "Unmounted successfully..."  
                Write-Host "DriveLetter:"  $oDevice.DriveLetter 
                Write-Host "VolumeGuid:" $oDevice.SymbolicLink
				try
                {
                    $oDevice.Remove()
                }
                catch
                {
                    Write-Host "Umounting of drive Failed with Exception..."
                    Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
                    Write-Host $_.Exception.Message -ForegroundColor Red
                    Write-Host "Exiting..."
                    exit $1
                }
			}
	    }
    }
	else
    {
        Write-Host "No Mounted devices Found..."
	}
    
    Write-Host "All mounted drives unmounted successfully..."
