﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
# Sample script for silently installing Veritas System Recovery. 
#
# This script assumes the following:  
#	The Driver Validation folder is in the same directory as the setup.exe.
#	
# Veritas System Recovery setup specific command line options.
# SYMINSTALLDIR=	location to install LSR.
# REBOOT=F|S|R		Force OR Suppress Or ReallySupress a reboot.
#
#-----------------------------------------------------------------------------------------

    Set-StrictMode -Off
	set-executionpolicy -scope CurrentUser -executionPolicy unrestricted
    
    $rc = $null
    $command = $null
    $installDir = $null
    $reboot = $null
    $CMD1 = $null
    
    #----------------------------------------------------------------------------------------
    # Function to show usage information to user.
    #----------------------------------------------------------------------------------------
    [reflection.assembly]::loadwithpartialname("System.Windows.Forms") | Out-Null 
    
    function Usage
    {
        $Msg = $null
        $Msg = "Usage: SilentInstall.ps1 [-installdir Path] [-reboot Yes|No]" + "`r`n"
        $Msg += "       -installdir Path" + "`r`t" + "Non default directory to install to." + "`r`t" + "(Optional)" + "`r`n"
        $Msg += "       -reboot Yes|No" + "`r`t" + "To reboot after installation." + "`r`t" + "(Optional)" + "`r`n"
        
        [System.Windows.Forms.MessageBox]::Show($Msg, "Usage Information",
        [System.Windows.Forms.MessageBoxButtons]::OK)
        
        Write-Host "Exiting..."
        exit $1
    }
    
    #----------------------------------------------------------------------------------------
    # Function to parse the command line.
    #----------------------------------------------------------------------------------------
    
    function ParseCommandLine
    {
        param ($pargs, [ref]$pinstallDir, [ref]$preboot)
        [int]$it = 0
        while($it -lt [int]$pargs.Length)
        {
            if($pargs[$it] -eq "-installdir")
            {
                $it += 1
                if($it -gt [int]$pargs.Length)
                {
                    Usage
                }
                $pinstallDir.Value = $pargs[$it]
            }
            elseif($pargs[$it] -eq "-reboot")
            {
                $it += 1
                if($it -gt [int]$pargs.Length)
                {
                    Usage
                }
                $preboot.Value = $pargs[$it]
            }
            else
            {
                Usage
            }
            
            $it += 1
        }
    }
    
    #-----------------------------------------------------------------------------------------
	# Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
    ParseCommandLine $args ([ref]$installDir) ([ref]$reboot)
    
    #-----------------------------------------------------------------------------------------
    # Construct the setup command from the arguments.
    #-----------------------------------------------------------------------------------------

    #silent install option
    $command +=" /S:"
    
    #destination
    if($installDir -ne $null)
    {
        $command += " /DEST: " + $installDir
    }
    #reboot option
    if($preboot -eq "Yes")
    {
        $command += " /BOOT:"
    }
    
    $command += " /FULL:"
    

    #-----------------------------------------------------------------------------------------
    # Run the silent install.
    #-----------------------------------------------------------------------------------------
    
    $CMD1 = "Z:\SSR\SSRX64\SETUP.EXE" 
    write-host $CMD1
    write-host "Starting Silent install..."    
    invoke-expression "$CMD1 $command"
    
    
   
    
