﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
#  Example Script: Run an existing image job immediately.
#
#   Objects Used: ProtectorAuto, ImageJob.
#   Initialize the following variables with appropriate values :
#               1. sJobID –id of the image job that you want to run.
#-----------------------------------------------------------------------------------------
    
    $v2iAuto = $null
	$oNet = $null
	$oImageJob = $null
	$sJobID = $null
    
    # Set the Job ID
	$sJobID = "{5C33504F-DBB7-42A3-B671-DE61F69DD2FB}"
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: RunJobNow.ps1"
		exit $1;
	}
    
    #-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 4: Get the image job object from the agent.
	#-----------------------------------------------------------------------------------------
	
    try
    {
        $oImageJob = $v2iAuto.ImageJob($sJobID)
        if($oImageJob -eq $null)
        {
            Write-Host "RunJobNow.ps1: Cannot find the specified job..."
            Write-Host "Exiting..."
            exit $1
        }
    }
    catch
    {
        Write-Host "Failed to get the image job by specified job ID with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }

	#-----------------------------------------------------------------------------------------
	# Step 5: Execute the job immediately.
	#-----------------------------------------------------------------------------------------
	
	Write-Host "Running job " $oImageJob.DisplayName "..."
	try
    {
        $v2iAuto.DoImageJob($sJobID, $oImageJob.Constants.ImageTypeIncremental)
    }
    catch
    {
        Write-Host "Failed to Run the Image Job with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    Write-Host "Job completed successfully..."