﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
#   Example Script: Restore a recovery point.
#
#   Objects Used: ProtectorAuto, RestoreJob, Destination, FolderLocation
#   Initialize the following variables with appropriate values:
#               1. sVolume - Set the volume that you want to restore.                               
#               2. sFilePath – set the file path
#-----------------------------------------------------------------------------------------
    
    $v2iAuto = $null
	$oNet = $null
	$oDestination = $null
	$oTempDest = $null
	$oLocation = $null
	$oRestoreJob = $null
	$sVolume = $null
	$sFilePath = $null
	$sUsrName = $null
    $sPwd = $null
	#Set the volume that you want to restore 
	$sVolume = "F:"
    
    #----------------------------------------------------------------------------------------------------
    # Function : CreateLocation
    # Input parameters :
    #                   a)  Path can be a local folder location or a network location.
    #                   b)  Domain user name if the path is a network location.
    #                   c)  password for authenticating to the network location.
    #
    # Return parameter: Location COM object containing all the information about the location
    #-----------------------------------------------------------------------------------------------------
    
    function CreateLocation 
    {
        param ([string]$Path, [string]$domainUser, [string]$password)
        
        $oLocation = $null
        $sepPos = $null 
        $dotPos = $null
        $Path = $Path -replace "/","\"
        
        # Parse the location.
        # Check if the location is a network location or a folder location.
        # If it is a network location, set the user name and password.
        if ($Path.SubString(0,2) -eq "\\")
        {
            $oLocation = New-Object -ComObject "Veritas.VProRecovery.NetworkLocation"
            $oLocation.NetworkUser = $domainUser
            $oLocation.NetworkPassword = $password
        }
        else 
        {
            $oLocation = New-Object -ComObject "Veritas.VProRecovery.FolderLocation"
        }
        
        $sepPos = $Path.LastIndexOf("\")
        $dotPos = $Path.LastIndexOf(".")

        $oLocation.Path = [string]$Path.SubString(0, $sepPos)
        $oLocation.FileSpec = [string]$Path.SubString($sepPos+1, $dotPos - $sepPos - 1)
        $oLocation.Extension = [string]$Path.SubString($dotPos)
        
        Write-Host "Path: " $oLocation.Path 
        Write-Host "FileSpecs: " $oLocation.FileSpec 
        Write-Host "Entension: "$oLocation.Extension
        
        return $oLocation
    }
    
    #-----------------------------------------------------------------------------------------------------
	# Specify the image file(.v2i) folder location\network location that you want to restore.
    # If it is a network location, provide the complete UNC path. For example, "\\Ipadress\Folder\FileName" 
    # and also specify the user name as "Domain\username" and password. 
    #-----------------------------------------------------------------------------------------------------
   
   	$sFilePath = "G:\Veritas Backups\test\SystemBackup002.v2i"
	$sUsrName = ""
	$sPwd = ""
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: RestoreImage.ps1"
		exit $1;
	}
    
    #-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #----------------------------------------------------------------------------------------
	# Step 4: Find the volume to which you want to restore in the volume list.
	#----------------------------------------------------------------------------------------
	
	foreach($oTempDest in $v2iAuto.Destinations)
    {
		if ($oTempDest.Mounted -eq $true)
        {
			If ($oTempDest.MountPoint.SubString(0,2) -eq $sVolume)
            {
				$oDestination = $oTempDest
				break;
			}
		}
	}
    
    if($oDestination -eq $null)
    {
        Write-Host "RestoreImage:ps1: Cannot find requested volume..."
        Write-Host "Exiting..."
        exit $1
    }
    
    #----------------------------------------------------------------------------------------
	# Step 5: Define the location where the image will be restored from.
	#----------------------------------------------------------------------------------------
	
	$oLocation = CreateLocation $sFilePath $sUsrName $sPwd
	
	#----------------------------------------------------------------------------------------
	# Step 6: Create a restore job.
	#----------------------------------------------------------------------------------------
	
	$oRestoreJob = New-Object -ComObject "Veritas.VProRecovery.RestoreJob"
	$oRestoreJob.DismountDestination = $true            # In case the destination is currently in use
	$oRestoreJob.PreVerifyImage = $true                 # Make sure the image is good before restoring it
	$oRestoreJob.Destinations = [Array]$oDestination.ID # Only restore over one destination
	$oRestoreJob.Source = $oLocation                    #Recovery point location
    
    #----------------------------------------------------------------------------------------
	# Step 7: Execute the restore job.
	#----------------------------------------------------------------------------------------
	
	Write-Host "Restoring..."
	try
    {
        $v2iAuto.RestoreImage($oRestoreJob)
    }
    catch
    {
        Write-Host "Failed to Restore Image with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    Write-Host "Recovery point restored successfully..."
    
    
