﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------
#    Example Script: Display the history. 
#
#    Objects Used: ProtectorAuto, oVolume.
#
#-----------------------------------------------------------------------------------------
		
	$v2iAuto = $null
	$oNet = $null
	$oVolume = $null
	$oTempVol = $null
	$oImageJob = $null
    $Msg = $null

    #-----------------------------------------------------------------------------------------
    # Function to display the history information of all the volumes.
    # List of the information displayed: 
    #   GenericID , Description , lastImage , Lasttime , FileName , ID , TimeStamp.
    #-----------------------------------------------------------------------------------------
    [reflection.assembly]::loadwithpartialname("System.Windows.Forms") | Out-Null 
    
    function DisplayHistory
    {
        $Msg += "GenericID: " + $oVolume.GenericID + "`r`n"
        $Msg += "Description: " + $oVolume.LastImage.Description + "`r`n"
        $Msg += "LastImage: " + $oVolume.LastImage.DisplayJobName + "`r`n"
        $Msg += "Last time: " + $oVolume.LastImage.DisplayName + "`r`n"
        $Msg += "FileName: " + $oVolume.LastImage.FileName + "`r`n"
        $Msg += "ID: " + $oVolume.LastImage.ID  + "`r`n"
        $Msg += "TimeStamp: " + $oVolume.LastImage.TimeStamp + "`r`n"
        
        [System.Windows.Forms.MessageBox]::Show($Msg, "History",
        [System.Windows.Forms.MessageBoxButtons]::OK)
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: Query_History.ps1"
		exit $1;
	}
	
	#-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	 try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 4: Find the volume to image (the system volume in this case).
	#-----------------------------------------------------------------------------------------
    
    $oVolume = $null
	foreach($oTempVol in $v2iAuto.Volumes($false))
	{
		if($oTempVol.System -eq $true)
		{
			$oVolume = $oTempVol
            DisplayHistory
		}
	}
	
    If ($oVolume -eq $null)
	{
		Write-Host "Query_History.ps1: Cannot find requested volume $sVolume..."
		exit $1
	}
    
    Write-Host "All history information fetched successfully..."