#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 18 Automation
#
# Copyright (c) 2018 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------
#   Example Script: Create an image of the system drive to a passed-in network folder.
#   Objects Used: ProtectorAuto, ImageJob, Volume, NetworkLocation , FolderLocation , oP2vSysInfo
#                   oVMDKDiskOption , oP2vDiskInfo , oP2vVolInfo.
#   Initialize the following variables with appropriate values :
#               1. oSrcNetLocation and oDestNetLocation to location 
#               2. sDriveletter to a particular drive
#-----------------------------------------------------------------------------------------
  
#--------------------------------------------------------------------------------------------------------------
# PS C:> ThisPS1File
#--------------------------------------------------------------------------------------------------------------

$IsStatusByImageID = $null
$AccessKey = $null
$SecretKey = $null

#--------------------------------------------------------------------------------------------------------------
#Function to generate log
#--------------------------------------------------------------------------------------------------------------
Function LogWrite
{
   Param ([string]$logstring)
   $Logfolder = "C:\UploadConvertVHDLogs"
   $Logfile = "$Logfolder\$env:COMPUTERNAME.log"
   if((Test-Path $Logfile) -eq 0)
   {
        New-Item -ItemType Directory -path $Logfolder
        New-Item -ItemType File -Path $Logfile
   }
   $string1 = Get-Date
   Add-content $Logfile -value "$string1 : $logstring"
}

$IsStatusByImageID = Read-host -Prompt "Press 1 to view the status of all conversion tasks in your region Or 
Press 2 if you want to view the status of creation of AMI by ImportTaskId"
if($AccessKey -eq $null -and $SecretKey -eq $null)
	{
        $AccessKey = Read-Host -Prompt "Enter access Key" -AsSecureString
        $BSTR = [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($AccessKey)
        $AccessKey = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)


        $SecretKey = Read-Host -Prompt "Enter secret key" -AsSecureString
        $BSTR = [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR($SecretKey)
        $SecretKey = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto($BSTR)
	}
    $Region = Read-Host -Prompt "Enter the region"

if($IsStatusByImageID -eq 1)
{
    if($Region -ne $null)
    {
        aws ec2 describe-conversion-tasks --region $Region 
    }
    DO
    {
        $Exit = "exit"
        $QuitApp = Read-Host -Prompt "Enter EXIT to quit the application"
    } While($QuitApp -ne $Exit)
}
if($IsStatusByImageID -eq 2)
{
    $ImportTaskID = Read-Host -Prompt "Enter the import-task-id. For example:import-ami-fgbvlay3"
    if($ImportTaskID -ne $null)
    {
        aws ec2 describe-import-image-tasks --import-task-ids $ImportTaskID
    }
    DO
    {
        $Exit = "exit"
        $QuitApp = Read-Host -Prompt "Enter EXIT to quit the application"
    } While($QuitApp -ne $Exit)
}
if(($IsStatusByImageID -ne 1) -and ($IsStatusByImageID -ne 2))
{
    Write-Host "Incorrect key."
    Write-Host "Exiting....."
    LogWrite "Operation terminated because of wrong option"
    DO
    {
        $Exit = "exit"
        $QuitApp = Read-Host -Prompt "Enter EXIT to quit the application"
    } While($QuitApp -ne $Exit)
}