﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
#   Example Script: Move destination.
#
#   Objects Used: ImageJob, Location.
#   Initialize the following variables with appropriate values:
#               1. sFolderPath – set the folder path
#               2. sJobID –set to job ID
#              
#-----------------------------------------------------------------------------------------

	$v2iAuto = $null
	$oNet = $null
	$source = $null
	$destination = $null
	$oLocation = $null
	$oImageJob  = $null
	$oMoveImageJob  = $null
	$sJobID = $null
    $aVolumes = $null
    $sFolderPath  = $null
    $sUsrName  = $null
    $sPwd = $null
    $oVol = $null
	$oVolume  = $null
    $oTempVol = $null
	$sVolume = $null
    
     #----------------------------------------------------------------------------------------------------
    # Function : CreateLocation
    # Input parameters :
    #                   a)  Path can be a local folder location or a network location.
    #                   b)  Domain user name if the path is a network location.
    #                   c)  password for authenticating to the network location.
    #
    # Return parameter: Location COM object containing all the information about the location
    #-----------------------------------------------------------------------------------------------------
    
    function CreateLocation 
    {
        param ([string]$Path, [string]$domainUser, [string]$password)
        
        $oLocation = $null
        $sepPos = $null 
        $dotPos = $null
        $Path = $Path -replace "/","\"
        
        # Parse the location.
        # Check if the location is a network location or a folder location.
        # If it is a network location, set the user name and password.
        if ($Path.SubString(0,2) -eq "\\")
        {
            $oLocation = New-Object -ComObject "Veritas.VProRecovery.NetworkLocation"
            $oLocation.NetworkUser = $domainUser
            $oLocation.NetworkPassword = $password
        }
        else 
        {
            $oLocation = New-Object -ComObject "Veritas.VProRecovery.FolderLocation"
        }
        
        #$sepPos = $Path.LastIndexOf("\")
        #$dotPos = $Path.LastIndexOf(".")

        $oLocation.Path = $Path
        #$oLocation.FileSpec = [string]$Path.SubString($sepPos+1, $dotPos - $sepPos - 1)
        $oLocation.FileSpec = "A2SYMMD03449_G_Drive"
        #$oLocation.Extension = [string]$Path.SubString($dotPos)
        $oLocation.Extension = ".v2i"
        
        Write-Host "Path: " $oLocation.Path 
        Write-Host "FileSpecs: " $oLocation.FileSpec 
        Write-Host "Entension: "$oLocation.Extension
        
        return $oLocation
    }
    
    # Set the volume for which Move operation should be performed. 
	$sVolume="C:\"

	#----------------------------------------------------------------------------------------------------------
	# Specify the image file(.v2i) folder \network location that has to be restored.
    # If it is a network location, enter the complete UNC path, for example, "\\Ipadress\FolderName" to restore
    # and also specify the user name as "Domain\username" and password. 
    #-----------------------------------------------------------------------------------------------------------
   
   	$sFolderPath="E:\NewDestination"        
	$sUsrName=$null
	$sPwd=$null
	
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: MoveDestination.ps1"
		exit $1;
	}
    
    #-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# step 4: Set the job ID and Image Job object.
	#-----------------------------------------------------------------------------------------
	
	$sJobID = "{9255BCA5-4E8C-491A-AC56-333C09FBB0E2}"
    try
    {
        $oImageJob = $v2iAuto.ImageJob($sJobID)
        if($oImageJob -eq $null)
        {
            Write-Host "MoveDestination.ps1: Cannot find the specified job..."
            Write-Host "Exiting..."
            exit $1
        }
    }
    catch
    {
        Write-Host "Failed to get the image job by specified job ID with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 5: Define the location and set the destination path to move the v2i files.
	# Call the function CreateLocation 
	#-----------------------------------------------------------------------------------------
		
	$oLocation = CreateLocation $sFolderPath "" ""
	Write-Host "Setting destination..."
    
    #-----------------------------------------------------------------------------------------
	# step 6: Create an array of all the volumes.
	#-----------------------------------------------------------------------------------------
	
	$aVolumes = $oImageJob.Volumes
	foreach($oTempVol in $v2iAuto.Volumes($false))
    {
		if($oTempVol.MountPoint -eq $sVolume)
        {
			$oVolume = $oTempVol
			break;
		}
	}
    
    #-----------------------------------------------------------------------------------------
	# step 7: Set oMoveImageJob object and Call AddImageJob object.
	#-----------------------------------------------------------------------------------------
	
    $oMoveImageJob = $oImageJob
    $oImageJob.Location($sVolume) = $oLocation
    try
    {
        $v2iAuto.AddImageJob($oImageJob)
    }
    catch
    {
        Write-Host "Add Image Job failed with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    
	#-----------------------------------------------------------------------------------------
	# step 8: Move all recovery points to a particular destination.
	#-----------------------------------------------------------------------------------------
	
	Write-Host "Setting Move All Recovery Points..."
    try
    {
	    $v2iAuto.MoveAllRecoveryPoints([Array]$oMoveImageJob, $false)
    }
    catch
    {
        Write-Host "Move All Recovery Points failed with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1   
    }
	Write-Host "Successfully Completed Moving All Recovery Points..."
    