﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
#  Example Script: Mounts a volume from a .v2i file.
#
#    Objects Used:  V2iParameters object.
#    Initialize the following variables with appropriate values:
#               1. sV2iFile with the sv2i file name.
#               2. sDriveLetter with the drive letter.
#-----------------------------------------------------------------------------------------

	$oGenericMount = $null
	$oMountParams = $null
	$oV2iParams	 = $null
	$aMountedDevices = $null
	$sV2iFile = $null
	$sDriveLetter = $null
	$sPassword = $null
	$sMountPoint = $null
    $tempfilename = $null
	$TypeLib = $null
    
    #-----------------------------------------------------------------------------------------
    # Specify the path of the .v2i file. 
    #         Drive letter.
    #         Password.
    #-----------------------------------------------------------------------------------------
      
	$sV2iFile = "E:\Images\SystemBackup002.v2i"
	$sDriveLetter = "Y:"
	$sPassword = ""
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Create a GenericMount Automation object.
	#-----------------------------------------------------------------------------------------
	
	$oGenericMount = New-Object -ComObject "GenericMountService.GenericMount"
	$oMountParams = New-Object -ComObject "GenericMountService.MountParameters"
    
    #-----------------------------------------------------------------------------------------
	# Step 2: Set the parameters for mounting.
	#-----------------------------------------------------------------------------------------
	$TypeLib = New-Object -ComObject "Scriptlet.Typelib"
    $tempfilename = [string]$Typelib.Guid + ".sdev"
	$oMountParams.CreateNew = $false
	$oMountParams.Writable = $false
	#oMountParams.NewSectorSize = 512
    $oMountParams.TempFilePath = $tempfilename
	#oMountParams.SecurityDescriptor = windows secuirty descriptor
    
    #-----------------------------------------------------------------------------------------
	# Step 3: Create the V2iParameters object.
	#-----------------------------------------------------------------------------------------
	
	$oV2iParams = New-Object -ComObject "V2iPlugin.V2iParameters"
    $oV2iParams.Password = $sPassword

    #-----------------------------------------------------------------------------------------
	# Step 4 Mount the drive.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Mounting drive..."
    try
    {
        $aMountedDevices = $oGenericMount.Mount( $sV2iFile, $oV2iParams, $oMountParams)
    }
    catch
    {
        Write-Host "Failed to mount drive with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    # If mount point is not assigned assign the specified mount point
    if($aMountedDevices[0].MountPoints -eq $null)
    {
	    $aMountedDevices[0].AddMountPoint($sDriveLetter)
	}
    else
    {
        $sDriveLetter = $aMountedDevices[0].MountPoints[0];
    }
    
	Write-Host $sV2iFile "mounted successfully to DriveLetter:"  $sDriveLetter 
    Write-Host "VolumeGuid:" $aMountedDevices[0].SymbolicLink
    