﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
# Sample script for installing LightsOut Restore (LOR).
#
# LOR setup specific command line options:
# configfilePath	- Specify the configuration file path.
# logfilepath - Specify the log file path.

# Example :command -: F:\Softwares\SRD\MANAGER\BOOTENVSETUP.EXE -configfilePath. -logfilepath %temp%
#
#-----------------------------------------------------------------------------------------
    
    $rc = $null
    $commandLineArgs = $null
    $WSHShell = $null
    $WSHShell = New-Object -ComObject "Wscript.Shell"
    
    #-----------------------------------------------------------------------------------------------
    # Command
    #-----------------------------------------------------------------------------------------------
    $commandLineArgs =  " -configfilepath C:\Program Files\Veritas\Veritas System Recovery\Agent\ -logfilepath c:\log.txt"
    #-----------------------------------------------------------------------------------------------
    # Run silent install.
    #-----------------------------------------------------------------------------------------------
    
    Write-Host "Installing LOR silently..."
    Write-Host $commandLineArgs
    try
    {
        #$rc = $WSHShell.run($command, $7, $true)
        & "C:\Program Files\Veritas\Veritas System Recovery\Agent\BOOTENVSETUP.EXE" $commandLineArgs
    }
    catch
    {
        Write-Host "Failed to Install LOR with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    Write-Host "LOR installation successful..."