#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------

#-----------------------------------------------------------------------------------------
# Information : This script is used to restore the file/folder backed-up files.
#-----------------------------------------------------------------------------------------

$SearchPattern = "*.*"
$SearchItem = 1000

#-------------------------------------------------
# Create object of restore selector.
#-------------------------------------------------

$oRestoreSelector = New-Object -ComObject "Veritas.FileBackup.RestoreSelector"
$oRestoreSelector.IncludeSubFolders = $true

#-------------------------------------------------
#Add pattern to search
#-------------------------------------------------
$oRestoreSelector.AddPattern($SearchPattern)

$oFileRestore = $null

$oFileRestore = New-Object -ComObject  "Veritas.FileBackup.FileRestore"

#-------------------------------------------------
# Create binding flags for public Invoke Methods.
#-------------------------------------------------
$bindingInvokeMethod = [System.Reflection.BindingFlags]::InvokeMethod

#------------------------------------------------------------------------------
# Call $oFileRestore.AddSelector($oRestoreSelector) via dynamic invocation.
#------------------------------------------------------------------------------
[System.__ComObject].InvokeMember('AddSelector', $bindingInvokeMethod , $null, $oFileRestore,  $oRestoreSelector)

#------------------------------------------------------------------------------
# Search say 1000 files to restore...
# Call $oFileRestore.Search($SearchItem) via dynamic invocation.
#------------------------------------------------------------------------------
$searchedItems = $null
$searchedItems = [System.__ComObject].InvokeMember('Search', $bindingInvokeMethod , $null, $oFileRestore,  $SearchItem)

#------------------------------------------------------------------------------
# Now iterate all search results then Restore it.
#------------------------------------------------------------------------------

foreach($fileToRestore in $searchedItems)
{
    #------------------------------------------------------------------------------
    # Call $oFileRestore.ClearSelectors()
    #------------------------------------------------------------------------------
    [System.__ComObject].InvokeMember('ClearSelectors', $bindingInvokeMethod , $null, $oFileRestore,  $null)
 
 
    $oRestoreSelector.ClearBackedUpFileIds()
    $oRestoreSelector.ClearPatterns()

    $oRestoreSelector.AddBackedUpFileId($fileToRestore.BackedUpFileId)

    #------------------------------------------------------------------------------
    # Call $oFileRestore.AddSelector($oRestoreSelector) via dynamic invocation.
    #------------------------------------------------------------------------------

    [System.__ComObject].InvokeMember('AddSelector', $bindingInvokeMethod , $null, $oFileRestore, $oRestoreSelector)

    #------------------------------------------------------------------------------
    # Create binding flags for public SetProperty. via dynamic invocation.
    #------------------------------------------------------------------------------

    $bindingSetProperty = [System.Reflection.BindingFlags]::SetProperty

    #------------------------------------------------------------------------------------------------------
    # Call $oFileRestore.Destination = $fileToRestore.SrcDirPath via dynamic invocation.
    # NOTE: Here we have kept the restore path same as the original path from where the backup was taken. 
    #       This can be altered providing different path instead of $fileToRestore.SrcDirPath
    #------------------------------------------------------------------------------------------------------

    $destinationPath = $fileToRestore.SrcDirPath     # Keeping destination same as the source of backup location.

    [System.__ComObject].InvokeMember('Destination', $bindingSetProperty, $null, $oFileRestore, $destinationPath)

    #------------------------------------------------------------------------------
    # Call $oFileRestore.Overwrite = $true via dynamic invocation.
    #------------------------------------------------------------------------------

    [System.__ComObject].InvokeMember('Overwrite', $bindingSetProperty, $null, $oFileRestore, $true)

    #------------------------------------------------------------------------------
    # Call $oFileRestore.Restore() via dynamic invocation.
    #------------------------------------------------------------------------------

    [System.__ComObject].InvokeMember('Restore', $bindingInvokeMethod, $null, $oFileRestore, $null)
	
    Write-Host "Restoring - " $fileToRestore.SrcDirPath$fileToRestore.SrcName
}

Write-Host "Restore Completed"





















