#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------

$strSourceFolder = "c:\test"
$strSourceDrive = "c:\"

$strDestFolder = "D:\test"

$v2iAuto = $null
$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"

$oNet = $null

# Connect to the server.

Write-Host "Connecting..."
try
{
   $oNet = New-Object -ComObject "Wscript.Network"
   $v2iAuto.Connect($oNet.ComputerName)
}
catch
{
    Write-Host "Failed to Connect with an Exception..."
    Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
    Write-Host $_.Exception.Message -ForegroundColor Red
    Write-Host "Exiting..."
    exit $1
}

#-------------------------------------------------------------------------------
# Create File Folder Job
#-------------------------------------------------------------------------------
$oImageJob = $null
$oImageJob = New-Object -ComObject "Veritas.VProRecovery.ImageJob"

#-------------------------------------------------------------------------------
# Create Selector object to hold the file/folder data to backup
#-------------------------------------------------------------------------------
$oSelector = $null
$oSelector = New-Object -ComObject "Veritas.FileBackup.Selector"

$oSelector.Folder = $strSourceFolder
$oSelector.IncludeSubFolders = $true
#-------------------------------------------------------------------------------
# Create the FileBackup object
#-------------------------------------------------------------------------------
$oFileBackup = $null
$oFileBackup = New-Object -ComObject "Veritas.FileBackup.FileBackup"
$oFileBackup.AddSelector($oSelector)
$oFileBackup.Destination = $strDestFolder


$oImageJob.Type = 4
$oImageJob.IncrementalSupport = $false
$oImageJob.DisplayName = "Recovary Point of FileFolderBackup"
$oImageJob.Reason = 1

$oImageJob.RunOnce = $false
$oImageJob.Compression = 9 

$oImageJob.FileBackup = $oFileBackup

$oImageJob.ForceNextBase = $true

$oVolume = $null
foreach($oTempVol in $v2iAuto.Volumes($false))
{
   if($oTempVol.MountPoint -eq $strSourceDrive)
   {
 	$oVolume = $oTempVol
   }
}

$oLocation = $null
$oLocation = New-Object -ComObject  "Veritas.VProRecovery.FolderLocation"
$oLocation.Path = $strDestFolder
$oLocation.FileSpec = $oNet.ComputerName + "C_DRIVE"

$oImageJob.Volumes = [Array]$oVolume.ID
$oImageJob.Location($oVolume.ID) = $oLocation

try
{
  $v2iAuto.AddImageJob($oImageJob)
}
catch
{
   Write-Host "Failed to add FoleFolder job."
   Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
   Write-Host $_.Exception.Message -ForegroundColor Red
   Write-Host "Exiting..."
   exit $1
}

Write-Host "Running job " $oImageJob.DisplayName "..."

try
{
     $v2iAuto.DoImageJob($oImageJob.ID, 4)
}
catch
{
     Write-Host "Failed to Run the FileFolder Job with an Exception..."
     Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
     Write-Host $_.Exception.Message -ForegroundColor Red
     Write-Host "Exiting..."
     exit $1
}



# IF USER WANTS TO REMOVE THIS JOB CALL
# $v2iAuto.RemoveImageJob($oImageJob.ID)

 Write-Host "Job completed successfully..."


























