﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
# 
#
#-----------------------------------------------------------------------------------------
#
#   Example Script: Delated restore
#   Objects Used: ProtectorAuto, RestoreJob, Destination, FolderLocation
#   Initialize the following variables with appropriate values:
#               1. oLocation- set the location 
#               2. RebootToRestore - set the parameter
#-----------------------------------------------------------------------------------------
    
    $v2iAuto = $null
	$oNet = $null
	$oDestination = $null
	$oTempDest = $null
	$oLocation = $null
	$oRestoreJob = $null
    $oVolume = $null
    $oTempVol = $null
	$obj = $null
    $oVar = $null
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: Delayed_Restore.ps1"
		exit $1;
	}
    
    #-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 4: Find the volume to image (the system volume in this case).
	#-----------------------------------------------------------------------------------------
	
    foreach($oTempVol in $v2iAuto.Volumes($false))
    {
		If ($oTempVol.System -eq $true)
        {
			$oVolume = $oTempVol
			break;
		}
	}

	if($oVolume -eq $null)
    {
		Write-Host "Delayed_Restore.ps1: Cannot find requested volume..."
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 5: Define the location from where the image will be restored. 
	#-----------------------------------------------------------------------------------------
	
	$oLocation = New-Object -ComObject "Veritas.VProRecovery.FolderLocation"
	$oLocation.Parse("E:\Veritas Backups\WIN-5Q6QIRT6BMT_C_Drive001.v2i")     #Parse path and set location properties
    
    #-----------------------------------------------------------------------------------------
	# Step 6: Create a restore job.
	#-----------------------------------------------------------------------------------------
	
	$oRestoreJob = New-Object -ComObject "Veritas.VProRecovery.RestoreJob"
	$oRestoreJob.DismountDestination = $false # In case the destination is currently in use
	$oRestoreJob.PreVerifyImage = $true        # Make sure the image is good before restoring it
	$oRestoreJob.Source = $oLocation           #Recovery point location
	
    foreach($oVar in $oVolume.Segments)
    {
	  $obj = $oVar.ID
	}
	$oRestoreJob.Destinations = [Array]$obj
    
    #-----------------------------------------------------------------------------------------
	# Step 7: Execute the restore job.
	#-----------------------------------------------------------------------------------------
    
    # Validate Restore destination
    try
    {
        $v2iAuto.ValidateRestoreDestination($oRestoreJob,[Array]$obj)
    }
    catch
    {        
        Write-Host "Failed to Validate Restore Destination with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
	
    Write-Host "Restoring..."
    try
    {
        # perform some operation here...
        $v2iAuto.RestoreImage($oRestoreJob)
    }
    catch
    {
        #skip ecxeption
    }
   
    # Prompt user for restoration permission since it requires reboot
    $result = [System.Windows.Forms.MessageBox]::Show("This operation cannot be performed while Windows is running. You must complete this operation inside the recovery environment. Would you like to Continue?",
    "Restore Image",
    [System.Windows.Forms.MessageBoxButtons]::YesNo,
    [System.Windows.Forms.MessageBoxIcon]::Question,
    [System.Windows.Forms.MessageBoxDefaultButton]::Button1)
    
    if ($result -eq [System.Windows.Forms.DialogResult]::Yes) 
    {
        [System.Windows.Forms.MessageBox]::Show("To Compelete the operation, insert the Veritas Recovery Disk CD and reboot the computer when prompted, press any key to boot from the CD into the recovery environment. You may need to adjust the BIOS settings on the computer to boot from the CD drive.",
        [System.Windows.Forms.MessageBoxButtons]::OK)
    }
    
    #Reboot the system to trigger system restore
    $v2iAuto.RebootToRestore("","","E:\Veritas Backups\WIN-5Q6QIRT6BMT_C_Drive001.v2i",0)
   
    Write-Host "Recovery point restored successfully..."