﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------
#
#  Example Script: Create an incremental image based on the passed-in base job ID.
#  Objects Used: ProtectorAuto, ImageJob, Volume, NetworkLocation.
#  Initialize the following variables with appropriate values:
#               sBaseJobID with the Job ID   
#-----------------------------------------------------------------------------------------
    
    $v2iAuto = $null
	$oNet = $null
	$sBaseJobID = $null
	$oBaseJob = $null
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: CreateIncrementalImage.ps1"
		exit $1;
	}
    
    # Initialize the Base Job ID
    $sBaseJobID = "{AF42CA4C-840A-4F8E-8E1B-80AAF07FC320}"
	
    #-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	 try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 4: Find the base backup job for the passed-in job ID.
	#-----------------------------------------------------------------------------------------
	
	try
    {
        $oBaseJob = $v2iAuto.ImageJob($sBaseJobID)
    }
    catch
    {
        Write-Host "Failed to find the base backup job with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
	if ($oBaseJob -eq $null)
    {
		Write-Host "CreateIncrementalImageNow.ps1. Cannot find specified job..."
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 5: Create an incremental image using the base backup job.
	#-----------------------------------------------------------------------------------------
    
	Write-Host "Creating Incremental Recovery Point..."
    try
    {
	    $v2iAuto.DoImageJob($oBaseJob.ID, $oBaseJob.Constants.ImageTypeIncremental)
    }
    catch
    {
        Write-Host "Failed to Create Incremental recovery point with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
	Write-Host "Incremental recovery point created successfully..."