﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------
#
#  Example Script: Create an image of the system drive to a passed-in network folder.
#  Objects Used: ProtectorAuto, ImageJob, Volume, NetworkLocation.
#-----------------------------------------------------------------------------------------
    
    $v2iAuto = $null
	$oNet = $null
	$oVolume = $null
	$oTempVol = $null
	$oNetLocation = $null
	$oImageJob = $null
	$sFolder = $null
    
    #-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	
	if ([int]$args.Length -ne 1) 
	{
		Write-Host "Usage: CreateImageNow.ps1 [UNC Network Path]"
		exit $1;
	}
    
    $sFolder = $args[0]
    
	#-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	 try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 4: Define the network location for saving the image (uses network location)
	#-----------------------------------------------------------------------------------------
    
	$oNetLocation = New-Object -ComObject "Veritas.VProRecovery.NetworkLocation"
	$oNetLocation.Path = $sFolder
	$oNetLocation.FileSpec = "SystemBackup"
	$oNetLocation.NetworkUser = "administrator"
	$oNetLocation.NetworkPassword = "be@Pun45"
    
    #-----------------------------------------------------------------------------------------
	# Step 5: Find the volume to image (the system volume in this case).
	#-----------------------------------------------------------------------------------------
	
    foreach($oTempVol in $v2iAuto.Volumes($false))
    {
		if($oTempVol.System -eq $true)
        {
			$oVolume = $oTempVol
            break;
        }
	}

	if($oVolume -eq $null)
    {
		Write-Host "CreateImageNow.ps1: Cannot find requested volume..."
        Write-Host "Exiting..."
        exit $1
    }
    
    #-----------------------------------------------------------------------------------------
	# Step 6: Create a manual image job that automatically removes itself after running.
	#-----------------------------------------------------------------------------------------
	
    $oImageJob = New-Object -ComObject "Veritas.VProRecovery.ImageJob"
	$oImageJob.IncrementalSupport = $false
	$oImageJob.DisplayName = "Recovery point of " + $oVolume.DisplayName
	$oImageJob.Description = "Test recovery point of the system volume."
	$oImageJob.Compression = $oImageJob.Constants.ImageCompressionLow
	$oImageJob.Reason = $oImageJob.Constants.ImageReasonManual
	$oImageJob.Volumes = [Array]$oVolume.ID
	$oImageJob.Location($oVolume.ID) = $oNetLocation
	$oImageJob.RunOnce = $true
    
    #-----------------------------------------------------------------------------------------
	# Step 7: Add the image job to the list of jobs.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Adding Image Job..."
    try
    {
        $v2iAuto.AddImageJob($oImageJob)
    }
    catch
    {
        Write-Host "Failed to Add Image Job with an Exception..."
        Write-Host $_.Exception.GetType().FullName  -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
	Write-Host "Image Job added successfully."
    
    #-----------------------------------------------------------------------------------------
	# Step 8: Run the image job immediately.
	#-----------------------------------------------------------------------------------------
    
	Write-Host "Creating image..."
    try
    {
	    $v2iAuto.DoImageJob($oImageJob.ID, $oImageJob.Constants.ImageTypeFull)
    }
    catch
    {
        Write-Host "Failed to Create Image with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
	Write-Host "Image created successfully..."
    
    