﻿#-----------------------------------------------------------------------------------------
#
# Veritas System Recovery 16 Automation
#
# Copyright (c) 2016 by Veritas Technologies LLC
# All Rights Reserved
#
# THIS SCRIPTING EXAMPLE IS PROVIDED IN CONJUNCTION WITH YOUR LICENSE FOR VERITAS 
# SYSTEM RECOVERY SOFTWARE PRODUCTS, AND MAY BE USED ONLY IN CONJUNCTION WITH 
# THAT SOFTWARE, UNDER THE TERMS OF THE END USER LICENSE AGREEMENT THAT ACCOMPANIED 
# THE SOFTWARE. THIS SCRIPTING EXAMPLE IS PROPRIETARY VERITAS PROPERTY.  YOU MAY NOT 
# COPY, DISTRIBUTE, LICENSE OR SUBLICENSE THE SCRIPTING DOCUMENTATION.
#
#-----------------------------------------------------------------------------------------
#
#   Example Script: Copy a volume to unallocated space.
#   Objects Used: ProtectorAuto, CopyJob, Destination.
#-----------------------------------------------------------------------------------------
    
    $v2iAuto = $null
	$oNet = $null
	$oVolume = $null
	$oTempVol = $null
	$oDestination = $null
	$oTempDest = $null
	$oCopyJob = $null
    
	#-----------------------------------------------------------------------------------------
	# Step 1: Process command line arguments.
	#-----------------------------------------------------------------------------------------
	if ([int]$args.Length -gt 0) 
	{
		Write-Host "Usage: CopyVolume.ps1"
		exit $1;
	}
	
	#-----------------------------------------------------------------------------------------
	# Step 2: Create a VProRecovery automation object.
	#-----------------------------------------------------------------------------------------
	
	$v2iAuto = New-Object -ComObject "Veritas.ProtectorAuto"
		
	#-----------------------------------------------------------------------------------------
	# Step 3: Connect to the local agent.
	#-----------------------------------------------------------------------------------------
	
    Write-Host "Connecting..."
	 try
    {
	    $oNet = New-Object -ComObject "Wscript.Network"
        $v2iAuto.Connect($oNet.ComputerName)
    }
    catch
    {
        Write-Host "Failed to Connect with an Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
    
	#-------------------------------------------------------------------------------------------
	# Step 4: Find the volume to copy (system).
	#-------------------------------------------------------------------------------------------
	
    foreach ($oTempVol in $v2iAuto.Volumes($false))
    {
		if($oTempVol.System -eq $true)
        {
		    $oVolume = $oTempVol
			break;
		}
    }
    
	if($oVolume -eq $null)
    {
		Write-Host "CopyVolume.ps1. Cannot find requested volume..."
        Write-Host "Exiting..."
        exit $1
    }
    
    #--------------------------------------------------------------------------------------------
	# Step 4: Find unallocated space to copy to.
	#--------------------------------------------------------------------------------------------
	
    foreach($oTempDest in $v2iAuto.Destinations)
    {
		if($oTempDest.Allocated -eq $false)
        {
			if($oTempDest.SizeMB -gt $oVolume.SizeMB)
            {
				$oDestination = $oTempDest
				break;
            }
        }
    }
    
	if($oDestination -eq $null)
    {
		Write-Host "CopyVolume.ps1. Cannot find a space to copy to volume..."
        Write-Host "Exiting..."
        exit $1
    }
    
    #----------------------------------------------------------------------------------------------
	# Step 5: Create a copy job.
	#----------------------------------------------------------------------------------------------
	
    $oCopyJob = New-Object -ComObject "Veritas.VProRecovery.CopyJob"
	$oCopyJob.CheckSourceFileSystem = $true
	$oCopyJob.DestinationMountPoint = "X:"
	$oCopyJob.Destinations = [Array]$oDestination.ID
	$oCopyJob.SourceVolumeID = $oVolume.ID
    
    #----------------------------------------------------------------------------------------------
	# Step 6: Run the copy job immediately.
	#----------------------------------------------------------------------------------------------
	
    Write-Host "Copying Volume..."
    try
    {
	    $v2iAuto.CopyVolume($oCopyJob)
    }
    catch
    {
        Write-Host "Copy Volume Failed with Exception..."
        Write-Host $_.Exception.GetType().FullName -ForegroundColor Red
        Write-Host $_.Exception.Message -ForegroundColor Red
        Write-Host "Exiting..."
        exit $1
    }
	Write-Host "Volume copied successfully..."