// Copyright Epic Games, Inc. All Rights Reserved.

using System.IO;

namespace UnrealBuildTool.Rules
{
    public class MagicBulletLooks : ModuleRules
    {
        public MagicBulletLooks(ReadOnlyTargetRules Target) : base(Target)
        {
            PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

            PublicDependencyModuleNames.AddRange(
                new string[] {
                    "ApplicationCore",
                    "Core",
                    "CoreUObject",
                    "Engine",
                    "Slate",
                    "SlateCore",
                    "UnrealEd",
                    "RHI",
                    "RenderCore",
                });

            PrivateIncludePathModuleNames.AddRange(
            new string[] {
                "Renderer",
            });

            string engine_path = Path.GetFullPath(Target.RelativeEnginePath);

            PrivateIncludePaths.AddRange(
            new string[] {
                //required for FPostProcessMaterialInputs
                System.IO.Path.Combine(engine_path, "Source/Runtime/Renderer/Private"),
                "version",

				// Require some RG git repos, note that all of those are setuped as submodules to this repos.
				//
				//		- maxon-one-api (repo)		-> develop (branch)
				//		- rglicensing (repo)		-> develop (branch)
				//		- mxanalytics (repo)		-> develop (branch)
				//		- magicbulletlooks (repo)	-> develop (branch)
				//		- foundation (repo)			-> develop (branch)
				//				
				"maxon-one-api/include",
                "mxanalytics/include",
                "rglicensing/src",
                "rglicensing/src/fuse",
                "foundation",
                "../../../../../helper"
            });

            PrivateDefinitions.Add("FUSE_LICENSING_ENABLED=1");

            if (Target.Platform == UnrealTargetPlatform.Win64)
            {
                PrivateDefinitions.Add("MAXON_TARGET_WINDOWS=1");

                //PublicSystemLibraryPaths.AddRange(
                //    new string[] {
                //        Path.Combine(ModuleDirectory, "../foundation/contrib/boost/win/lib")
                 //   });

                //PublicAdditionalLibraries.Add(Path.Combine(ModuleDirectory, "../foundation/win/x64/ReleaseMD/RGFramework.lib"));
            }
            else if (Target.Platform == UnrealTargetPlatform.Mac)
            {
                PrivateDefinitions.Add("MAXON_TARGET_MACOS=1");
                if(Target.Version.MajorVersion == 4)
                {
                    PrivateDefinitions.Add("UNREAL_ENGINE_4_27_MACOS=1");
                }
            }

            CppStandard = CppStandardVersion.Cpp17;

            // Root causes of #ifdef() issues. Disable this, ensure to disable the warning+errors.
            bEnableUndefinedIdentifierWarnings = false;
        }
    }
}
