// Copyright 1998-2017 Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;
using System.IO;

public class MagicBulletLooksEditor : ModuleRules
{
    public MagicBulletLooksEditor(ReadOnlyTargetRules Target) : base(Target)
    {
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;

        DynamicallyLoadedModuleNames.AddRange(
            new string[] {
                "AssetTools",
                "MainFrame"
            });

        PrivateIncludePaths.AddRange(
            new string[] {
                "MagicBulletLooks/Private",
                "MagicBulletLooksEditor/Private",
                "MagicBulletLooksEditor/Private/Factories",
                "MagicBulletLooksEditor/Private/Widgets"
            });

        PublicDependencyModuleNames.AddRange(
        new string[] {
            "Core",
            "CoreUObject",
            "DesktopWidgets",
            "Engine",
            "InputCore",
            "PropertyEditor",
            "Slate",
            "SlateCore",
            "ToolMenus",
            "UnrealEd",
            "Blutility",
            "UMG",
            "RHI",
            "RenderCore"
        });

        PrivateDependencyModuleNames.AddRange(
            new string[] {
                "ContentBrowser",
                "Core",
                "CoreUObject",
                "DesktopWidgets",
                "EditorStyle",
                "Engine",
                "InputCore",
                "Projects",
                "Slate",
                "SlateCore",
                "UnrealEd",
                "LevelEditor",
                "MagicBulletLooks"
            });

        PrivateIncludePathModuleNames.AddRange(
            new string[] {
                "AssetTools",
                "UnrealEd",
            });

        // style logo image
        PublicIncludePaths.Add(Path.Combine(EngineDirectory, "Source", "Runtime", "Projects", "Public", "Interfaces"));

        // ColorPicker
        PublicIncludePaths.Add(Path.Combine(EngineDirectory, "Source", "Runtime", "AppFramework", "Public"));

        PrivateIncludePaths.AddRange(new string[] { "maxon-one-api/include", "foundation" });

        if (Target.Platform == UnrealTargetPlatform.Win64)
        {
            PrivateDefinitions.Add("MAXON_TARGET_WINDOWS=1");

            //PublicSystemLibraryPaths.AddRange(
            //    new string[] {
            //        Path.Combine(ModuleDirectory, "../foundation/contrib/boost/win/lib")
            //    });

            //PublicAdditionalLibraries.AddRange(
            //     new string[] {
            //        Path.Combine(ModuleDirectory, "../foundation/win/x64/ReleaseMD/RGFramework.lib")
            //        //Path.Combine(ModuleDirectory, "../foundation/contrib/boost/win/lib/libboost_system-vc142-mt-1_55.lib")
            //     });
        }
        else if (Target.Platform == UnrealTargetPlatform.Mac)
        {
            PrivateDefinitions.Add("MAXON_TARGET_MACOS=1");
            //PublicAdditionalLibraries.Add(Path.Combine("foundation/", "");
            
            if(Target.Version.MajorVersion == 4)
            {
                PrivateDefinitions.Add("UNREAL_ENGINE_4_27_MACOS=1");
            }
        }

        CppStandard = CppStandardVersion.Cpp17;

        // Root causes of #ifdef() issues. Disable this, ensure to disable the warning+errors.
        bEnableUndefinedIdentifierWarnings = false;
    }
}
