// ==UserScript==
// @name    视频捕获
// @version    1.0
// @author    hunmer
// @description    视频捕获
// @namespace    02be9190-74c2-4852-a788-6af74224eb87

// ==/UserScript==

({
init() {
        g_plugin.menu_add({
            title: '捕获视频',
            action: 'ms_modal'
        })
        g_action.registerAction({
            ms_modal() {
                self.show()
            }
        })
        this.show()
    },

    show() {
        let path = g_plugin.getSciptPath()+"mediaSource\\"
        let win = new nodejs.remote.BrowserWindow({
            title: '媒体捕获器',
            width: 1450,
            height: 970,
            webPreferences: {
                preload: path + 'preload.js',
                nodeIntegration: true,
                contextIsolation: true,
            }
        })
        let web = win.webContents
        win.setMenu(nodejs.remote.Menu.buildFromTemplate([{
            label: '菜单',
            submenu: [{
                label: '打开下载目录',
                click() {
                    ipc_send('openFolder', path + 'tts\\')
                }
            }, ]
        }]))
        win.loadURL('https://www.bilibili.com/video/BV12G411c7bb/?p=4&vd_source=78b546d315de30f21b9cbb125d639855', { userAgent: 'Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.134 Safari/537.36 Edg/103.0.1264.71' })
        web.on('did-navigate', function(event) {
            // win.openDevTools()
            console.log('aa')
            web.executeJavaScript(nodejs.files.read(path + 'main.js'))
        })
        web.on('ipc-message', (e, channel, ...args) => {
            switch (channel) {
                case 'test':
                    let files = args[0]
                    console.log(files)
                    let saveTo = 'I:\\software\\mLauncher\\resources\\app\\videoPlayer\\scripts\\mediaSource\\download\\output.mp4';
                    new nodejs.cli.ffmpeg(files[0], {progress: true})
                    .outputOptions(['-i "'+files[1]+'"'])
                    .on('start', console.log)
                    .on('progress', progress => console.log(progress))
                    .on('error', console.error)
                    .on('end', () => console.log('ok'))
                    .save(saveTo)
                    return

                case 'exit':
                    return win.close()
                case 'devtool':
                    return web.toggleDevTools()
            }
        });

    },

}).init()
