const { contextBridge, ipcRenderer } = require('electron');

window.addEventListener('DOMContentLoaded', () => {
    const script = document.createElement('script');
    script.textContent = `
    (() => {
        const sourceBufferProto = window.MediaSource.prototype.addSourceBuffer;
        window.MediaSource.prototype.addSourceBuffer = function () {
        const sourceBuffer = sourceBufferProto.apply(this, arguments);
        const appendBufferProto = sourceBuffer.appendBuffer;
        sourceBuffer.appendBuffer = function (buffer) {
            const data = new Uint8Array(buffer);
            window.electron.sendAppendBufferData(data);
            appendBufferProto.call(sourceBuffer, buffer);
        };
        return sourceBuffer;
        };
    })();
    `;
    document.head.appendChild(script);
});

contextBridge.exposeInMainWorld('electron', {
  sendAppendBufferData: (data) => {
    ipcRenderer.send('appendBufferData', data);
  },
  onAppendBufferDataSaved: (callback) => {
    ipcRenderer.on('appendBufferDataSaved', (event, message) => {
      callback(message);
    });
  },
});



