
const fs = require('fs')
const { Readable } = require('stream');
// const { getCurrentWindow, getCurrentWebContents } = require('@electron/remote');
const { contextBridge, ipcRenderer } = require('electron')

// const _app = getCurrentWindow();
// const _webContent = getCurrentWebContents();
const saveAs = async (blob, name) => {
    let dir = __dirname + "\\download\\";
    if (!fs.existsSync(dir)) fs.mkdirSync(dir);
    let saveTo = dir + name
    fs.writeFileSync(saveTo, new Int8Array(await blob.arrayBuffer()));
    return saveTo
}
contextBridge.exposeInMainWorld('electron', {
    saveAs,
    test(list) {
        Promise.all(list.map(([blob, fileName]) => {
            return saveAs(blob, fileName)
        })).then(files => {
            console.log(files)
            send('test', files)
        })
    }
})

window.addEventListener('DOMContentLoaded', function (e) {
    window.addEventListener('keydown', (ev) => {
        let key = ev.key.toLowerCase()
        switch (key) {
            case 'w':
                return ev.ctrlKey && send('exit')
            case 'f11':
                return toggleFullScreen();
            case 'f12':
                return send('devtool')
            case 'f5':
                return location.reload();
        }
    })

    
})

function send(channel, args = {}) {
    ipcRenderer.send(channel, args)
}

function toggleFullScreen() {
    if (!document.fullscreenElement && // alternative standard method
        !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) { // current working methods
        if (document.documentElement.requestFullscreen) {
            document.documentElement.requestFullscreen();
        } else if (document.documentElement.msRequestFullscreen) {
            document.documentElement.msRequestFullscreen();
        } else if (document.documentElement.mozRequestFullScreen) {
            document.documentElement.mozRequestFullScreen();
        } else if (document.documentElement.webkitRequestFullscreen) {
            document.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
        }
        $(window).resize();
        return true;
    }
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    }
    $(window).resize();
    return false;
}