// ==UserScript==
// @name    m3u播放
// @version    1.0
// @author    hunmer
// @description    支持m3u播放播放
// @namespace    3245ff06-8adb-433d-b234-1cd08374de44

// ==/UserScript==
var g_playlist1 = {
    init(){

    
        g_files.exts.push('m3u')
        g_plugin.registerEvent('beforePlayerInit', ({config}) => {
            let {url} = config.video
            let ext = getExtName(url).toLowerCase()
            if(ext == 'm3u'){
                let title
                let list = []
                nodejs.files.read(url).split('\n').forEach(line => {
                    line = line.replace('\r', '')
                    if(line.startsWith('#EXTINF:')){
                        title = popString(line, ',')
                    }else
                    if(title != undefined && line.toLowerCase().startsWith('http')){
                        list.push({title, url: line})
                    }
                })
                if(!list.length) return toast('没有捕获到节点！', 'danger')

                let html = list.map(({title, url}) => `
                    <a href="#" class="list-group-item list-group-item-action" data-action="m3u_item_play" data-videourl="${url}">
                        ${title}
                    </a>
                `).join('')
                $('#left_playlist_content').html(`
                    <div class="list-group list-group-flush">${html}</div>                
                `)
            }
        })

        g_action.registerAction({
            m3u_item_play(dom){
                let title = dom.outerText
                let url = dom.dataset.videourl
                g_player.newTab({ value: url, title})
            }
        })
    }

}
g_playlist1.init()
g_leftTabs.register('playlist', {
    onTabChanged: () => {},
    tab: {
        id: 'playlist',
        icon: 'list',
        title: '节点',
        html: `
            <div class="overflow-y-auto h-full p-2 overflow-hidden" id="left_playlist">
                <div class="input-group mb-2">
                    <input type="text" class="form-control" placeholder="搜索...">
                    <button class="btn" type="button"><ti class="ti ti-refresh fs-2"></ti></button>
                </div>
                <div id="left_playlist_content"></div>
            </div>
        `
    },
}, g_playlist1)
