// ==UserScript==
// @name    everything搜索
// @version    1.0
// @author    hunmer
// @description    提供everything各种接口功能
// @namespace    72eaf031-1809-4434-9709-74c42dc3e405

// ==/UserScript==

var g_everything = {
    api: 'http://192.168.31.3:8080',
    // api: 'http://127.0.0.1:8080',
    init() {
        let workerFile = g_plugin.getSciptPath()+'everything_worker.js'
        nodejs.files.write(workerFile,  `
            addEventListener('message', async e => {
                let { id, data } = e.data
                let [method, ...args] = data
                postMessage({ ret: await this[method].apply(this, args), id });
            })
            
            function createThumbnailFromPath(file, opts){
                return new Promise(reslove => {
                    ${!nodejs.win.isWin7 ? "require('electron').nativeImage.createThumbnailFromPath(file, opts).then(ret => reslove(ret.toDataURL()))" : ''}
                })
           }
        `)
        this.worker = new Worker_IPC(workerFile)

        self.config = getConfig('everything_settings', {

        })
        g_action.registerAction({
            everything_search: (dom, action, e) => {
                if(e.keyCode == 13){
                    let val = dom.value
                    if(!isEmpty(val)) this.search({ 
                        search: {
                            video: '',
                            sort: 'size', // 按大小排序
                            startwith: "//", // 过滤本地文件
                            name: val.split(' ')
                        }, rule: {
                            name: ' ' // |
                        }, path_column: 1  }).then(data => this.setData(data))
                }
            },
            everything_nextPage: () => this.nextPage(1),
            everything_prevPage: () => this.nextPage(-1),
            everything_addFile: dom => {
                let parent = getParent(dom, '[data-file]')
                let {type, file} = parent.data()
                let r = {files: [], dirs: []}
                r[type == 'file' ? 'files' : 'dirs'].push(file)
                g_fileDrop.list.files_videos.onParse(r)
            },
            everything_openFolder: dom => ipc_send('openFolder', getParentData(dom, 'file'))
        })
        
       
        // this.search({ search: '我们的', path_column: 1  }).then(console.log)
        // this.search({ 
        // search: {
        //     ext: 'mp4',
        //     name: ['董卿']
        // }, rule: {
        //     name: '|'
        // }, path_column: 1  }).then(data => this.setData(data))
    },

    setData(data){
        console.log(data)
        if(data.totalResults){
            this.data = data.results
            this.showPage(0)
        }else{
            toast('没有任何结果')
        }
    },

    nextPage(offset){
        this.showPage(this.currentPage + offset)
    },

    showPage(page){
        let limit = 25
        let len = this.data.length
        this.maxPage = parseInt(len / limit) + 1

        if(page < 0) page = 0
        if(page >= this.maxPage) page = this.maxPage
        this.currentPage = page

        let start = page * limit
        let html = this.data.slice(start, start + limit).map(({name, path, type}) => {
            return `
            <div class="list-group-item" ${type == 'file' ? 'data-out="item_unpreview"' : ''}>
                <div class="row align-items-center position-relative" data-type="${type}" data-file="${path+'/'+name}" draggable="true"  >
                    <div class="col-auto">
                        <a href="#" >
                            <img class="lazy hideOnPreview" src="res/loading.gif" ${type == 'file' ? 'data-hover="item_preview" data-hoverTime="1000"' : ''} width="100">
                        </a>
                    </div>
                    <div class="col text-truncate">
                        <a href="#" data-action="everything_addFile" class="text-reset d-block">${name}</a>
                        <a href="#" data-action="everything_openFolder" class="d-block text-muted text-truncate mt-n1" >${path}</a>
                    </div>
                </div>
            </div>
            `
        }).join('')

        $('#everything_results').html(`
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">${len}个搜索结果</h3>
                </div>
                <div class="list-group list-group-flush">
                    ${html}
                </div>
            </div>
        `)
        if(this.observer) this.observer.disconnect()
        this.observer = new IntersectionObserver(entries => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    let file = getParentData(img, 'file')
                    this.worker.send(['createThumbnailFromPath', file, {width: 100, height: 100}], imgData => {
                        img.src = imgData;
                        img.classList.remove('lazy');
                    })
                    this.observer.unobserve(img);
                }
            })
        });
      document.querySelectorAll('.lazy').forEach(img => this.observer.observe(img));
    },

    http(opts){
        return new Promise((reslove, reject) => {
            $.getJSON(this.api, Object.assign({ json: 1}, opts), (data, textStatus) => {
                if (textStatus == 'success') reslove(data)
            })
        })
    },

    search(opts){
        let {search, rule} = opts
        if(typeof(search) == 'object'){
            opts.search = Object.entries(search).map(([k, v]) => {
                return toArr(v).map(val => `${k}:"${val}"`).join(rule[k] ?? ' ')
            }).join(' ') + ' ' + $('#everything_params').val()
        }
        console.log(opts)
        return this.http(opts)
    },
}

g_detailTabs.register('everything', {
    onTabChanged: old => {

    },
    tab: {
        id: 'everything',
        icon: 'search',
        title: ' ',
        html: `
        <div class="p-2">
            <div class="input-group sticky-top" style="z-index: 1">
                <i class="ti ti-search fs-2 position-absolute" style="left: 10px;top: 8px;z-index: 999;"></i>
                <input style="padding-left: 35px;" type="text" class="form-control" placeholder="搜索文件..." data-keydown="everything_search" value="刘强东">
                <input style="max-width: 75px;" type="text" class="form-control" id="everything_params" placeholder="其他参数" value="">
                <button class="btn" data-action="everything_prevPage">
                    <i class="ti ti-arrow-left"></i>
                </button>
                <button class="btn" data-action="everything_nextPage">
                    <i class="ti ti-arrow-right"></i>
                </button>
            </div>
            <div class="overflow-y-auto h-full" style="padding-bottom: 200px;" id="everything_results">

            </div>
        </div>
            `
    },

    // <button data-bs-toggle="dropdown" type="button" class="btn dropdown-toggle dropdown-toggle-split" aria-expanded="false"></button>
    // <div class="dropdown-menu dropdown-menu-end">
    //     <a class="dropdown-item" data-action="everything_settings">设置</a>
    // </div>
}, g_everything)

