// ==UserScript==
// @name    everything_server
// @version    1.0
// @author    hunmer
// @description    everything服务器
// @namespace    f3953cde-e9cd-43e8-8fca-1aab1de8fbc7

// ==/UserScript==

(() => {
    const dir = g_plugin.getSciptPath()+'everything_server\\'
    const nativeImage = nodejs.require('electron').nativeImage
    const express = nodejs.require(dir+'node_modules\\express');
    const cors = nodejs.require(dir+'node_modules\\cors');
    const nocache = nodejs.require(dir+'node_modules\\nocache');
    const app = express();
    app.use(cors());
    app.use(nocache());
    app.use(express.static(dir));
    // app.use((req, res, next) => {
    //     console.log(
    //         `请求的ip地址是：${req.ip}, 请求的路径是：${
    //         req.url
    //         }`);
    //     next();
    // });
    app.listen(8081);

    app.get('/search', (req, res) => {
        $.getJSON('http://127.0.0.1:8080', Object.assign({ json: 1 }, req.query), (data, textStatus) => {
            if (textStatus == 'success') echoJson(res, data)
        })
    });

    app.get('/cover', (req, res) => {
        let path = req.query.path
        let id = nodejs.files.getMd5(path)
        let saveTo = dir+'covers\\'+id+'.jpg'
        const cb = () => {
            writeHead(res, 301, {Location: 'http://192.168.31.3:8081/covers/'+id+'.jpg'})
        }
        if(!nodejs.files.exists(saveTo)){
            g_ffmpeg.video_cover({
                input: path,
                output: saveTo,
                time: 1,
            }, () => cb())
            // nativeImage.createThumbnailFromPath(path, {width: 100, height: 100})
            // .then(image => {
            //     nodejs.files.makeSureDir(saveTo)
            //     nodejs.fs.writeFile(saveTo, image.toPNG(), err => {
            //         if(!err) cb()
            //     })
            // })
        }else{
            cb()
        }
    });

    function writeHead(res, code, data1, data2) {
        res.setHeader("Access-Control-Allow-Origin", "*");
        res.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
        res.writeHead(code, data1);
        res.end(data2);
    }

    function echoJson(res, data) {
       return writeHead(res, 200, { 'Content-Type': 'application/json' }, JSON.stringify(data))
    }

})()
