const fs = require('fs')
const WebSocketServer = require('ws').Server;
const config_file = __dirname + '/config.json'

fs.readJSONSync = function(file){
    return JSON.parse(this.readFileSync(file))
}
fs.writeJSONSync = function(file, data){
    return this.writeFileSync(file, JSON.stringify(data))
}
if (!fs.existsSync(config_file)) fs.writeJSONSync(config_file, {
    websocket_port: 40000,
    http_port: 40001
})
const config = fs.readJSONSync(config_file)
const saveConfig = () => fs.writeJSONSync(config_file, config)
const wss = new WebSocketServer({ port: parseInt(config.websocket_port) });
wss.on('connection', ws => {
    ws.on('message', msg => onMessage(JSON.parse(msg), ws))
});
function onMessage({ type, data }, ws) {
    switch (type) {
        case 'exit':
            return process.exit()
        case 'heart':
            ws.meta = data
            return update(data)
        case 'connected':
            ws._type = data.type
            // ws._name = d.name
            return sendMsg(ws, 'config', config);
    }
}

function findClient(cb){
    return Array.from(wss.clients).find(cb)
}

const express = require('express');
const app = express();
app.listen(parseInt(config.http_port));

var shutdown = 0
setInterval(() => {
    Object.keys(onlines).forEach(id => {
        if(!findClient(ws => ws.meta.id == id)){
            delete onlines[id]
        }
    })
    if(Object.keys(onlines).length == 0){
        if(++shutdown >= 10) process.exit() // 自动关闭
    }else{
        shutdown = 0
    }
}, 3000)

const onlines = {}
registerApi([
    ['/api/send', 'get',(res, req) => {
        let {app, method, data, id} = req.query
        let apps = Object.values(onlines).filter(item => item.app == app)
        let len = apps.length
        if(len == 0) return echoJson(res, {code: -1}) // 没有找到应用
        let find = len > 1 ? apps.find(item => item.id == id) : apps[0]
        if(!find) return echoJson(res, {code: 2, data: apps}) // 让选择一个应用

        let ws = findClient(ws => ws.meta.id == find.id)
        if(ws){
            sendMsg(ws, 'doMethod', {method, data})
            echoJson(res, {code: 1})
        }else{
            echoJson(res, {code: -2}) // 没有找到后台程序
        }
    }],
    ['/api/online', 'get',(res, req) => {
        update(req.query)
        echoJson(res, {ok: true})
    }],
    ['/api/onlines', 'get', (res, req) => {
        echoJson(res, onlines)
    }]
])

function update({app, online, id}){
    if(online){
        onlines[id] = {
            app, id,
            date: Date.now(),
        }
    }else{
        delete onlines[app]
    }
}

function registerApi(...args) {
    const register = ([url, type, callback]) => {
        app[type](url, (req, res) => callback(res, req))
    }
    if (Array.isArray(args[0])) {
        args[0].forEach(register)
    } else {
        register(args)
    }
    return registerApi
}

function echoJson(res, data) {
    res.setHeader("Access-Control-Allow-Origin", "*");
    res.setHeader("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    res.writeHead(200, { 'Content-Type': 'application/json' });
    res.end(JSON.stringify(data));
}

// 给ws发送消息
function sendMsg(client, type, data) {
    data = JSON.stringify({ type, data })
    toArr(client).forEach(ws => ws.send(data))
}

function toArr(arr) {
    return Array.isArray(arr) ? arr : [arr]
}

function getClients(type = 'client') {
    let ret = []
    for (let ws of wss.clients) {
        if (ws => ws._type = type) ret.push(ws)
    }
    return ret
}

