

const _url = require('url')
const path = require('path')
const _dataPath = path.resolve(__dirname, '../').replaceAll('\\', '/') + '/'
const { app, ipcRenderer, clipboard, shell, protocol } = require('electron');
const remote = require('@electron/remote');
const { getCurrentWindow, getCurrentWebContents, webContents, session, globalShortcut, Menu, Tray, net } = remote
const files = require(_dataPath + 'public/file.js')

const fs = require('fs-extra')
const request = require('request');
const _app = getCurrentWindow()
const _webContent = getCurrentWebContents()
_webContent.on('did-attach-webview', (event, webContents) => {
    webContents.setWindowOpenHandler(data => {
        g_plugin.callEvent('webview_openURL', { data, webContents }).then(({ret}) => {
            return ret || { action: 'deny' }
        });
    })
})


window.nodejs = {
    clipboard, fs, url: _url,
    platform: process.platform,
    win: _app,
    iconv: require('iconv-lite'),
    require, remote, files,
    session, net, globalShortcut,
    path, shell, request,
    dir: __dirname.replaceAll('\\', '/'),
    bin: _dataPath + 'public/bin/',
    cli: require(_dataPath + 'public/cli.js'),
    method(data) {
        let d = data.msg;
        switch (data.type) {
            case 'openFile':
                if(nodejs.platform == 'darwin'){
                    nodejs.cli.run('open', d)
                }else{
                    shell.openPath(d.replaceAll('/', '\\'))
                }
                return
            case 'url':
                return shell.openExternal(d);
            case 'reload':
                return location.reload()
            case 'copy':
                clipboard.writeText(d)
                return toast && toast('复制成功', 'success')
            case 'toggleFullscreen':
                return _app.setFullScreen(!_app.fullScreen);
            case 'openFolder':
                if(nodejs.platform == 'darwin'){
                    nodejs.cli.run('open', d)
                }else{
                    shell.showItemInFolder(d.replaceAll('/', '\\'))
                }
                return 
            case 'devtool':
                return _webContent.toggleDevTools()
            case 'ondragstart':
                let files = d.files.filter(file => fs.existsSync(file))
                // todo 检查图片编码，（webp不支持)
                // let icon = d.icon
                // if(isEmpty(icon) || this.platform == 'darwin') 
                let icon = _dataPath + 'public/files.png'
                if (files.length > 0) _webContent.startDrag({ files, icon })
                return
            case 'saveAsZip':
                return saveAsZip(d, ret => _webContent.send('callback', ret));
            default:
                send(data);
                break;
        }
    }
}

_webContent.session.setSpellCheckerEnabled && _webContent.session.setSpellCheckerEnabled(false)
// _webContent.openDevTools()
var _config = require(_dataPath + 'public/config.js')(nodejs.dir + '/states.json')

async function downloadFile(opts) {
    let progress = 0;
    let total_bytes = 0;
    let received_bytes = 0;
    let url = new URL(opts.url).href
    opts.proxy ??= typeof(g_proxy) != 'undefined' ? await g_proxy.getProxyByURL(opts.url) : undefined

    let fileBuff = [];
    opts = Object.assign({
        complete: () => { },
        progress: () => { },
    }, opts)
    let req = request({
        ...(opts.args || {}),
        url,
        method: 'GET',
        timeout: 15000,
        proxy: checkStartsWith(opts.proxy, 'http://'),
    });
    req.on('data', chunk => {
        received_bytes += chunk.length;
        fileBuff.push(Buffer.from(chunk));
        let newProgress = (received_bytes / total_bytes * 100).toFixed(2);
        if (newProgress != progress) {
            progress = newProgress;
            opts.progress(progress);
        }
    })
    req.on('end', () => {
        let totalBuff = Buffer.concat(fileBuff);
        if (opts.saveTo) {
            let tempFile = opts.saveTo + '.temp'
            let err = nodejs.files.write(tempFile, totalBuff)
            if (!err) {
                nodejs.fs.removeSync(opts.saveTo)
                nodejs.fs.renameSync(tempFile, opts.saveTo)
                opts.complete(opts.saveTo, opts.url)
            } else {
                console.error(err) & toast(err.toString(), 'danger')
            }
        } else {
            opts.complete(totalBuff.toString())
        }
    })
    req.on('response', data => total_bytes = parseInt(data.headers['content-length']))
    req.on('error', err => opts.complete(err));
    return req
}

// 注册ipc
function registerIPC(...args) {
    const register = ([name, cb]) => ipcRenderer.on(name, (event, args) => cb(args, event))
    if (typeof (args[0]) == 'object') {
        Object.entries(args[0]).forEach(register)
    } else {
        register(...args)
    }
}

// 来自主进程的事件
registerIPC({
    exit: () => {
        // g_launch && g_launch.sendOnline(false)
        typeof(g_plugin) != 'undefined' && g_plugin.callEvent('app_exit')
    },
    event: ({ name, data }) => {
        _callEvent('window_' + name, data)
    },
    fileDialog_revice: ({ id, paths }) => g_pp.call(id, paths),
    log: args => console.log(args),
    method: args => doAction(args),
    togglePin: active => getEle('pin').toggleClass('text-primary', active),
    newTab: ({ id, url }) => {
        alert('过时方法！')
        g_tabs.group_newTab(id, url)
    },
    closeTab: args => alert('过时方法！') && g_tabs.ids_remove(args),
});


// 记住程序位置
function savePos(bounds) {
    typeof(g_pp) != 'undefined' && g_pp.setTimeout('save_pos', () => {
        _config.set('position', bounds)
    }, 250)
}
_config.test('position', bounds => {
    _config.get('alwaysRestore') !== true && typeof (bounds) == 'object' && _app.setBounds(bounds)
    _app.show()
})

function onToggleMaximize(active){
    setCssVar('--bottom', (active ? '15' : '0') + 'px') // 窗口最大化底部会超过
}

onToggleMaximize(_app.isMaximized())

registerIPC({
    move: savePos,
    resize: savePos,
    maximize: () => onToggleMaximize(true),
    unmaximize: () => onToggleMaximize(false),
})

// 发送ipc消息
function send(data, method = 'method') {
    if (typeof (data) != 'object') data = { type: data }
    ipcRenderer.send(method, data);
}

// 消息提示
function notifiMsg(title, opts) {
    let {duration} = opts = Object.assign({
        body: opts.text ?? '',
        icon: opts.icon ?? './favicon.png',
        silent: opts.slient,
        // timeoutType: 'default',
        // timeout: 10000
    }, opts)

    let obj = new Notification(title, opts);
    duration && setTimeout(() => obj.close(), duration);
    ['onclick', 'onclose', 'onshow'].forEach(eventName => {
        obj[eventName] = function (e) {
            opts[eventName] && opts[eventName](e);
        }
    })
    return obj;
}

function showMessage(title, text) {
    notifiMsg(title, {
        text,
        onclick() {
            ipc_send('show');
        }
    });
}

function netRequest(opts) {
    return new Promise(reslove => {
        if (typeof (opts) != 'object') opts = { url: opts }
        const req = nodejs.net.request(Object.assign({
            method: 'GET',
            session: nodejs.remote.session.defaultSession,
            useSessionCookies: true,
            headers: {
                // 'Content-Type': 'application/x-www-form-urlencoded;charset=UTF-8',
                'user-agent': 'Mozilla/5.0 (Linux; U; Android 4.0.2; en-us; Galaxy Nexus Build/ICL53F) AppleWebKit/534.30 (KHTML, like Gecko) Version/4.0 Mobile Safari/534.30'
            }
        }, opts))

        let raw = ''
        let cb = () => new Promise(ret => {
            req.on('abort', () => {
                ret(false)
            })
            req.on('response', (response) => {
                if (response.statusCode == 200) {
                    let timeout = setTimeout(() => req.abort(), 5000)
                    response.on('data', data => raw += data)
                    response.on('end', () => {
                        clearTimeout(timeout)
                        ret(raw)
                    })
                } else {
                    ret(false)
                }
            })
            req.end()
        })
        reslove({
            text() {
                return new Promise(reslove => cb().then(raw => reslove(raw.toString())))
            },
            json() {
                return new Promise(reslove => cb().then(raw => reslove(JSON.parse(raw.toString()))))
            },
            buffer() {
                return new Promise(reslove => cb().then(raw => reslove(Buffer.from(raw))))
            }
        })
    })

}

function unZip(opts, onDone, onError) {
    const unzipper = require('unzipper')
    let extra = steam => {
        steam.pipe(unzipper.Extract({ path: output }))
            .promise()
            .then(() => onDone(), e => onError(e.toString()));
    }
    let found
    let { input, output, check } = opts
    let obj = fs.createReadStream(input).on('error', e => onError(e.toString()));
    if (check) {
        obj.pipe(unzipper.Parse())
            .on('entry', function (entry) {
                if (!found && check(entry)) {
                    found = true
                    extra(fs.createReadStream(input))
                    return false
                }
                entry.autodrain();
            })
            .on('finish', () => {
                if (!found) return onError('没找到文件')
            })
    } else {
        extra(obj)
    }
}

// 打包文件
async function saveAsZip(data, callback) {
    let { saveTo, files, fileName } = data
    if (!saveTo) {
        saveTo = await openFileDialog({
            title: '选择保存位置',
            defaultPath: fileName,
            properties: ['openFile'],
            filters: [{ name: '压缩文件', extensions: ['zip'] }],
        })
        if (!saveTo) return
    } else {
        saveTo += '/' + fileName
    }

    const archiver = require('archiver');
    const output = fs.createWriteStream(saveTo);
    const archive = archiver('zip', { zlib: { level: 9 } });
    output.on('close', () => callback && callback(Object.assign({ type: 'zip_complete', saveTo, size: archive.pointer() })));

    const showErr = err => dialog.showErrorBox('打包失败', err.toString());
    archive.on('warning', showErr);
    archive.on('error', showErr);
    archive.pipe(output);
    for (let [file, name] of Object.entries(files)) {
        if (fs.existsSync(file)) {
            archive.file(file, { name: name + path.extname(file) });
        }
    }
    archive.finalize();
}
