const { app, BrowserWindow, BrowserView, ipcMain, Menu, shell, dialog, session, Tray, screen, protocol } = require('electron')
const child_process = require('child_process');
const path = require('path')
const fs = require('fs-extra')
const remote = require("@electron/remote/main")
const platform = process.platform
const _appPath = app.isPackaged ? path.join(process.resourcesPath, 'app') : path.resolve(__dirname, '../')
const files = require(_appPath+'/public/file.js')
app.commandLine.appendSwitch("lang", 'en-US');
// app.commandLine.appendSwitch("disable-http-cache");
// app.commandLine.appendSwitch('wm-window-animations-disabled');
// app.disableHardwareAcceleration()
// app.commandLine.appendSwitch('enable-features', 'DocumentPictureInPictureAPI');
// app.commandLine.appendSwitch('js-flags', '--expose-gc');
dialog.showErrorBox = function (title, content) {
    console.log(title, content)
}

var win;
var currentView
let menu_iems = []
if (process.platform == 'darwin') {
    menu_iems.push(...[{
        label: "Application",
        submenu: [
            { label: "About Application", selector: "orderFrontStandardAboutPanel:" },
            { type: "separator" },
            { label: "Quit", accelerator: "Command+Q", click: function () { app.quit(); } }
        ]
    }, {
        label: "Edit",
        submenu: [
            { label: "Undo", accelerator: "CmdOrCtrl+Z", selector: "undo:" },
            { label: "Redo", accelerator: "Shift+CmdOrCtrl+Z", selector: "redo:" },
            { type: "separator" },
            { label: "Cut", accelerator: "CmdOrCtrl+X", selector: "cut:" },
            { label: "Copy", accelerator: "CmdOrCtrl+C", selector: "copy:" },
            { label: "Paste", accelerator: "CmdOrCtrl+V", selector: "paste:" },
            { label: "Select All", accelerator: "CmdOrCtrl+A", selector: "selectAll:" }
        ]
    }
    ])
}

Menu.setApplicationMenu(Menu.buildFromTemplate(menu_iems));

const send = (k, v, view) => {
    view ??= win.getCurrentView()
    if (!view) return
    let webContents = view.webContents
    try {
        if (webContents.isDestroyed && webContents.isDestroyed()) return
        webContents.send(k, v)
    } catch (err) { }
}

const sendEvent = (name, data) => send('event', { name, data })
const broadcast = (k, v, filter) => win.getBrowserViews().filter(view => !filter || filter(view)).forEach(view => view.webContents.send(k, v))

var methods = {}
const registerMethod = (type, cb) => {
    if (typeof (type) == 'object') {
        Object.assign(methods, type)
    } else {
        methods[type] = cb
    }
}

const exitAPP = (opts, webContents) => {
    webContents ??= app.webContents
    let view = win.findViewByWebContents(webContents)
    if (view) win.removeBrowserView(view, true)
    if (opts?.force || win.getBrowserViews().length == 0) {
        win.destroy()
        app.exit()
    }
}

const runMethod = async ({ event, data }) => {
    let { type, msg } = data
    if (methods[type]) return methods[type](msg)
    let webContents = event.sender
    switch (type) {
        case 'toggleShow':
            return toggleShow()
        case 'show':
            return toggleShow(true)
        case 'hide':
            return toggleShow(false)
        case 'exit':
            return exitAPP(msg, webContents)
        case 'pin':
            return win.setAlwaysOnTop(msg ?? !win.isAlwaysOnTop(), 'screen');
        case 'min':
            return win.minimize()
        case 'max':
            return win.isMaximized() ? win.unmaximize() : win.maximize()
        case 'close':
            return win.close()
        case 'progress':
            return win.setProgressBar(msg.val, { mode: msg.type || 'normal' })
        case 'fileDialog':
            return openFileDialog(msg).then(res => {
                webContents.send('fileDialog_revice', {
                    id: msg.id,
                    paths: res
                })
            });
    }
}
ipcMain.on("method", (event, data) => runMethod({ event, data }));

// 文件对话框
function openFileDialog(opts) {
    return new Promise(reslove => {
        if (opts.defaultPath) {
            opts.defaultPath = platform == 'win32' ? opts.defaultPath.replaceAll('/', '\\') : opts.defaultPath.replaceAll('\\', '/')
        }
        opts = Object.assign({
            title: '选中文件',
            properties: ['openFile'],
        }, opts);
        dialog.showOpenDialog(win, Object.assign({}, opts)).then(res => reslove(res.filePaths || res.filePath));
    })
}

var showing
var lastBounds // win如何获取隐藏状态??
function toggleShow(show) {
    showing = true
    const { width, height } = screen.getPrimaryDisplay().workAreaSize;
    if (show == undefined) show = lastBounds != undefined
    if (show || win.isMinimized() || !win.isFocused()) {
        // win.show();
        win.restore();
        let isTop = win.isAlwaysOnTop()
        win.setAlwaysOnTop(true)
        // win.setSkipTaskbar(false);
        lastBounds && win.setBounds(lastBounds)
        win.focus();
        lastBounds = undefined
        if(!isTop) win.setAlwaysOnTop(false)
    } else
        if (!win.isAlwaysOnTop()) {
            lastBounds = win.getBounds()
            // win.hide()
            win.setPosition(width + 9999, height + 9999);
            // win.setSkipTaskbar(true);
            win.minimize();
        }
    showing = false
}

var loadingScree, currentOpts, view_helper, currentAPP
function createWindow(opts) {
    currentOpts = opts
    let { name, icon, url, title, args = [] } = opts
    win = new BrowserWindow({
        icon,
        title,
        minHeight: 400,
        minWidth: 200,
        frame: false,
        show: false,
        alwaysOnTop: true,
        skipTaskbar: true,
        webPreferences: {
            spellcheck: false,
            webviewTag: true,
            webSecurity: false,
            enableRemoteModule: true,
            nodeIntegrationInWorker: true,
            // experimentalFeatures: true,
            nodeIntegration: true,
            contextIsolation: false,
        }
    })
    const { addView, nextView } = view_helper = require('./browserView_helper.js')({ dialog, win, currentOpts, session, remote, BrowserView, sendEvent, registerMethod, isEmpty })
    win.on('always-on-top-changed', (ev, isTop) => send('togglePin', isTop))
    win.on('close', e => {
        e.preventDefault(true)
        dialog.showMessageBoxSync(win, {
            message: ' 确定退出吗?',
            type: 'info',
            title: '提示',
            buttons: ['确定', '取消'],
            defaultId: 0,
            cancelId: 1,
        }) == 0 && send('exit') & setTimeout(() => exitAPP({ force: true }), 1000)
    })

    win.on('moved', () => send('move', win.getBounds()))
    win.on('resized', () => send('resize', win.getBounds()))
    win.on('maximize', () => send('maximize'))
    win.on('unmaximize', () => send('unmaximize'))

    let loading = addView({
        id: 'loading',
        url: opts.loading || `file://${_appPath}/public/loading.html?app=${name}`,
        webPreferences: {
            preload: path.join(_appPath, '/public/loading_preload.js'),
            contextIsolation: true,
        }
    })

    let view = addView({
        id: 'main', url: url ?? 'file://' + opts.path + '/index.html', active: false, webPreferences: {
            spellcheck: false, webviewTag: true, webSecurity: false, additionalArguments: args
        }
    })

    // view.webContents.once('dom-ready', () => win.show())
    // view.webContents.openDevTools()
    view.webContents.once('did-finish-load', () => {
        win.setAlwaysOnTop(false)
        win.setSkipTaskbar(false)
        win.removeView('loading')
        win.setTopBrowserView(view)
    })

    win.setAppDetails && win.setAppDetails({
        appId: 'com.hunmer.' + title,
        appIconPath: icon,
    });

    // app.on('web-contents-created', function(ev, webContents){
    //     console.log(Object.keys(webContents))
    //     let pipWindow = BrowserWindow.fromWebContents(webContents)
    //     // let pipWindow = webContents.getOwnerBrowserWindow()
    //     console.log(webContents.id, pipWindow)
    //     if(pipWindow){
    //         pipWindow.setAspectRatio(16 / 9);
    //         pipWindow.setPosition(0, 0);
    //         pipWindow.setSize(640, 360);
    //     }
    // })
    app.setAppUserModelId(opts.title);
}

function parseURLParams(url, ret = {}) {
    new URLSearchParams(url).forEach((k, v) => ret[v] = k)
    return ret
}

const http = require('http');
async function http_request(opts, success, error) {
    let { pathname, port, hostname, search } = new URL(opts.url)
    let proxy_ip = await files.getProxy()
    opts = Object.assign({ method: 'GET' }, opts, { path: pathname + search, port, hostname, url: undefined, agent: proxy_ip ? new http.Agent({ proxy: proxy_ip }) : undefined })
    const req = http.request(opts, (res) => {
        res.on('data', data => success(data.toString()));
        // res.on('end', () => {});
    });
    req.on('error', error);
    req.end();
}

let inited 
let program = platform == 'darwin' ? `${path.resolve(_appPath, '../../..')}/` : path.resolve(_appPath, '../../mLauncher.exe')
app.setAsDefaultProtocolClient('mlauncher', program, [])

function checkLaunchArgs(args){
    let protocol_str = 'mlauncher:\\\\'
    if (args.length == 2 && args[1].startsWith(protocol_str)) {
        return parseURLParams(args[1].substring(protocol_str.length))
    }
    return {}
}

app.whenReady().then(() => {
    inited = true
    let params = []
    let list = Object.assign({
        main: {
            title: '应用启动器',
            description: '',
            path: './main/',
        }
    }, fs.readJsonSync(_appPath + '/apps.json'))
    
    let args = process.argv.map(arg => decodeURI(arg))
    const next = () => {
        for (let k in list) {
            let v = list[k]
            if (isEmpty(v.path)) v.path = _appPath + '/' + k + '/'
            if (isEmpty(v.icon) || !fs.existsSync(v.icon)) v.icon = v.path + 'favicon.ico';
            if (isEmpty(v.dataPath) || !fs.existsSync(v.dataPath)) v.dataPath = _appPath + '/cache/' + k;
            ['icon', 'path', 'dataPath'].forEach(n => v[n] = path.resolve(_appPath, v[n]))
            if (!fs.existsSync(v.path)) delete list[k]
        }

        app.setUserTasks && app.setUserTasks(Object.entries(list).map(([k, v]) => {
            if (isEmpty(v.url)) list[k].url = v.url = path.resolve(__dirname, v.path + '/index.html')
            if (v.pin) {
                return {
                    program: process.execPath,
                    arguments: '. ' + k,
                    iconPath: v.icon,
                    iconIndex: 0,
                    title: v.title,
                    description: v.description,
                    workingDirectory: __dirname,
                }
            }
        }).filter(v => v != undefined))


        let name = args.length > 2 ? args[2] : 'main'
        if (!list[name]) return app.exit()
        currentAPP = name
        setHomepage(Object.assign(list[name], { name, args: params }))
    }

    let { appId, method, data } = checkLaunchArgs(args)
    if (!isEmpty(method)) {
        // APP 是否在后台打开
        const launch = () => {
            // 传入启动参数
            args = [args[0], '.', appId]
            params = ['method', method, 'data', data]
            next()
        }
        http_request({
            url: `http://127.0.0.1:40001/api/send?app=${appId}&method=${method}&data=${data}`
        }, data => {
            let {code} = JSON.parse(data)
            if(code == -1){
                launch()
            }else
            if(code == 2){ // 多开，指定选择一个
                
            }else
            if(code == 1 || code == -2) return app.exit()
            
            // next()
        }, launch)
    }else{
        next()
    }
})

// MACOS
app.on('open-url', (event, url) => {
    event.preventDefault()
    let args = [process.argv[0], url]
    if(!inited){
        process.argv = args // 会比ready先触发
    }else{
        let { appId, method, data } = checkLaunchArgs(args.map(arg => decodeURI(arg)))
        http_request({
            url: `http://127.0.0.1:40001/api/send?app=${appId}&method=${method}&data=${data}`
        }, () => {}, () => {})
    }
})

function setHomepage(opts) {
    if (opts.icon) {
        if (platform == 'darwin') opts.icon = opts.icon.replace('.ico', '@2x.png') // macos图标
        let file = path.resolve(opts.icon)
        if (fs.existsSync(file)) {
            let tray = new Tray(file);
            tray.setToolTip(opts.title);
            tray.setContextMenu(Menu.buildFromTemplate([{
                label: "刷新页面",
                click: () => win.getCurrentWebcontents().reload()
            }, {
                label: "强制退出",
                click: () => app.exit()
            }, {
                label: "退出",
                click: () => app.quit()
            }]));
            tray.on("double-click", () => {
                win.restore()
                win.maximize()
            })
        }
    }
    app.setPath('userData', opts.dataPath);
    app.on('activate', () => BrowserWindow.getAllWindows().length === 0 && createWindow(opts))
    remote.initialize()
    createWindow(opts)
}

app.on('browser-window-created', (_, window) => {
    require("@electron/remote/main").enable(window.webContents) // 自动开启新窗口的remote模块
})
app.on('window-all-closed', () => process.platform !== 'darwin' && app.quit())

function isEmpty(s, trim = false) {
    if (s === null || typeof s === 'undefined') return true;
    if (typeof s === 'string') return (trim ? s.trim() : s).length === 0;
    return false;
}