const fs = require('fs-extra')
const path = require('path')
const { app } = getGETArray()
const { getCurrentWindow } = require('@electron/remote');
const { contextBridge, ipcRenderer } = require('electron')

const send = (data, method = 'method') => {
    if (typeof(data) != 'object') data = { type: data }
    ipcRenderer.send(method, data);
}
contextBridge.exposeInMainWorld('_electron', {send})

const win = getCurrentWindow()
const list = {...{
    main: { title: '应用启动器', description: '启动中心', path: './main/', updateURL: 'https://neysummer2000.fun/mLauncher/', icon: 'favicon.ico' }
}, ...fs.readJsonSync(path.resolve(__dirname, '../apps.json'))}
const item = list[app]

window.addEventListener('DOMContentLoaded', () => {
    if(item.bg) document.body.style.backgroundImage = `url(${formatBackgroundURL(item.bg)})`;
    document.body.innerHTML = `
    <div class="page page-center">
        <div class="container container-slim py-4">
            <div class="text-center">
                ${item ? `
                <div class="mb-3">
                    <a class="navbar-brand navbar-brand-autodark" style="-webkit-app-region: drag">
                        <img src="${item.icon || '../'+item.path+'favicon.ico'}" height="36" >
                    </a>
                </div>
                <div class="mb-3">正在加载 ${item.title}  中...</div>
                <div class="progress progress-sm">
                    <div class="progress-bar progress-bar-indeterminate"></div>
                </div>
                <button class="btn btn-secondary mt-3" onclick="_electron.send('exit')">关闭</button>
                ` : `
                <h2 class="mb-3 text-danger">没有找到应用: ${app}</h2>
                <button class="btn btn-danger mt-3" onclick="_electron.send('exit')">关闭</button>
                `}
            </div>
        </div>
    </div>
    `
})


function formatBackgroundURL(img) {
    if (!img.startsWith('.')) img = 'file:\\' + img
    return img.replaceAll('\\', '\\\\').replaceAll('#', '%23').replaceAll(' ', '%20')
}

function getGETArray() {
    let ret = [],
        a_exp;
    let a_params = window.location.search.slice(1).split('&');
    for (const k in a_params) {
        a_exp = a_params[k].split('=');
        if (a_exp.length > 1) {
            ret[a_exp[0]] = decodeURIComponent(a_exp[1]);
        }
    }
    return ret;
}