var APP_VERSION = 'v0.0.1';
var g_localKey = 'ms_';
var g_localKey_default = 'ms_'
var _GET = getGETArray()
var g_cache = {
    zIndex: 4000,
    debug: false,
}

// plugin触发事件
function _callEvent(){

}

function isObject(obj) {
  return Object.prototype.toString.call(obj) === '[object Object]';
}

function obj_From_key(obj, k){
    let type = typeof(obj)
    if(type == 'undefined') return {}
    return isObject(obj) ? obj : {[k]: obj}
}

function arr_forEach(arr, cb, ret = {}){
    arr.forEach((item, i) => {
        let [k, v] = cb(item, i)
        ret[k] = v
    })
    return ret
}

function getAvailbleRect(rect1, rect2) {
    let { width, height, left, top } = rect1
    if (left + width > rect2.width) {
        left = rect2.width - width
    } else
    if (left < rect2.left) {
        left = rect2.left
    }
    if (top + height > rect2.height) {
        top = rect2.height - height
    } else
    if (top < rect2.top) {
        top = rect2.top
    }
    return { width, height, left, top }
}

function assignInstance(inst, obj) {
    let init = obj.init
    delete obj.init

    Object.assign(inst, obj)
    init && init.apply(inst)
}

function flattenArray(arr) {
    var result = [];
    for (var i = 0; i < arr.length; i++) {
        if (Array.isArray(arr[i])) {
            result = result.concat(flattenArray(arr[i]));
        } else {
            result.push(arr[i]);
        }
    }
    return result;
}

function getDateRange(type = 'today', rTime = false) {
    var start, end
    let date = new Date()
    let setTime = t => start = new Date(date.getTime() + t)
    switch (type) {
        case 'today':
            setTime(0)
            break
        case 'yestaday':
            setTime(0 - 86400000)
            end = new Date(new Date(start).setHours(0, 0, 0, 0))
            break
        case 'last7day':
            setTime(0 - 86400000 * 6)
            break
        case 'last30day':
            setTime(0 - 86400000 * 29)
            break
        case 'thismonth':
            setTime(0 - (date.getDate() - 1) * 86400000)
            break
        case 'lastmonth':
            let year = date.getFullYear()
            let mon = date.getMonth() - 1
            start = new Date(year, mon, 1);
            end = new Date(new Date(start).setDate(new Date(year, mon, 0).getDate() + 1));
            break
    }
    if (!end) end = date
    if (rTime) {
        start = start.getTime()
        end = end.getTime()
    }
    return { start, end }
}

function urlMatchs(str, format) {
    let arr1 = str.split('/')
    let arr2 = format.split('/')
    let ret = {}
    let match
    if (arr1.length == arr2.length) {
        arr1.forEach((k1, i1) => {
            let k2 = arr2[i1]
            if (k2.startsWith('{') && k2.endsWith('}')) {
                return ret[k2.substr(1, k2.length - 2)] = arr1[i1]
            }
            match = k1 == k2
            if (!match) return false
        })
    }
    if (match) return ret
}

function toURL(url) {
    if (url.startsWith('//')) url = 'https:' + url
    return url
}

function debug(...args) {
    if (g_cache.debug) console.log(...args)
}

function toVal(v, ...args) {
    return typeof(v) == 'function' ? v.apply(v, args) : v
}
var call = (self, v, ...args) => typeof(v) == 'function' ? v.apply(self, args) : v

var applyFun = (obj, key, ...args) => {
    let val = getObjVal(obj, key)
    if(typeof(val) == 'function'){
        return val.apply(obj, args)
    }
    return val
}

// 任意一个符合条件
var applyFunArray = (array, ...args) => {
    let ret
    array.some(([obj, key]) => {
        let val = getObjVal(obj, key)
        if(val != undefined){
            ret = typeof(val) == 'function' ? val.apply(obj, args) : val
            return true
        }
    })
    return ret
}

function isObjEqual(a, b) {
    var aProps = Object.getOwnPropertyNames(a);
    var bProps = Object.getOwnPropertyNames(b);
    if (aProps.length != bProps.length) {
        return false;
    }
    for (var i = 0; i < aProps.length; i++) {
        var propName = aProps[i];
        if (a[propName] !== b[propName]) {
            return false;
        }
    }
    return true;
}

function getObjVals(obj, keys) {
    let r = {}
    keys.forEach(key => r[key] = obj[key])
    return r
}

function getParamsArray(arr, def) {
    if (arr == undefined) {
        return def;
    } else
    if (!Array.isArray(arr)) {
        return [arr];
    }
    return arr;
}

function setCssVar(k, v, target) {
    (target ?? document.documentElement).style
        .setProperty(k, v);
}


function getCssVar(k, target) {
    return getComputedStyle(target ?? document.documentElement)
        .getPropertyValue(k);
}

function trimEnd(s, search = ';') {
    if (s.substr(0 - search.length) == search) {
        return s.substr(0, s.length - 1)
    }
    return s
}

function openFileDiaglog(opts, callback) {
    if (typeof(opts) != 'object') opts = { id: opts }
    opts = Object.assign({
        title: '选择文件',
        properties: ['openFile'],
    }, opts)
    g_pp.set(opts.id, paths => callback(paths.map(path => path.replaceAll('\\', '/'))));
    ipc_send('fileDialog', opts)
}


// function getGETArray() {
//     let ret = {}
//     new URLSearchParams(window.location.search).forEach((k, v) => ret[k] = v)
//     return ret
// }

function getGETArray() {
    let ret = [],
        a_exp;
    let a_params = window.location.search.slice(1).split('&');
    for (var k in a_params) {
        a_exp = a_params[k].split('=');
        if (a_exp.length > 1) {
            ret[a_exp[0]] = decodeURIComponent(a_exp[1]);
        }
    }
    return ret;
}

function checkEmpty(...args){
    let defV = args.pop()
    return args.find(s => !isEmpty(s)) ?? defV
}


function adjustSize(width, height, { newWidth, newHeight }) {
    if (!isNaN(newWidth)) {
      var ratio = newWidth / width;
      return { newWidth, newHeight: height * ratio };
    } else if (!isNaN(newHeight)) {
      var ratio = newHeight / height;
      return { newWidth: width * ratio, newHeight };
    } else {
      return { newWidth: width, newHeight: height };
    }
}

// 取jquery对象集的值
function getElementsValues(els, cb){
    cb ??= el => el.value
    let ret = []
    els.each((i, el) => {
        let val = cb(el, i)
        if(val !== undefined) ret.push(val)
    })
    return ret
}

function insertEl(obj, opts = {}){
    let {target, method, remove} = opts

    method ??= 'appendTo'
    target =  target == undefined ? $(document.body) : $(target)
    
    let div = target.find('#'+obj.props.id)
    if(!div.length){
        if(opts.insert === false || remove) return
        div = $(objToHtml(obj))[method](target)
        opts.onInit && opts.onInit(div)
    }else
    if(remove){
        div.remove()
        return
    }
    return div
}

function assignActions(inst, name, callback) {
    if(typeof(name) != 'object') name = {[name]: callback}
    Object.values(name).forEach(value => value.constructor && value.constructor())
    Object.assign(inst, name)
    return this
}

function objToHtml(obj){
    let {tag, props, text} = obj
    let str = ''
    Object.entries(props).forEach(([k, v]) => {
        if(v != undefined) str += ` ${k}="${v}"`
    })
    return `<${tag} ${str}>${toVal(text) || ''}</${tag}>`
}

function colorToHex(colorArr) {
    let strHex = '#'
    for (var i = 0; i < colorArr.length; i++) {
        var hex = Number(colorArr[i]).toString(16);
        if (hex === "0") {
            hex += hex;
        }
        strHex += hex;
    }
    return strHex
}

function arr_join_range(args, join, start, end) {
    let max = args.length - 1
    if (end == undefined) end = max
    if (end > max) end = max
    if (start < 0) start = 0

    let ret = []
    for (let i = start; i <= max; i++) {
        ret.push(args[i])
    }
    return ret.join(join)
}


function replaceAll_once(str, search, replace, start = 0) {
    if (typeof(str) != 'string') return ''
    let cnt = 0
    while (true) {
        var i = str.indexOf(search, start);
        if (i == -1) break;
        start = i + search.length;

        let rep = typeof(replace) == 'function' ? replace(cnt++) : replace
        str = str.substr(0, i) + rep + str.substr(start, str.length - start);
        start += rep.length - search.length;
    }
    return str;
}



function guid() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
        var r = Math.random() * 16 | 0,
            v = c == 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}

function getVal(v, def) {
    return !isEmpty(v) ? v : def
}

function get(...args) {
    return args.find(arg => {
        return arg !== false && arg !== undefined && arg != ''
    })
}

// k => [[k, undefined]]
// {k: v} => [[k, v]]
function entriesObject(obj){
    let isArr = Array.isArray(obj)
    let isObj = typeof(obj) == 'object'
    if(!isObj && !isArr) obj = [obj]

    let vals = Object.values(obj)
    let keys = Object[isArr ? 'values' : 'keys'](obj)
    return keys.map((key, index) => !isArr && isObj ? [key, vals[index]] : [vals[index], undefined]);
}


// joinClass('d-flex', 'w-full', 'd-block') -> w-full d-block
var joinClass = (...args) => {
    args = flattenArray(args.filter(arg => typeof(arg) == 'string').map(arg => arg.split(' ')))
    return args.filter((arg, i) => {
       let arr = arg.split('-')
       return args.find((arg1, i1) => i1 > i && arg1.startsWith(arr[0]+'-')) === undefined
    }).join(' ')
}

function stringifyFunctions(obj) {
    if (typeof obj === 'function') {
      return obj.toString();
    }
    if (Array.isArray(obj)) {
      return obj.map(item => stringifyFunctions(item));
    }
    if (typeof obj === 'object' && obj !== null) {
      var newObj = {};
      Object.keys(obj).forEach(key => {
        newObj[key] = stringifyFunctions(obj[key]);
      });
      return newObj;
    }
    return obj;
}


function stringIncludes(str, search){
    return toArr(search).some(s => !str.includes(s)) === false
}

var isInputFocus = () =>  $('input:focus,textarea:focus').length

function getDefVal(a, b, c) {
    return a == c ? b : a
}

function OR(k, v, defV = '') {
    return k === true ? v : defV
}

function getObjVal(obj, k, def) {
    if (!isEmpty(k)) k = '.' + k
    try {
        let v = eval("obj" + k)
        return isEmpty(v) ? def : v
    } catch (e) {
        return def
    }
}

function spliceObjectKey(obj, k){
    let r = {}
    toArr(k).forEach(_k => {
        r[_k] = obj[_k]
        delete obj[_k]
    })
    return r
}

function mergeArrayJoin(arr1, arr2, join_str = '') {
    if(arr1.length <= 1) return arr1.join(join_str)
    arr2 = arr2.slice(0, arr1.length - 1)
    return arr1.map((k, i) => {
        if(arr2[i] != undefined) k += ' ' + arr2[i]
        return k
    }).filter(k => k != '').join(join_str)
}

function stringSplit(str, search) {
    let replaced = [];
    let ret = str.replace(new RegExp(search.join('|'), 'g'), match => {
      replaced.push(match);
      return '\n';
    }).split('\n');
    return [ret, replaced];
}
// stringSplit('a AND b OR c', ['AND', 'OR']) -> [['a ', ' b ', ' c'], ['AND', 'OR']]

function setObjVal(obj, k, v) {
    if (typeof(v) == 'object') {
        v = JSON.stringify(v)
    } else
    if (typeof(v) == 'string') {
        v = '"' + v + '"'
    }
    eval(`obj.${k} = ${v};`)
    return obj
}

function toggleVideoPlay(video) {
    if (video.paused) {
        video.play()
    } else {
        video.pause()
    }
}

function replaceArr(arr, replace, search = '%') {
    let r = []
    arr.forEach(k => r.push(k.replace(search, replace)))
    return r
}

function parseHtml(html){
   return $((new window.DOMParser()).parseFromString(html, "text/html"));
}

function toggleFullScreen() {
    if (!document.fullscreenElement && // alternative standard method
        !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement) { // current working methods
        if (document.documentElement.requestFullscreen) {
            document.documentElement.requestFullscreen();
        } else if (document.documentElement.msRequestFullscreen) {
            document.documentElement.msRequestFullscreen();
        } else if (document.documentElement.mozRequestFullScreen) {
            document.documentElement.mozRequestFullScreen();
        } else if (document.documentElement.webkitRequestFullscreen) {
            document.documentElement.webkitRequestFullscreen(Element.ALLOW_KEYBOARD_INPUT);
        }
        $(window).resize();
        return true;
    }
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.msExitFullscreen) {
        document.msExitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    }
    $(window).resize();
    return false;
}

function inputFocus(ele) {
    ele.blur();
    ele.focus();
    var len = ele.value.length;
    if (document.selection) {
        var sel = ele.createTextRange();
        sel.moveStart('character', len);
        sel.collapse();
        sel.select();
    } else {
        ele.selectionStart = ele.selectionEnd = len;
    }
}

function parseFile(input) {
    var reader = new FileReader();
    reader.readAsText(input.files[0]);
    reader.onload = function(e) {
        try {
            json = JSON.parse(this.result);
            importData(json);
        } catch (err) {
            alert('错误的json数据!');
        }
    }
}

function getImageSize(url){
    return new Promise(reslove => {
        let img = new Image()
        img.onload = () => reslove([img.naturalWidth, img.naturalHeight])
        img.src = url
    })
}

// 只对特殊的字符进行url解码，避免报错
function customDecodeURI(uri) {
    [['%20', ' '], ['%21', '!'], ['%22', '"'],['%23', '#'],['%24', '$'],['%25', '%'],['%26', '&'],['%27', "'"],['%28', '('],['%29', ')'],['%2A', '*'],['%2B', '+'],['%2C', ','],['%2D', '-'],['%2E', '.'],['%2F', '/'],['%3A', ':'],['%3B', ';'],['%3C', '<'],['%3D', '='],['%3E', '>'],['%3F', '?'],['%40', '@'],['%5B', '['],['%5C', '\\'],['%5D', ']'],['%5E', '^'],['%5F', '_'],['%60', '`'], ['%7B', '{'],  ['%7C', '|'], ['%7D', '}'], ['%7E', '~'],['%7B', '{']].forEach(([k, v]) => uri = uri.replaceAll(k, v))
    return uri
}

function hasSpecialChar(str) {
    var pattern = /[ `!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?~]/;
    return pattern.test(str);
}


const _encodeURIComponent = (x, encodeing = 'gbk') => x.split('').map((y) => {
    if (!RegExp(/^[\x00-\x7F]*$/).test(y)) {
        return nodejs.iconv
            .encode(y, encodeing)
            .reduce((a, b) => a + '%' + b.toString(16), '') 
            .toUpperCase();
    } else {
        return y;
    }   
}).join('');


function nguid() {
    var timestamp = Date.now().toString();
    var random = Math.floor(Math.random() * 1000000).toString().padStart(6, '0');
    return timestamp + random;
}

function arrayShuffle(arr){
   return arr.sort(() => Math.random() - 0.5);
}

function blobToBase64(blob) {
    return new Promise(reslove => {
        let reader = new window.FileReader();
        reader.readAsDataURL(blob);
        reader.onloadend = function() {
            reslove(reader.result)
        }
    })
}

function getMinMax(...args){
    return {start: Math.min.apply(undefined, args), end: Math.max.apply(undefined, args)}
}

function keysData({data, keys, isArr}){
    let ret = isArr ? [] : {}
    data.forEach(item => {
        let key = isArr ? ret.length : item.shift()
        ret[key] = {}
        keys.forEach((k, i) => ret[key][k] = item[i])
    })
    return ret
}

function fileReader(opts){
    return new Promise(reslove => {
        let {type, input} = opts
        let reader = new FileReader();
        reader['readAs'+type](input);
        reader.onloadend = () => {
            reslove(reader.result)
        }
    })
}

function renderSize(value) {
    if (null == value || value == '') {
        return "0B";
    }
    var unitArr = new Array("B", "KB", "MB", "GB", "TB", "PB", "EB", "ZB", "YB");
    var index = 0;
    var srcsize = parseFloat(value);
    index = Math.floor(Math.log(srcsize) / Math.log(1024));
    var size = srcsize / Math.pow(1024, index);
    size = size.toFixed(2); //保留的小数位数
    return size + unitArr[index];
}

function importData(data, b_confirm = true) {
    var fun = (b = true) => {
        for (var key in data) {
            if (b) {
                s = data[key];
            } else {
                var old = JSON.parse(localStorage.getItem(key)) || {};
                s = JSON.stringify(Object.assign(old, JSON.parse(data[key])));
            }
            localStorage.setItem(key, s);
        }
        location.reload();
    }
    if (b_confirm) {
        confirm('<b>是否完全覆盖数据?</b>', {
            title: '导入数据',
            callback: (id) => {
                var b = id == 'ok';
                if (b) {
                    local_clearAll();
                }
                fun(b);
                return true;
            }
        });
    } else {
        fun();
    }
}

function copyObj(obj) {
    return JSON.parse(JSON.stringify(obj));
}

function copyFn(obj) {
   if (obj == null) {
        return null
    }
    var result = Array.isArray(obj) ? [] : {};
    for (let key in obj) {
        if (obj.hasOwnProperty(key)) {
            if (typeof obj[key] === 'object') {
                result[key] = copyFn(obj[key]);  // 如果是对象，再次调用该方法自身
            } else {
                result[key] = obj[key];
            }
        }
    }
    return result;
}

// 数组队列处理
function arrayQueue(arr, cb, done, check, multi = 1) {
    let i = 0
    let rets = []
    let max = arr.length
    if(check == undefined) check = ret => ret !== false
    var next = ()=>{
        let item = arr.shift()
        if (item === undefined) return done(rets)
        cb(item, i++, max).then(ret=>{
            if (check && !check(ret)) return done(false)
            ret && rets.push(ret)
            next()
        })
    }
    for(let i=0;i<multi;i++) next()
}

function test(steps, done, error){
    var $s
    arrayQueue(steps, async (step, i) => {
        if(i == 0){
            $s = await step
            return true
        }
        return (await eval(step)) === true
    }, ok => ok ? done($s) : error())
}

function setHeight(selector, pb = '200px') {
    if (typeof(selector) == 'string') selector = $(selector);
    selector.css({
        'height': 'calc(100vh - ' + selector.offset().top + 'px)',
        paddingBottom: pb,
    });
}

function downloadData(blob, fileName) {
    if (typeof(blob) != 'blob') {
        blob = new Blob([blob]);
    }
    var eleLink = document.createElement('a');
    eleLink.download = fileName;
    eleLink.style.display = 'none';
    eleLink.href = URL.createObjectURL(blob);
    document.body.appendChild(eleLink);
    eleLink.click();
    document.body.removeChild(eleLink);
}

Object.defineProperty(Array.prototype, 'map1', {
    value: function(cb) {
        let ret = [], val
        this.forEach(item => {
            if((val = cb(item)) !== undefined) ret.push(val)
        })
        return ret
    },
    enumerable: false
  });

Date.prototype.format = function(fmt) {
    var o = {
        "M+": this.getMonth() + 1, //月份 
        "d+": this.getDate(), //日 
        "h+": this.getHours(), //小时 
        "m+": this.getMinutes(), //分 
        "s+": this.getSeconds(), //秒 
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
        "S": this.getMilliseconds() //毫秒 
    };
    if (/(y+)/.test(fmt)) {
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    }
    for (var k in o) {
        if (new RegExp("(" + k + ")").test(fmt)) {
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
        }
    }
    return fmt;
}

function popString(s, split) {
    return typeof(s) == 'string' && s.indexOf(split) != -1 ? s.split(split).pop() : '';
}

function getExtName(s) {
    return popString(s, '.').toLowerCase().split('?')[0]
}

function getNumber(s) {
    return s.replace(/[^0-9]/ig, '')
}

function getFilePath(s) {
    return s.replace(this.getFileName(s), '')
}

function getFileName(s, ext) {
    s = s.replaceAll('\\', '/')
    s = popString(s, '/') || s
    if (ext === false && s.indexOf('.') != -1) {
        let ext = this.getExtName(s)
        s = s.substr(0, s.length - ext.length - 1)
    }
    return s
}

function getPathName(s){
    return popString(replaceEndsWith(s.replaceAll('\\', '/'), '/'), '/')
}
  
function createCanvasFromElement(video, width, height) {
    let canvas = document.createElement("canvas");
    let fullWidth =  video.naturalWidth || video.videoWidth
    let fullHeight =  video.naturalHeight || video.videoHeight
    height ??= fullHeight * width / fullWidth
    canvas.width = width;
    canvas.height = height;
     canvas.getContext("2d").drawImage(video, 0, 0, fullWidth, fullHeight, 0, 0, canvas.width, canvas.height);
     return canvas
}

function getImgBase64(...args) {
    return new Promise(function(resolve) {
        let canvas = createCanvasFromElement.apply(this, args)
        canvas.toBlob(e => resolve(URL.createObjectURL(e)))
    });
}

function toDataURL(dataType, ...args) {
    let canvas = createCanvasFromElement.apply(this, args)
    return canvas.toDataURL(dataType);
}

function loadRes(files, callback, cache = true) {
    files = [...files]
    var next = () => {
        let url = files.shift()
        if(url == undefined) return callback && callback()
        let fileref
        let ext = popString(url, '.').toLowerCase()
        if (ext == "js") {
            if (!cache || !$('script[src="' + url + '"]').length) { // js已加载
                fileref = document.createElement('script');
                fileref.setAttribute("type", "text/javascript");
                fileref.setAttribute("src", url)
            }
        } else if (ext == "css") {
            if (!cache || !$('link[href="' + url + '"]').length) { // css已加载
                fileref = document.createElement("link");
                fileref.setAttribute("rel", "stylesheet");
                fileref.setAttribute("type", "text/css");
                fileref.setAttribute("href", url)
            }
        }
        if(fileref != undefined){
            document.getElementsByTagName("head")[0].appendChild(fileref).onload = next
        }else{
            next()
        }
    }
    next()
}


var ajax_request = opts => {
    return new Promise((reslove) => {
        if(typeof(opts) != 'object') opts = {url: opts}
        opts.headers ??= {}
        opts.headers["accept"] = "application/json"

        let data = opts.data 
        if (data) {
            opts.data = JSON.stringify(data)
            opts.headers["Content-Type"] = "application/json"
        }
        let ajax =  $.ajax(Object.assign({
            method: data ? 'POST' : 'GET',
            timeout: -1,
            success: reslove,
            // error: (xhr, status, error) => console.error(error),
        }, opts));
        opts.onInited && opts.onInited(ajax)
    })
}

function unescapeHTML(a) {
    a = "" + a;
    return a.replace(/&lt;/g, "<").replace(/&gt;/g, ">").replace(/&amp;/g, "&").replace(/&quot;/g, '"').replace(/&apos;/g, "'");
}

function clearEventBubble(evt) {
    if (evt.stopPropagation) evt.stopPropagation();
    else evt.cancelBubble = true;
    if (evt.preventDefault) evt.preventDefault();
    else evt.returnValue = false
}


function isEmpty(s, trim = false) {
    if (s === null || typeof s === 'undefined') {
        return true;
    }
    if (typeof s === 'string') {
        return (trim ? s.trim() : s).length === 0;
    }
    return false;
}

function local_saveJson(key, data) {
    return local_set(key, data);
}

function local_readJson(key, defaul, db) {
    var r = local_get(key);
    return r === null ? defaul : JSON.parse(r);
}

function local_set(key, data, prefix = g_localKey) {
    if (window.localStorage) {
        if (typeof(data) == 'object') data = JSON.stringify(data)
        localStorage.setItem(prefix + key, data);
    }
}

function local_get(key, prefix = g_localKey) {
    if (window.localStorage) {
        return localStorage.getItem(prefix + key);
    }
}

function local_getList(prefix = g_localKey) {
    var res = [];
    for (k of Object.keys(localStorage)) {
        if (k.indexOf(prefix) == 0) {
            res.push(k);
        }
    }
    return res;
}

function replaceText(text, vars = []) {
    vars = toArr(vars)
    for (let [k, v] of Object.entries(vars)) {
        text = text.replace('%' + k, toVal(v));
    }
    return text
}

function formatBackgroundURL(img) {
    if (!img.startsWith('.')) {
        img = 'file:\\' + img
    }
    return replaceAll_once(img, '\\', '\\\\')
}


function local_getAll(prefix) {
    var d = {};
    for (var key of local_getList(prefix)) {
        d[key] = localStorage.getItem(key);
    }
    return d;
}

function local_clearAll(prefix) {
    for (var key of local_getList(prefix)) {
        localStorage.removeItem(key);
    }
}

function toArr(arr) {
    return Array.isArray(arr) ? arr : [arr]
}

function getTime(s, sh = _l(':'), sm = _l(':'), ss = _l(''), hour = false, msFixed = 2) {
    if (s == undefined) return ''

    s = Number(s);
    if (s < 0) return '';
    var h = 0,
        m = 0;
    if (s >= 3600) {
        h = parseInt(s / 3600);
        s %= 3600;
    }
    if (s >= 60) {
        m = parseInt(s / 60);
        s %= 60;
    }
    s = s.toFixed(msFixed)
    return (hour ? _s(h, sh) : _s2(h, sh)) + _s(m, sm) + (ss !== false ? _s(s, ss) : '');
}

function time_getRent(time) {
    if (!time) return '';
    var today = new Date();
    var s = (parseInt(today.getTime()) - time) / 1000;
    if (s >= 84000) {
        if (s >= 84000 * 30) {
            if (s >= 84000 * 365) {
                return getFormatedTime(4, time);
            }
            return getFormatedTime(2, time);
        }
        return parseInt(s / 86400) + '天前';
    }
    var s = '';
    if (today.getDate() != new Date(time).getDate()) {
        s = '昨天';
    }
    return s + getFormatedTime(0, time);
}

function formatDate(format = 'hh:mm:ss', date){
    return new Date(date || Date.now()).format(format)
}

function getFormatedTime(i = 0, date = new Date()) {
    if (typeof(date) != 'object') date = new Date(parseInt(date));
    switch (i) {
        case 0:
            return _s(date.getHours()) + ':' + _s(date.getMinutes());
        case 1:
            return date.getMonth() + 1 + '/' + date.getDate() + ' ' + _s(date.getHours()) + ':' + _s(date.getMinutes());
        case 2:
            return date.getMonth() + 1 + '/' + date.getDate();
        case 3:
            return date.getFullYear() + '_' + (Number(date.getMonth()) + 1) + '_' + date.getDate();
        case 4:
            return date.getFullYear() + '/' + (Number(date.getMonth()) + 1) + '/' + date.getDate();

        case 5:
            return date.getFullYear() + '/' + (Number(date.getMonth()) + 1) + '/' + date.getDate() + ' ' + _s(date.getHours()) + ':' + _s(date.getMinutes());
    }
}

function getTime1(s, sh = _l('时'), sm = _l('分')) {
    s = Number(s);
    if (s >= 86400) {
        return parseInt(s / 86400) + _l('天');
    }
    var h = 0,
        m = 0;
    if (s >= 3600) {
        h = parseInt(s / 3600);
        s %= 3600;
    }
    if (s >= 60) {
        m = parseInt(s / 60);
        s %= 60;
    }
    return _s1(h, sh) + _s(m, sm);
}

function parseTime(s) {
    var r = {};
    s = Number(s);
    if (s >= 86400) {
        r.d = parseInt(s / 86400);
    }
    var h = 0,
        m = 0;
    if (s >= 3600) {
        r.h = parseInt(s / 3600);
        s %= 3600;
    }
    if (s >= 60) {
        r.m = parseInt(s / 60);
        s %= 60;
    }
    r.s = s;
    return r;
}

function getVal(value, defaultV) {
    return value === undefined || value == '' ? defaultV : value;
}

function randNum(min, max) {
    return parseInt(Math.random() * (max - min + 1) + min, 10);
}

function toTime(s) {
    var a = s.split(':');
    if (a.length == 1) return Number(s);
    if (a.length == 2) {
        a.unshift(0);
    }
    return a[0] * 3600 + a[1] * 60 + a[2] * 1;
}

function _l(s) {
    return s;
}

function _s1(s, j = '') {
    s = parseInt(s);
    return (s == 0 ? '' : (s < 10 ? '0' + s : s) + j);
}

function _s(i, j = '') {
    return (i < 10 ? '0' + i : i) + j;
}

function _s2(s, j = '') {
    s = parseInt(s);
    return (s <= 0 ? '' : s + j);
}

function insertStyle(cssText) {
    var head = document.getElementsByTagName("head")[0];
    var style = document.createElement("style");
    var rules = document.createTextNode(cssText);
    style.rel = "stylesheet"
    style.type = "text/css";
    if (style.styleSheet) {
        style.styleSheet.cssText = rules.nodeValue;
    } else {
        style.appendChild(rules);
    }
    head.appendChild(style);
    return style;
}
function getEle(opts, s = '', source) {
    if (typeof(opts) != 'object') opts = { action: opts }
    Object.entries(opts).forEach(([k, v]) => {
        s += '[data-' + k;
        if (!isEmpty(v)) s += '="' + String(v) + '"';
        s += ']';
    })
    if (!source) source = $
    return $(source.find(s));
}

function getParentAttr(dom, selector, attr) {
    return getParent(dom, selector).attr(attr ?? selector)
}

function getParentData(dom, selector) {
    for (let par of this.getParent(dom, 'data-'+selector)) {
        let v = $(par).data(selector)
        if (v != undefined) return v
    }
}


function getParent(dom, selector, method = 'parents') {
    dom = $(dom)
    if (selector.startsWith('data-')) selector = '[' + selector + ']'
    if(dom.is(selector)) return dom

    return dom[method](selector+':first') 
}

function getChild(dom, selector) {
    return getParent(dom, selector, 'find')
}

function getChildAttr(dom, selector) {
    return getChild(dom, selector).attr(selector)
}

function getChildData(dom, selector) {
    return getChild(dom, selector).data(selector)
}

function getPrefixedEle(search, selector = '[data-action]', attr = 'action') {
    return $(selector).filter((i, dom) => (dom.dataset[attr] || '').startsWith(search))
}

function uniqueArr(arr) {
    return Array.from(new Set(arr));
}

function ipc_send(type, msg) {
    var data = {
        type: type,
        msg: msg
    }
    if (typeof(nodejs) != 'undefined') {
        nodejs.method(data); // ELECTRON
    } else {
        console.log(JSON.stringify(data));
    }
}

function isInputFocused() {
    return ['input', 'textarea'].includes(document.activeElement.nodeName.toLowerCase())
}



function toast(msg, style = 'bg-info', time = 3000) {
    g_toast.show('default', {
        text: msg,
        class: style,
        delay: time
    });
}

function replaceClass(dom, find, replace, apply = true) {
    if (dom.length) dom = dom[0]
    if (!dom.classList) return

    dom.classList.forEach(c => {
        for (let f of find.split(' ')) c.startsWith(f) && dom.classList.remove(c)
    })
    if (apply && !isEmpty(replace)) {
        replace = replace.split(' ')
        if (replace.length) {
            for (let f of replace) dom.classList.add(f)
        }
    }
    return dom
}


function isScroll(el) {
    let elems = el ? [el] : [document.documentElement, document.body];
    let scrollX = false,
        scrollY = false;
    for (let i = 0; i < elems.length; i++) {
        let o = elems[i];
        // test horizontal
        let sl = o.scrollLeft;
        o.scrollLeft += (sl > 0) ? -1 : 1;
        o.scrollLeft !== sl && (scrollX = scrollX || true);
        o.scrollLeft = sl;
        // test vertical
        let st = o.scrollTop;
        o.scrollTop += (st > 0) ? -1 : 1;
        o.scrollTop !== st && (scrollY = scrollY || true);
        o.scrollTop = st;
    }
    // ret
    return {
        scrollX: scrollX,
        scrollY: scrollY
    };
}

function scrollY(ele, scrollTop = 0) {
    if (scrollTop == -1) scrollTop = ele.prop('scrollHeight')
    ele.animate({ scrollTop }, 500);
}

function cutString(s_text, s_start, s_end, i_start = 0, fill = false) {
    i_start = s_text.indexOf(s_start, i_start);
    if (i_start === -1) return '';
    i_start += s_start.length;
    i_end = s_text.indexOf(s_end, i_start);
    if (i_end === -1) {
        if (!fill) return '';
        i_end = s_text.length
    }
    return s_text.substr(i_start, i_end - i_start);
}

function matchTexts(text, startText, endText, withPrefix = false){
    let match;
    let ret = []
    var regex = new RegExp(`${startText}([\\s\\S]*?)${endText}`, 'g');
    while ((match = regex.exec(text)) !== null) {
        ret.push(withPrefix ? startText + match[1] + endText : match[1]);
    }
    return ret
}

function cutString1(str, key1, key2) {
    var m = str.match(new RegExp(key1 + '(.*?)' + key2));
    return m ? m[1] : '';
}

var hasScrollY = el => el.scrollHeight > el.clientHeight
var hasScrollX = el => el.scrollWidth > el.clientWidth

function arr_equal(arr1, arr2) {
    return arr1.length == arr2.length && arr_include(arr1, arr2)
}

function arr_include(arr, all) {
    return arr.every(key => all.includes(key))
}

function arr_compare(arr1, arr2) {
    arr1 = [...arr1]
    arr2 = [...arr2]
    let removed = []
    arr1.filter(key1 => {
        let i = arr2.indexOf(key1)
        if (i == -1) { // 被移除
            removed.push(key1)
        } else {
            arr2.splice(i, 1) // 移除已存在的
        }
    })
    return {
        removed: removed,
        added: arr2
    }
}

function arraySum(arr) {
    return arr.reduce(function(acr, cur){
      return acr + cur;
    });
  }

function obj_compare(obj1, obj2) {
    let keys1 = Object.keys(obj1);
    let keys2 = Object.keys(obj2);
  
    return {
        changed: keys1.filter(key => obj1[key] !== obj2[key] && keys2.includes(key)),
        added: keys2.filter(key => !keys1.includes(key)),
        removed: keys1.filter(key => !keys2.includes(key))
    }
}
  

function toURL(url, search){
    var params = new URLSearchParams();
    Object.entries(search).forEach(([k, v]) => params.append(k, v))
    url = new URL(url);
    url.search = params;
    return url.href
}

function urlToFile(url) {
    return decodeURI(url).replaceAll('%23', '#')
}

function fileToUrl(url) {
    return url.replaceAll('\\', '/').replaceAll('#', '%23')
    // return safeFileName(encodeURI(url.replaceAll('\\', '/')).replaceAll('#', '%23'))
}

function toPath(path){
    if(!['\\', '/'].includes(path.substr(-1))) path += '/'
    return path
}

function safePath(str) {
    return str
        .replaceAll('\\', '＼')
        .replaceAll('/', '／')
}

function safeFileName(str) {
    return str
        .replaceAll('(', '（')
        .replaceAll(')', '）')
        .replaceAll(':', '：')
        .replaceAll('*', '＊')
        .replaceAll('?', '？')
        .replaceAll('"', '＂')
        .replaceAll('<', '＜')
        .replaceAll('>', '＞')
        .replaceAll("|", "｜")
        .replaceAll('\\', '＼')
        .replaceAll('/', '／')
}

function formatText(text, vars){
    for(let [k, v] of Object.entries(vars)){
        text = text.replaceAll('%'+k+'%', toVal(v || ''))
    }
    return text
}
function parseXML(content){
    return (new DOMParser()).parseFromString(content, "text/xml");
}

function parseINI(data){
    var regex = {
        section: /^\s*\[\s*([^\]]*)\s*\]\s*$/,
        param: /^\s*([\w\.\-\_]+)\s*=\s*(.*?)\s*$/,
        comment: /^\s*;.*$/
    };
    var value = {};
    var lines = data.split(/\r\n|\r|\n/);
    var section = null;
    lines.forEach(function(line){
        if(regex.comment.test(line)){
            return;
        }else if(regex.param.test(line)){
            var match = line.match(regex.param);
            if(section){
                value[section][match[1]] = match[2];
            }else{
                value[match[1]] = match[2];
            }
        }else if(regex.section.test(line)){
            var match = line.match(regex.section);
            value[match[1]] = {};
            section = match[1];
        }else if(line.length == 0 && section){
            section = null;
        };
    });
    return value;
}


function checkStartsWith(str, start, append){
    if(typeof(str) != 'string') return ''
    if(!str.startsWith(start)) str = (append ?? start) + str
    return str
}

function checkEndsWith(str, end, append){
    if(typeof(str) != 'string') return ''
    if(!str.endsWith(end)) str += append ?? end
    return str
}

function replaceStartsWith(str, start){
    if(str.startsWith(start)) str = str.substring(start.length)
    return str
}

function replaceEndsWith(str, end){
    if(str.endsWith(end)) str = str.substring(0, str.length - end.length)
    return str
}