var g_ui = {
    list: {},
    init() {
        $(`<div id="content" style="height: calc(100vh - 35px)"></div>`).appendTo('body')
        g_action.registerAction('ui', (dom, action) => this.show(action[1]))
    },
    register(name, opts) {
        this.list[name] = Object.assign({
            group: 'default'
        }, opts)
        this.update(name)
        return this
    },
    update(name) {
        let opts = this.get(name)
        if (opts) {
            let div = this.getElement(name)
            let h = `
    			<div class="ui" data-name="${name}" data-group="${opts.group}" style="display: none">
    		` + (typeof(opts.html) == 'function' ? opts.html() : opts.html) + '</div>'
            if (div.length) {
                div.replaceWith(h)
            } else {
                div = $(h).appendTo(opts.target || opts.container)
                opts.onAppend && opts.onAppend(div)
            }
        }
    },
    get(name) {
        return this.list[name]
    },
    getElement(name) {
        return $('.ui[data-name="' + name + '"]')
    },
    show(name) {
        let opts = this.get(name)
        if (opts) {
            let div = this.getElement(name)
            if (!div.hasClass('show')) {
                this.hide(this.getShown(opts.group))
                div.addClass('show')
                opts.onShow && opts.onShow()
            }
        }
    },
    getShown(group) {
        return $(`.ui.show[data-group="${group}"]`)
    },
    hide(names) {
        if (typeof(names) == 'object') {
            let a = []
            for (let dom of names) a.push(dom.dataset.name)
            names = a
        } else
        if (!Array.isArray(names)) names = [names]

        for (let name of names) {
            let div = this.getElement(name)
            if (div.hasClass('show')) {
                let opts = this.get(name)
                if (opts) {
                    div.removeClass('show')
                    opts.onHide && opts.onHide()
                }
            }
        }

    },

}

g_ui.init()
