var g_ui = {
    list: {},
    init() {
        $(`<div id="content" class="h-full"></div>`).appendTo('main')
        g_action.registerAction({
            ui: (dom, action) => this.show(action[1]),
            ui_toggle: (dom, action) => this.toggle(action[1]),
        })
    },
    register(name, opts) {
        this.list[name] = Object.assign({
            group: 'default'
        }, opts)
        this.update(name)
        return this
    },
    update(name) {
        let opts = this.get(name)
        if (opts) {
            let div = this.getElement(name)
            let h = `
            <div class="ui p-0 ${opts.class || ''}" data-name="${name}" data-group="${opts.group}" style="display: none;${opts.style || ''}" ${opts.props || ''}>
                ${typeof(opts.html) == 'function' ? opts.html() : opts.html}
            </div>`
            if (div.length) {
                div.replaceWith(h)
            } else {
                div = $(h).appendTo(opts.target || opts.container)
                opts.onAppend && opts.onAppend(div)
                typeof(g_plugin) != 'undefined' && g_plugin.callEvent('ui_init', {name, opts, div})
            }
        }
    },
    isShowing(name){
        return this.getElement(name).hasClass('show')
    },
    toggle(name){
        let showing = this.isShowing(name)
        this[showing ? 'hide' : 'show'](name)
        return !showing
    },
    get(name) {
        return this.list[name]
    },
    getElement(name) {
        return $('.ui[data-name="' + name + '"]')
    },
    show(name) {
        let opts = this.get(name)
        if (opts) {
            let div = this.getElement(name)
            if (!div.hasClass('show')) {
                this.hide(this.getGroupShown(opts.group))
                this.getButton(name).addClass('active')
                div.addClass('show')
                opts.onShow && opts.onShow()
            }
        }
    },
    getGroupShown(group) {
        return $(`.ui.show[data-group="${group}"]`)
    },
    hide(names) {
        if (typeof(names) == 'object') {
            let a = []
            for (let dom of names) a.push(dom.dataset.name)
            names = a
        } else
        if (!Array.isArray(names)) names = [names]

        for (let name of names) {
            let div = this.getElement(name)
            if (div.hasClass('show')) {
                let opts = this.get(name)
                if (opts) {
                    this.getButton(name).removeClass('active')
                    div.removeClass('show')
                    opts.onHide && opts.onHide()
                }
            }
        }

    },
    getButton(target_ui){
        return getEle({target_ui})
    }

}

g_ui.init()
