var g_toast = {
    init() {
        this.audio = $('<audio class="hide" autoplay></audio>').appendTo('body')[0]
        $(`<div id="toast" class="position-fixed" style="z-index: 9999;right: 20px;top: 35px;min-width: 200px;"></div>`).appendTo('body')
    },
    list: {},
    register(id, opts) {
        this.list[id] = Object.assign({
            onParse: d => {
                let level = [
                    ['primary', 'blue'],
                    ['danger', 'red'],
                    ['error', 'red'],
                    ['secondary', 'yellow'],
                    ['info', 'azure'],
                    ['success', 'green']
                ].find(k => k[0] == d.level)[1] || 'primary'
                return `
                    <div class="alert p-1 alert-${level} alert-dismissible" role="alert">
                        <div class="d-flex">
                            <div>
                                ${d.icon ? (d.icon.startsWith('ti') ? `<i class="me-2 fs-2 ti ${d.icon}"></i>` : `
                                <span class="avatar avatar-xs me-2" style="background-image: url(${d.icon})"></span>
                                `) : ''}
                            </div>
                        <div>
                        <h4 class="alert-title">${d.title}</h4>
                        <div class="text-muted">${d.text}</div>
                    </div>
                    </div>
                    <a class="btn-close p-2" data-bs-dismiss="alert" aria-label="close"></a>
                </div>
                `
            }
        }, opts)
        return this
    },

    get(id) {
        return this.list[id]
    },

    tip(id, opts) {
        let d = this.get(id)
        if (!d) return
        opts = Object.assign({
            icon: 'ti-alert-circle',
            title: '提示',
            level: 'primary',
            tips: '',
            text: '',
        }, opts)
        opts.timeout ??= 3000

        let h = d.onParse(opts)
        if (!isEmpty(h)) {
            let toast = $(h).appendTo(d.selector)
            g_pp.setTimeout('toast_'+id+'_tip', () => soundTip('primary'), 100)
            g_pp.setTimeout('toast_'+id, () => toast.remove(), opts.timeout, true)
        }
    },

    toast(data) {
        data.title ||= '提示'
        data.level ||= 'primary'
        this.tip('default', data)
    },

    unregister(id) {
        let d = this.get(id)
        if (!d) return;

        $(d.selector).html('')
        delete this.list[id]
    }

}

g_toast.init()
g_toast.register('default', {
    selector: '#toast',
})

function toast(text, level, timeout){
    g_toast.toast({text, level, timeout})
}

function soundTip(type){
    let arr = {danger: 'res/error.mp3', success: 'res/done.mp3', primary: 'res/pop.mp3'}
    let file = arr[type] || type
    g_toast.audio.src = file
}

