
class TabList {
	constructor(opts) {
		const self = this
		let menu = 'tab_item_' + opts.name
		let { list, saveData, name, moreItems } = opts = Object.assign({
			inst: this,
			class: '',
			cardBody: '',
			body: '{tabs}{contents}',
			dbclick: menu+'_close',
			parseTab: () => '',
			parseContent: () => '',
			onCntChanged: () => {},
			moreItems: ['closeAll'],
			hideOneTab: false, // 一个标签自动隐藏标签栏
			defaultMenuItems: {
				close: {
					icon: 'x',
					text: '关闭',
				},
				closeOther: {
					icon: 'x',
					text: '关闭其他',
				},
				clone: {
					icon: 'copy',
					text: '复制',
				}
			},
			menuItems: {},
		}, opts)
		opts.moreItems = opts.moreItems.map1(item => {
			if(typeof(item) == 'object') return item
			if(item == 'closeAll') return {
				title: '关闭全部',
				itemClass: 'p-0',
				action: menu+'_closeAll',
			}
		})
		g_tabs.list[name] = this

		list = toVal(list) || []
		this.data = new basedata({
			name,
			list,
			saveData,
			defaultList: [],
			primarykey: 'id',
			event: {},
			insertDefault() {
				return {
					props: {}, // 自定义添加到dom的属性值，方便css,js获取
					date: new Date().getTime(),
				}
			},
			refresh: () => self.refresh()
		})
		this.opts = opts

		let items = Object.entries(Object.assign(opts.defaultMenuItems, opts.menuItems)).map(([k, v]) => {
			v.action = menu + '_' + (v.action || k)
			return v
		})

		// TODO action合并成一个
		g_action.registerAction([...opts.moreItems.map(k => k.action), ...items.map(k => k.action)], (dom, action) => {
			let key = dom.dataset.tab ?? g_menu.key
			g_menu.hideMenu(menu)
			switch (action[0].replace(menu+'_', '')) {
				case 'closeOther':
					return this.clear(item => item.id == key)
				case 'close':
					return this.close(key)
				case 'clone':
					return this.clone(key)
				case 'closeAll':
					return this.clear()
				default:
					items.find(k => k.action == action[0]).callback.call(this, { key, name })
			}
		})
		g_menu.registerMenu({
			name: menu,
			selector: `tablist[data-name="${name}"] .nav-item[data-tab]`,
			dataKey: 'data-tab',
			items
		})
		this.getContainer().html(this.getHTML())
		// list.length && this.data.refresh() // 有数据的第一次刷新
	}

	getData(tab) {
		tab ??= this.getActive()
		return this.data.get(tab)
	}

	getValue(tab, k){
		return this.getData(tab)?.[k]
	}

	// 获取标签页内容
	getContent(id) {
		return this.getEle(id)
	}

	getCurrentContent(){
		return this.getContent(this.getActive())
	}

	// 获取标签页标签
	getButton(id) {
		return this.getEle(id, 'tab')
	}

	// 获取容器
	getContainer() {
		return this.container ??= $(this.opts.container)
	}

	// 获取标签页其他选项
	getItemsMenu(){
		return this.getContainer().find('.tab-menus')
	}

	setItems(data) {
		this.data.setData(data)
	}

	// 重新生成
	generalTab(k){
		let container = this.getContainer()
		let id = 'tabs-' + k
		let v = this.data.get(k)
		let title = v.title ?? this.opts.parseTab(k, v) ?? ''
		let props = Object.entries(v.props || {}).map(([k, v]) => `data-${k}="${v}"`).join(' ')
		let tab = $(`
		<li title="${v.alt || ''}" class="nav-item" data-tab="${k}" data-for="${this.opts.name}" data-dbclick="${this.opts.dbclick}" ${props} >
			<a href="#${id}" class="nav-link h-full" data-bs-toggle="tab">
				${v.icon ? `<i class="ti ti-${v.icon} fs-2 me-1" style="${v.icon_color ? 'color: '+v.icon_color : ''}"></i>` : ''}
				<span>${title}</span>
			</a>
		</li>`)
		// <i class="ti ti-x ms-2" data-action="tab_close"></i>
		let content = $(`
		<div class="tab-pane h-full" id="${id}" data-for="${this.opts.name}" data-tab-content="${k}" ${props}>
				${v.html ?? this.opts.parseContent(k, v) ?? ''}
		</div>`)
		
		let _tab = this.getEle(k, 'tab')
		if(_tab.length){
			_tab.replaceWith(tab)
		}else{
			_tab = tab.appendTo(container.find('._tabs-tablist')[0])
		}

		let _content = this.getEle(k, 'tab-content')
		if(_content.length){
			_content.replaceWith(content)
		}else{
			_content = content.appendTo(container.find('._tabs-tabcontent')[0])
		}

		this.doms[k] = {tab: _tab, content: _content}
		v.active && this.setActive(k)
	}

	getTabs(){
		return this.data.getIndexs()
	}

	// 刷新
	refresh() {
		this.update()
		let active = this.getActive()
		active && this.setActive(active)

		let tabs = this.getTabs()
		let cnt = tabs.length
		let tablist = this.getContainer().find('.card-tabs')
		if (cnt == 0) {
			let defaultTab = toVal(this.opts.defaultTab)
			if (defaultTab) { // 始终保持新建标签页
				this.add(Object.assign(defaultTab, { id: 'homepage' }), true)
			}
		} else
		if(cnt == 1 && this.opts.hideOneTab){
			tablist.addClass('hide1')
		}else
		if (cnt > 1) { // 新建标签后自动关闭主页标签
			if(!this.opts.keepDefaultTab && tabs.includes('homepage')) this.close('homepage')
			tablist.removeClass('hide1')
		}
		this.opts.onCntChanged(cnt)
		if(!this.inited) this.inited = true & this.callEvent('init', {name: this.name})
		return this
	}

	find(key, val){
		return this.data.search(key, val)
	}

	// 获取最后激活
	getActive() {
		let index = this.data.search('active', true)
		if (index) {
			let item = this.data.list[index]
			return this.data.getIndex(item)
		}
	}

	// 获取tab按钮或者内容
	getEle(id, type = 'tab-content') {
		return this.getContainer().find(`[data-for="${this.opts.name}"][data-${type}="${id}"]`)
	}

	// 设置激活
	setActive(id, active = true) {
		let lastActive = this.getActive()
		if(lastActive != undefined){
			this.data.removeVal(lastActive, 'active', false)
			this.getEle(lastActive, 'tab-content').removeClass('active')
		}
		this.data.setVal(id, 'active', true, false) // 不刷新显示，避免死循环

		if (active) {
			let a = this.getEle(id, 'tab').find('a')
			a.length && a[0].click()
			this.getEle(id, 'tab-content').addClass('active show')
		}
	}

	getSibling(i, id) {
		id ??= this.getActive()
		let tabs = this.getTabs()
		let index = tabs.indexOf(id)
		if (index != -1) {
			index += i
			return tabs[Math.max(0, Math.min(tabs.length - 1, index))]
		}
	}

	offsetActive(offset, id) {
		let tab = this.getSibling(offset, id)
		if (tab != undefined) this.setActive(tab)
	}

	setActiveIndex(i){
		let tabs = this.getTabs()
		if(i >= 0 && i <= tabs.length - 1){
			this.setActive(tabs[i])
		}
	}

	next() {
		this.offsetActive(1)
	}

	prev() {
		this.offsetActive(-1)
	}

	doms = {}
	update(){
		let tabs = this.getTabs()
		let old = Object.keys(this.doms)
		let {added, removed} = arr_compare(old, tabs) // 比较tabs的改动
		removed.forEach(k => {
			Object.values(this.doms[k]).forEach(dom => dom.remove())
			delete this.doms[k]
		})
		added.forEach(k => this.generalTab(k))
		this.callEvent('update', { name: this.opts.name, added, removed })
	}

	// 获取html
	getHTML() {
		let {class: card_class, name, nowarp, moreItems, cardBody, body, cardTabs} = this.opts
		return `<tablist class="card bg-unset border-0 h-full ${card_class}" data-name="${name}">${body}</tablist>`
		.replace('{tabs}', `
		<div class="d-flex w-full p-0 m-0 card-tabs ${cardTabs || ''}">
			<div class="card-header flex-grow-1 border-0 w-full">
				<ul class="_tabs-tablist nav nav-tabs border-bottom-0 p-0 card-header-tabs ${nowarp ? 'flex-nowrap scroll-x hideScroll' : ''}" data-bs-toggle="tabs"></ul>
			</div>
			${moreItems.length ? `
			<div class="tab-menus d-flex text-end border-start">
			${g_tabler.build_dropdown({
				title: ' ',
				class: 'dropstart',
				btnClass: 'border-0',
				items: moreItems,
			})}
			</div> 
			` : ''}
		</div>
		`).replace('{contents}', `
		<div class="card-body p-0 ${cardBody} h-full overflow-y">
			<div class="_tabs-tabcontent tab-content h-full overflow-y-container overflow-x-hidden"></div>
		</div>
		`)
	}

	// 添加tab
	add(opts, active = false) {
		let tab = opts.id ??= guid()
		if (!isEmpty(tab) && this.data.exists(tab)) return

		this.data.set(tab, opts)
		active && this.setActive(tab)
		return tab
	}

	clone(tab) {
		let item = this.data.get(tab)
		if (item) {
			return this.add(Object.assign({}, item, { tab: undefined }))
		}
	}

	// 移除tab
	close(tab) {
		let item = this.data.get(tab)
		if (item) {
			let tabs = this.getTabs()
			let index = tabs.indexOf(tab)
			if (this.callEvent('close', { tab, item, inst: this }) !== false) {
				this.data.remove(tab)
				if (tabs.length > 1) {
					return this.setActive(tabs[index + (index == tabs.length - 1 ? -1 : 1)]) // 关闭标签后自动激活其他标签
				}
			}
		}
	}

	clear(filter) {
		let list = filter ? this.data.list.filter(filter) : []
		return this.data.setData(list)
	}

	callEvent(type, data) {
		let en = 'event_' + type
		g_plugin.callEvent('tab.'+en, data)

		let ev = this.opts[en]
		return ev && ev.call(this, data)
	}

	
    setValue(key, k, v, save = true, update = true) {
		let item = this.data.get(key)
		if(item){
			setObjVal(item, k, v)
			save && this.data.save()
			update && this.generalTab(key)
		}
    }

	setValues(key, vals, save = true, update = true) {
		let item = this.data.get(key)
		if(item){
			for(let [k, v] of Object.entries(vals)){
				setObjVal(item, k, v)
			}
			save && this.data.save()
			update && this.generalTab(key)
		}
    }

}

var g_tabs = {
	list: {},
	init() {
		$(() => {
			g_style.addStyle('tab', `
				tablist {
					z-index: 0;
				}
				tablist ul li.nav-item {
					max-width: 150px;
					height: 33px;
				}
				tablist ul li.nav-item span {
					overflow: hidden;
					text-overflow: ellipsis;
					white-space: nowrap;
				}
				tablist:not(.show-icons) ul li.nav-item:nth-of-type(n+4) i {
					display: none;
				}
			`)
			const onEvent = function (ev) {
				let { type, target, relatedTarget } = ev
				let targetName = getParentAttr(target, 'data-for') // 获取目标tab所属
				// if(!relatedTarget || !target) return // 新建标签页不知道为啥触发两次？？
				let name = this.dataset.name
				if (name != undefined) {
					if(targetName != name) return // 解决会触发tab下另一个tab的bug

					let inst = g_tabs.getInst(name)
					let tab = getParentAttr(target, 'data-tab')
					if (type == 'show') inst.setActive(tab, false) // 点击显示tab触发内部事件
					inst.callEvent(type, { name, tab, target, inst, ev })
				}
			}
			// g_action.registerAction({
			// 	tab_close: (d, a, e) => {
			// 		console.log(d)
			// 		clearEventBubble(e)
			// 	}
			// })
			$(document)
				.on('show.bs.tab', 'tablist', onEvent)
				.on('shown.bs.tab', 'tablist', onEvent)
				.on('hide.bs.tab', 'tablist', onEvent)
		})
	},
	register(opts){
		return new TabList(opts)
	},
	getInst(name) {
		return this.list[name]
	},
	method(name, method, ...args) {
        let inst = this.getInst(name)
        return inst[method].apply(inst, args)
    },
}

g_tabs.init()