var g_tabler = {
    removeToolTips(){
        $('.tooltip.show').remove();
    },
    colors: ['#206bc4', '#4299e1', '#ae3ec9', '#d6336c', '#d63939', '#f76707', '#f59f00', '#74b816'],
    build_colorSelect({name, colors, props}){
        let h = (colors ?? this.colors).map(color => `
        <div class="col m-1">
            <label class="form-colorinput">
              <input name="${name}" type="radio" value="${color}" class="form-colorinput-input">
              <span class="form-colorinput-color rounded-circle" style="background-color:${color}"></span>
            </label>
        </div>`).join('')
        return `
        <div class="d-flex colorpicker overflow-x-auto scroll-x hideScroll" ${props ?? ''}>
            <div class="col m-1">
                <input type="color" name="${name}" class="form-control form-control-color border-none p-0" style="width: 24px;" value="#206bc4" title="选择颜色">
            </div>
            ${h}
        </div>
        `
    },
    bind_all() {

    },
    init() {
        $(document).
        on('click', '.form-videocheck', function(e) {
            let input = this.querySelector('.form-videocheck-input')
            input.checked = !input.checked
            clearEventBubble(e)
        }).
        on('click', '[data-bs-dropdown]', function(e) {
            let dropdown = this.dataset.bsDropdown
            // data-bs-auto-close
            let rect = this.getBoundingClientRect()
            let div = $('#' + dropdown).find('.dropdown-menu')
            div.css({
                display: 'block',
                position: 'fixed',
                zIndex: 999,
                left: rect.x - div.width(),
                top: rect.top - (div.height() - rect.height) / 2,
            })
        })

        $(() => {
            g_action.registerAction({
                toggleCollapse: (dom, [action, target, config]) => {
                    let div = $(target)
                    let showing = div.hasClass('show')
                    div.collapse('toggle')
                    !isEmpty(config) && setConfig(config, !showing)
                },
            })

        })
        
       
        // $(this.bind_all());
        // .on('click', 'a[data-bs-toggle]', function(e){
        //     let action = this.dataset.action_toggle
        //     console.log(action)
        // })

        // let error = console.error
        // console.error = msg => alert(msg, { title: '错误', type: 'danger' })

    },
    build_breadcrumb({id = '', list, action = ''}){
        return `
        <ol class="breadcrumb" aria-label="breadcrumbs">
            ${list.map(({title, value = '', selected}, i) => {
                return `
                    <li style="max-width: 100px" class="breadcrumb-item text-nowrap ${selected ? 'active' : ''}" ${selected ? 'aria-current="page"': ''} data-value="${value}" data-action="${action}">
                        <a href="#" title="${value}">${title || value}</a>
                    </li>
                `
            }).join('')}
        </ol>
        `
    },


    build_accordion1({id = '', list, showAll, classes = '', itemClass = '', buttonClass = ''}){
        return `<div class="accordion w-full ${classes}" id="${id}">
            ${list.map(({title, show, html}, i) => {
                let sid = 'accordion_item,'+id+','+i
                return `
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button ${buttonClass}" type="button" data-bs-toggle="collapse" data-bs-target="#${sid}" aria-expanded="true" aria-controls="${sid}">
                            ${title}
                        </button>
                    </h2>
                    <div id="${sid}" class="accordion-collapse collapse ${showAll || show ? 'show' : ''}" ${showAll ? '' : `data-bs-parent="#${id}"`}>
                        <div class="accordion-body ${itemClass}">
                            ${html}
                        </div>
                    </div>
                </div>
                `
            }).join('')}
        </div>`
    },

    build_pageination({id = '', page, maxPage, minPage = 1, maxShow = 5, action = '', moreAction = '', prevAction = '', nextAction = ''}){
        let html = ''
        const addPageItem = ({classes, text, action}, i) => html += `<li ${i ? `data-page=${i}` : ''} class="bg-auto ms-1 me-1 page-item ${classes || ''}" data-action="${action}"><a class="page-link" href="#">${text}</a></li>`
        
        page > 1 && addPageItem({text: `<i class="ti ti-arrow-left fs-2"></i>`, action: prevAction})
        let cnt = 0
        let offset = parseInt(maxShow / 2)
        let start = Math.max(1, page-offset)
        let end = Math.max(maxPage, Math.min(maxPage,page+offset))
        for(var i=start;i<=end;i++){
            if(maxShow > 0 && ++cnt >= maxShow){
                if(i != maxPage){
                    addPageItem({text: '...', action: moreAction})
                    addPageItem({text: maxPage, action}, maxPage)
                }
                break
            } 
            addPageItem({text: i, classes: i == page ? 'active' : '', action}, i)
        }
        if(page < maxPage) addPageItem({text: `<i class="ti ti-arrow-right fs-2"></i>`, action: nextAction})
        return `
        <nav id="${id}" class="bg-auto">
            <ul class="pagination p-0 m-0 justify-content-center">
                ${html}
            </ul>
        </nav>
        `
    },

    build_dropdown({items = [], btnClass, menuClass, title, itemClass, class: classes}){
        if(items.length == 0) return ''
        let h = items.map(v => v ? `<a class="dropdown-item ${itemClass ?? ''}" data-action="${v.action}" ${v.props || ''}>${v.title}</a>` : '<div class="dropdown-divider"></div>').join('')
        return title ? `<div class="dropdown ${classes ?? ''}">
          <a class="btn dropdown-toggle ${btnClass ?? ''}" data-bs-toggle="dropdown">${title}</a>
          <div class="dropdown-menu" ${menuClass ?? ''}>${h}</div></div>` : h
    },

    build_table(opts){
        let body = ''
        let {headers, items, headerClass, tableClass, id, bodyClass} = opts
        let header = headers.map(item => `<th scope="col ${item.class ?? ''}">${item.title}</th>`).join('')
        items && Object.entries(items).forEach(([id, data]) => {
            body += `
            <tr data-key="${id}" class="${data.class ?? ''}" ${data.props ?? ''}>
                ${data.row.map((val, i) => {
                    let tag = i == 0 ? 'th' : 'td'
                    return `<${tag} scope="${i == 0 ? 'row' : ''}">${val}</${tag}>`
                }).join('')}
            </tr>`
        })

        return `
        <table id="${id ?? ''}" class="table ${tableClass ?? ''}">
            <thead class="${headerClass ?? ''}">${header}</thead>
            <tbody class="${bodyClass ?? ''}">${body}</tbody>
        </table>
        `
    },
    build_icons(data) {
        let h = ''
        for (let v of data) h += `<a alt="${v.title ?? ''}" class="me-2 ${v.classes ?? ''}" href="#" data-action="${v.action}"><i class="ti ti-${v.icon}"></i></a>`
        return h
    },
    build_dropdownItems(data) {
        let h = ''
        let buildItem = ({ title, action, classes }) => `<a class="${classes ?? ''}" href="#" data-action="${action}">${title}</a>`
        let parseItem = (v, classes = '') => {
            let r = {}
            if (v == 'add') {
                r = { title: '添加', icon: 'plus' }
            } else
            if (v == 'delete') {
                r = { title: '删除', icon: 'trash', classes: 'text-danger' }
            } else
            if (v == 'refresh') {
                r = { title: '刷新', icon: 'refresh' }
            } else
            if (v == 'edit') {
                r = { title: '编辑', icon: 'edit' }
            } else
            if (v == 'reset') {
                r = { title: '清空', icon: 'recycle' }
            }
            if (r.classes) {
                r.classes = r.classes + ' ' + classes
            }
            return Object.assign({
                classes,
                action: typeof(v) == 'string' ? data.id + '_' + v : '',
            }, r)
        }
        for (let v of data.actions) {
            if (Array.isArray(v)) {
                h += `
                <div class="dropdown">
                    <a href="#" class="btn-action dropdown-toggle" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                      <i class="ti ti-dots-vertical"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end">
                        ${(() => {
                            let h1 = '';
                            v.forEach(k => h1 += buildItem(parseItem(k, 'dropdown-item')))
                            return h1
                        })()}
                    </div>
                  </div>
                `
                continue
            }
            v = parseItem(v, 'btn-action')
            if (typeof(v) == 'object') {
                v.title = `<i class="ti ti-${v.icon}"></i>`
                h += buildItem(v)
            }
        }
        return `
            <div class="card-actions btn-actions">${h}</div>
        `
    },
    color_random(i){
        let colors = ['blue', 'azure', 'indigo', 'purple', 'pink', 'red', 'orange', 'yellow', 'lime', 'green', 'teal', 'cyan']
        let len = colors.length - 1
        if(i == undefined){
            i = randNum(0, len)
        }else{
            i = i % len
        }
        return colors[i]
    },

    build_placeHolder({cnt = 1, type = 'avatar'}){
        let html = ''
        for(let i=0;i<cnt;i++){
            let h = ''
            switch(type){
                case 'avatar':
                    h = `
                    <div class="col-12 mb-2">
                        <div class="col-auto">
                            <div class="avatar placeholder"></div>
                        </div>
                        <div class="col">
                        <div class="placeholder col-9"></div>
                        <div class="placeholder col-11"></div>
                        </div>
                    </div>`
            }
            html += h
        }
        return `<div class="row">${html}</div>`
    },
    build_stamp(data) {
        let { color, icon } = data
        return `
        <div class="card-stamp">
            <div class="card-stamp-icon bg-${color ?? 'yellow'}">
              <i class="ti ti-${icon ?? 'bell'}"></i>
            </div>
          </div>`
    },

    build_badges(list) {
        let h = ''
        list.forEach(text => h += this._build_badge({ text, color: 'blue', class: 'me-2' }))
        return h
    },

    build_badge(text, color = 'blue') {
        return this._build_badge({ text, color })
    },

    _build_badge(opts) {
        opts = Object.assign({
            color: 'blue',
            text: '',
            class: ''
        }, opts)
        return `<span class="${opts.class} badge badge-outline m-1 text-${opts.color}">${opts.text}</span>`
    },

    build_accordion(opts, obj = true) {
        opts = Object.assign({
            header: '',
            parent: true, // 选择后关闭其他
            emptyName: '默认分组',
            onOpen: e => {},
            onClose: e => {},
            collapse_end: '',
            collapse_start: '',
        }, opts)

        let groups = {}
        opts.datas.every((item, i) => {
            if (!groups[item.group]) groups[item.group] = []
            groups[item.group].push(item)
            return true
        })

        let h = '';
        let i = 0
        let id = opts.id ?? new Date().getTime()
        for (let [group, items] of Object.entries(groups)) {
            let header = typeof(opts.header) == 'function' ? opts.header(group, items) : opts.header
            h += ` <div class="accordion-item" id="accordion-${id}-${group}">
                <h2 class="accordion-header bg-body">
                  <button tabindex="-1" data-collapse="${group}" class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-${id}-${group}" aria-expanded="true">
                    ${header.replace('{index}', ++i).replace('{i}', groups[group].length).replace('{title}',_l(group) ?? opts.emptyName)}
                  </button>
                </h2>`
            items.sort((a, b) => b.primary - a.primary).forEach(item => {
                h += `
                    <div id="collapse-${id}-${group}" class="collapse accordion-collapse ${opts.default === true ?? group == opts.default ? 'show' : ''}" ${opts.parent ? `data-bs-parent="#accordion-${id}"` : ''} ${item.prop ?? ''}>
                          <div class="accordion-body ${item.bodyClass} pt-0" >
                          ${opts.collapse_start}
                          ${item.html}
                          ${opts.collapse_end}
                          </div>
                    </div>
                    `
            })
            h += `</div>`
        }
        if (!obj) return h

        let div = $(`<div class="accordion" id="accordion-${id}">` + h + '</div>')
        div.find('[data-bs-toggle="collapse"]').on('click', function(e) {
            if (this.classList.contains('collapsed')) { // 关闭
                opts.onClose.call(this, e)
            } else {
                opts.onOpen.call(this, e)
            }
        })
        return div
    },

    build_checkbox_list(d) {
        let h = ''
        let { keys, vals } = ObjMaps(d.list)
        keys.forEach((k, i) => {
            h += `
            <label class="form-check ${d.inline ? 'form-check-inline' : ''}">
              <input class="form-check-input" type="checkbox" value="${k}" ${k == d.value ? 'checked' : ''}>
              <span class="form-check-label">${vals[i]}</span>
            </label>
            `
        })
        return `<div id="${d.id}">${h}</div>`
    },

    build_select(d) {
        let h = ''
        let { keys, vals } = ObjMaps(d.list)
        keys.forEach((k, i) => {
            h += `<option value="${k}" ${k == d.value ? 'selected' : ''}>${vals[i]}</option>`
        })
        return `
        <div id="${d.id ?? ''}">
            <select name="${d.name ?? ''}" class="form-select ${d.class ?? ''}" ${d.props ?? ''}>${h}</select>
        </div>`
    },

    build_radio_list(d) {
        let h = ''
        let { keys, vals } = ObjMaps(d.list)
        keys.forEach((k, i) => {
            h += `
            <label class="form-check">
              <input class="form-check-input" name='${d.name || 'radios'}' type="radio" value="${k}" ${k == d.value ? 'checked' : ''}>
              <span class="form-check-label">${vals[i]}</span>
            </label>
            `
        })
        return `<div id="${d.id || ''}">${h}</div>`
    },

   
    
    buildButtonGroup(list, classes = '') {
        let h = ''
        list.forEach(({classes, action, title, tip = '', icon }) => {
            h += `
            <a href="#" class="btn btn-icon ${classes}" aria-label="Button" data-action="${action}" title="${tip}">
                ${!isEmpty(icon) ? `<i class="ti ti-${icon} fs-2 ${isEmpty(title) ? 'me-2' : ''}"></i>` : ''}
                ${title || ''}
            </a>`
        })
        return `<div class="${classes} w-full btn-group" style="height: 35px;">${h}</div>`
    },

    buildDataGrid(list) {
        let h = ''
        for (let v of list) {
            h += `
                <div class="d-flex p-1">
                    <span class="badge bg-${v.color}-lt">${v.title}</span>
                    <div class="flex-fill text-end">${v.value}</div>
                </div>
            `
        }
        return `
        <div class="rows align-items-center mt-2 w-full align-self-end">
            ${h}
        </div>`
    }
}

function ObjMaps(obj) {
    let vals = Object.values(obj)
    let keys = Array.isArray(obj) ? [...vals] : Object.keys(obj)
    return { keys, vals }
}

const closeAllDropdown = () => $('.dropdown-menu.show').removeClass('show')
g_tabler.init();