

class Star {
    constructor(name, opts) {
        this.name = name
        opts = this.opts = Object.assign({
            hoverEffect: true,
            onSelected: () => {},
            tooltips: ['一星', '二星','三星','四星','五星'],
            parseItem: i => `<i data-value="${i}" class="ti ti-star-filled"></i>`,
        }, opts)
        g_star.register(name, this)
    }

    getSelected(){
        return this.opts.selected
    }

    setSelected(val){
        val =parseInt(val)
        if(val == this.opts.selected) val = -1
        if(this.opts.onSelected(val) !== false){
            this.opts.selected = val
            this.refresh()
        }
    }

    getHTML(){
        let html = ''
        let {max, selected, tooltips, hoverEffect} = this.opts
        for(let i=0;i<max;i++) html += `<div title="${tooltips[i] ?? ''}" ${hoverEffect ? 'data-hover="star_hover" data-out="star_out"' : ''} data-action="star_selected" data-value="${i}" class="star_item ${i !== max - 1 ? 'me-2' : ''} ${i <= selected ? 'star_selected' : ''}">${this.parseItem(i)}</div>`
        return `<div data-star="${this.name}">${html}</div>`
    }

    parseItem(item){
        return this.opts.parseItem(item)
    }

    // 获取外div
    getContainer() {
        let el = getEle({star: this.name})
        if(!el.length && this.opts.container){
            el = $(this.getHTML()).appendTo(this.opts.container)
        }
        if(this.opts.selected == undefined && el.data('value')) this.setSelected(el.data('value'))
        return el
    }

    // 触发事件
    callEvent(eventName, ...args) {
        // console.log(eventName, args)
    }

    // 展示
    show() {
        this.toggle(true)
    }

    // 隐藏
    hide() {
        this.toggle(false)
    }

    // 切换隐藏
    toggle(show) {
        show ??= this.isShowing()
        this.getContainer().toggleClass('hide', !show)
        this.callEvent('show', !show)
    }

    // 是否显示
    isShowing() {
        return this.getContainer().hasClass('hide')
    }

    // 刷新结构
    refresh() {
        this.getContainer().replaceWith(this.getHTML())
        this.callEvent('refresh')
    }

    // 删除
    remove() {
        this.getContainer().remove()
        delete g_star.list[this.opts.name]
        this.callEvent('remove')
    }

}

var g_star = {
    init() {
        g_style.addStyle('star', `
            [data-star] {
                display: flex;
            }

            [data-star] .star_selected {
                color: red
            }
        `)
        Object.getOwnPropertyNames(Star.prototype).forEach(method => {
            if (!['constructor'].includes(method) && !method.startsWith('_')) {
                this[method] = (id, ...args) => this.method(id, method, ...args)
            }
        })

        g_action.registerAction({
            star_selected: dom => {
                this.method(getParentData(dom, 'star'), 'setSelected', dom.dataset.value)
            },
            star_hover: dom => {
                let inst = this.getInst(getParentData(dom, 'star'))
                let index = dom.dataset.value
                inst.getContainer().find('.star_item').each((i, star) => {
                    star.classList.toggle('star_selected', i <= index)
                })
            },
            star_out: dom => {
                this.method(getParentData(dom, 'star'), 'refresh')
            },
        })
    },

    list: {},

    register(name, opts) {
        this.list[name] = opts
    },

    unregister(name, opts) {
        delete this.list[name]
    },

    getInst(id) {
        return this.list[id]
    },

    method(id, method, ...args) {
        let inst = this.getInst(id)
        if (inst) {
            return inst[method].apply(inst, args)
        }
    },
}

g_star.init()

// alert(`
//     <div data-star="test"></div>
// `, {
//     onShow(){
//         var star = new Star('test',  {
//             max: 5,
//             selected: 2,
//             onSelected(){

//             }
//         });
//         star.refresh()
//         console.log(star)
//     }
// })

