var g_sidebar = {
    // 移除style
    style_remove() {
        if (this.style) {
            this.style.remove()
            delete this.style
        }
    },
    // 初始化style
    style_init() {
        let css = `
            :root {
                --nav-height: 35px;
            }
            
            .sidebar {
                display: none;
                position: fixed;
            }

            #sidebar_top {
                left: 0;
                top: var(--nav-height);
                width: 100vw;
                height: var(--offset-top);
            }

            #sidebar_top.hideSidebar {
                margin-top: calc(0 - (var(--offset-top) + var(--nav-height)));
            }

            #sidebar_right, #sidebar_left, main{
                top: calc(var(--offset-top) + var(--nav-height));
                height: calc(var(--full-height) - var(--nav-height) - var(--offset-top) - var(--offset-bottom));
            }

            #sidebar_bottom {
                left: 0;
                bottom: var();
                width: 100vw;
                height: var(--offset-bottom);
            }

            #sidebar_bottom.hideSidebar {
                margin-bottom: calc(0 - var(--offset-bottom));
            }
            
            #sidebar_right {
                right: 0;
                width: var(--offset-right);
                min-width: var(--offset-right);
            }

            #sidebar_right.hideSidebar {
                margin-right: calc(0 - var(--offset-right));
            }

            #sidebar_left {
                left: 0;
                width: var(--offset-left);
                min-width: var(--offset-left);
            }
            #sidebar_left.hideSidebar {
                margin-left: calc(0px - var(--offset-left));
            }
            
            main[sidebar-right]{
                padding-right: var(--offset-right);
            }
            main[sidebar-left]{
                padding-left: var(--offset-left);
            }
           
        `;
        // for (let [name, obj] of Object.entries(this.list)) css += obj.style || ''
        this.style = $(`<style>${css}</style>`).appendTo('html')
    },

    init() {
        let self = this
        this.style_init()
        g_action.registerAction('sidebar_toggle', (dom, action) => {
            g_setting.toggleValue('sidebar_' + action[1])
        })

        
        let _arr = ['sidebar_left', 'sidebar_right', 'sidebar_bottom', 'sidebar_top']
        g_setting.onSetConfig(_arr, (v, k) => {
            k = k.substring(8)
            getEle('sidebar_toggle,' + k).toggleClass('text-primary', v)
            self.toggle(k, v)
        })

        $(() => setTimeout(() => g_setting.apply(_arr), 250));
    },

    list: {},
    register(name, opts) {
        opts = Object.assign({
            css: '',
            html: '',
            onShow: () => {},
            onHide: () => {},
        }, opts)
        this.list[name] = opts
        this.load(name)
    },

    get(name) {
        return this.list[name]
    },

    load(name) {
        let d = this.get(name)
        if (!d) return

        let id = 'sidebar_' + name
        let div = $(id)
        if (div.length) {
            div.html(d.html)
        } else {
            div = $(`
                <div class="sidebar bg-auto overflow-hidden" id="${id}" style="${d.css}">
                    ${d.html}
                </div>
            `).appendTo('body')
            d.onInit && d.onInit(div)
        }
    },

    sidebar_get(name) {
        return $('#sidebar_' + name)
    },

    show(name) {
        let div = this.sidebar_get(name)
        // todo call event
        if (div.length) {
            div.show().removeClass('hideSidebar')
            $('main').attr('sidebar-' + name, true)

            let opts = this.get(name)
            opts.onShow && opts.onShow.call(div)
        }
    },

    isShowing(name) {
        let div = this.sidebar_get(name)
        return div.length && !div.hasClass('hideSidebar')
    },

    toggle(name, show) {
        if (show === undefined) show = !this.isShowing(name)
        this[show ? 'show' : 'hide'](name)
        return show
    },

    hide(name) {
        let div = this.sidebar_get(name)
        if (div.length) {
            div.addClass('hideSidebar')
            $('main').attr('sidebar-' + name, null)
            let opts = this.get(name)
            opts.onHide && opts.onHide.call(div)
        }
    }
}

g_sidebar.init()