var g_setting = {
    default: {}, 
    tabs: {},
    getTab(name) {
        return this.tabs[name]
    },

    init() {
        const self = this
        g_action.registerAction({
            settings: (dom, action) => {
                g_form.remove('settings') // 移除旧的form
                let {elements, onClose, onShow, title, callback} = self.getTab(action[1])
                let h = Object.entries(self.tabs).map(([tab, item]) =>  `
                <li class="nav-item" role="presentation">
                    <a href='#' data-action="${item.action || 'settings,'+tab}" class="nav-link ${tab == action[1] ? 'active' : ''}" role="tab"><i class="ti ti-${item.icon} me-2"></i>${item.title}</a>
                </li>`).join('')

                Object.assign(elements, {
                    tabs: {
                        type: 'html',
                        html: `<ul class="nav nav-tabs nav-fill" data-bs-toggle="tabs" role="tablist">${h}</ul>`,
                        primary: 999,
                    },
                })
                g_form.confirm1({
                    elements,
                    title: '设置',
                    id: 'settings',
                    callback({vals, changes}){
                        if(callback != undefined && callback({vals, changes}) === false) return
                        for (let [k, v] of Object.entries(changes)){
                            let cb = elements[k].onSave
                            if(cb) return cb(v)
                            setConfig(k, v)
                        }
                    }
                },{
                    bodyClass: 'p-0',
                    btn_ok: '保存'+title+'设置',
                    class: 'pt-0',
                    width: '80%',
                    onClose, onShow
                })

            },
            darkMode: dom => g_setting.setConfig('darkMode', !$('body').hasClass('theme-dark')),
            clearConfig: () => confirm('确定要清空配置吗？', {type: 'danger'}).then(() => {
                g_config = {}
                this.save() & location.reload()
            }),
            clearLocalstotage: () => confirm('确定要清空客户端数据吗？', {type: 'danger'}).then(() => local_clearAll() & location.reload()),
        })
        g_setting.onSetConfig({
            darkMode: b => {
                getEle('darkMode').toggleClass('text-primary', b)
                $('body').toggleClass('theme-dark', b)
            },
        })
    },

    bind: {},
    onSetConfig(list, callback) {
        let isArr = Array.isArray(list)
        if (typeof(list) == 'object' && !isArr) {
            Object.assign(this.bind, list)
            return this
        }
        if (!isArr) list = [list]
        for (let k of list) this.bind[k] = callback
        return this;
    },

    call(k, v) {
        if (this.bind[k]) {
            return this.bind[k](v, k)
        }
    },

    // 激活配置执行的操作
    // apply('key')
    // apply({key: value})
    apply(list, def, check) {
        entriesObject(list).forEach(([k, v]) => {
            v ??= this.getConfig(k, def)
            if (check && check(v) === false) return

            this.call(k, v)
        })
        return this
    },

    setConfig(k, v) {
        g_config[k] = v;
        if (this.call(k, v) === false) return;
        this.save()
    },
    save(){
        local_saveJson('config', g_config);
    },
    getConfig(k, def) {
        if (Array.isArray(k)) {
            let r = {}
            k.forEach(n => r[n] = g_config[n] ?? def)
            return r
        }
        var v = g_config[k];
        return isEmpty(v) ? def == undefined ? this.getDefault(k) : def : v
    },

    toggleValue(k, b) {
        if (b == undefined) b = !this.getConfig(k);
        this.setConfig(k, b)
        return b
    },

    setDefault(k, v) {
        let isArr = Array.isArray(k)
        if (typeof(k) == 'object' && !isArr) {
            Object.assign(this.default, k)
        }else{
            [].concat(k).forEach(_k => this.default[k] = v)
        }
    },

    getDefault(k) {
        return this.default[k]
    },

}

var g_config = local_readJson('config', {

});

$(() => g_setting.init())
const getConfig = (k, def) => g_setting.getConfig(k, def)
const setConfig = (k, v) =>  g_setting.setConfig(k, v)
const toggleConfig = (k, v) => g_setting.toggleValue(k, v)

 function getProxy() {
     let proxy = getConfig('proxy')
     return proxy ? { proxy, http_proxy: proxy, https_proxy: proxy } : {}
 }

