

var g_selection = {
    list: [],
    pos: {},
    init(){
        const self = this

        const cancelTimer = () => {
            self.moving = false
            g_pp.clearTimeout('moving')
            delete self.timer
        }
        g_style.addStyle('selection', `
            ._selection {
                position: absolute;
                z-index: 9999;
                background-color: rgba(0, 0, 0, .6);
            }
        `)
        $(window).on('blur', () => cancelTimer())
        $(document)
        .on('dblclick', e => {
            let target = $(e.target)
            self.list.some(opts => {
                let {container, selector, dbclickUnset} = opts
                if(dbclickUnset && getParent(target, container).length){
                    self.unset(true, opts)
                    return true
                }
            })
        })
        .on('click', function(e) {
            let target = $(e.target)
            let opts = self.list.find(({container, selector}) => {
                if(!target.parents(container).length) return false
                if(target.is(selector)) return true
                let par = target.parents(selector)
                if(par.length){
                    target = par // 指向父元素
                    return true
                }
            })
            if(!opts) return

            let {selectedClass, multiSelect, selector} = opts
            let selected = opts.getSelected()
            if (e.shiftKey && multiSelect && selected.length) { // 范围选中
                let i1 = $(selected[0]).index()
                let i2 = target.index()
                let list = []
                let par = target.parents(opts.container)
                for (let i = Math.min(i1, i2); i < Math.max(i1, i2); i++) {
                    let child = par.find(selector+`:eq(${i})`).addClass(selectedClass)
                    list.push(child)
                    opts.beforeSelected(child, true, 'multi')
                }
                return opts.done(list)
            }else
            if(!multiSelect || (multiSelect && (!opts.addSelect && !e.ctrlKey) )){
                selected.removeClass(selectedClass)
                self.selected = []
            }
            self.pos = {opts}
            let active = target.toggleClass(selectedClass).hasClass(selectedClass)
            opts.beforeSelected(target, active, 'click')
            opts.done([...self.selected, target])
        })
        .on('mousedown', function({target,clientX, clientY}) {
            target = $(target)
            var par
            let opts = self.list.find(({container}) => (par = getParent(target, container)).length)
            if(!opts) return
            
            if (!target.parents('[data-file]').length) { // 可拖拽的对象取消
                // self.timer = g_pp.setTimeout('moving', () => {
                    Object.assign(self.pos, {sx: clientX, sy: clientY, top: par[0].scrollTop, selected: []})
                    self.moving = true
                // }, 10)
            }
        })
        .on('mouseup', function(e) {
            cancelTimer()
            if(!self.pos?.par) return

            let selected = []
            let {opts, par, rect} = self.pos
            let {scrollTop, scrollLeft} = par[0]
            let {top, left} = par[0].getBoundingClientRect()

            par.find(opts.selector).each((i, dom) => {
                let rect2 = copyObj(dom.getBoundingClientRect())
                dom = $(dom)
                // // 更改为相对于滚动条的高度
                rect2.top -= top 
                rect2.top += + scrollTop
                rect2.bottom -= top 
                rect2.bottom += scrollTop
                rect2.left -= left + scrollLeft
                rect2.left += scrollLeft
                rect2.right -= left + scrollLeft
                rect2.right += scrollLeft

                let b = isRectOverlap(rect2, rect)
                opts.beforeSelected(dom, b, 'selection')
                dom.toggleClass(opts.selectedClass, b)
                b && selected.push(dom)
            })
            opts.done(selected)
            self.unset()
        })
        .on('mousemove', function(e) {
            if (self.moving) {
                let {sx, sy, ex, ey} = Object.assign(self.pos, {ex: e.pageX, ey: e.pageY})
                let {div, par} = self.pos
                if(!div){
                    // 是否进入某个区域
                    let target = self.list.find(({container}) => {
                        par = getParent(e.target, container)
                        return par.length && isElementEnterArea(par[0].getBoundingClientRect(), {left: sx, top: sy, right: ex, bottom: ey})
                    })
                    if(!target) return

                    self.pos.opts = target
                    self.pos.par = par.addClass('position-relative')
                    div = self.pos.div = $(`<div class="_selection">${target.html || ''}</div>`).prependTo(par)
                }

                sy += self.pos.top // 起点绝对位置加上滚动条初始位置
                let {top, left, height} = par[0].getBoundingClientRect()
                // 减去div的偏移值
                sy -= top
                ey -= top
                sx -= left
                ex -= left
                // 加上滚动条的位置
                ey += par[0].scrollTop
                
                let rect = self.pos.rect = {
                    top: Math.min(sy, ey),
                    left: Math.min(sx, ex),
                    width: Math.abs(ex - sx),
                    height: Math.abs(ey - sy),
                }
                div.css(rect)
                rect.right = rect.left + rect.width
                rect.bottom = rect.top + rect.height

                // 自动滚动
                let _y = e.clientY;
                let offset = height * 0.1
                // console.log({_y, offset ,top})
                if (_y - offset <= top) {
                    par[0].scrollBy(0, -10)
                } else
                if (_y + offset >= height) {
                    par[0].scrollBy(0, 10)
                }
            }else
            if(self.timer){
                cancelTimer()
            }
        })
    },
    unset(clear = false, opts){
        this.moving = false
        let pos = this.pos
        opts ??= pos.opts
        pos.par && pos.par.removeClass('position-relative')
        pos.div && pos.div.remove()
        delete pos.div
        if(clear){
             this.selected.forEach(el => {
                el = $(el)
                el.removeClass(el.data('selection')).data('selection', undefined)
            })
            this.selected = []
            opts.callback && opts.callback([])
        }
        this.pos = {}
        opts.onUnset && opts.onUnset(clear)
    },
    get(name, method = 'find'){
        return this.list.find(item => item.name == name)
    },
    remove(name){
        let i = this.get(name, 'findIndex')
        if(i != -1){
            this.list.splice(i, 1)
            return true
        }
    },
    getContainer(name){
        let {container} = this.get(name)

    },
    selectAll(name){

    },
    setSelected(name, list){
       let opts = this.get(name)
       list.forEach(el => $(el).addClass(opts.selectedClass).data('selection', opts.selectedClass))
       this.selected = list
       opts.done & opts.callback(list)
    },
    clearSelected(name){
       let opts = this.get(name)
       opts.getSelected().removeClass(opts.selectedClass)
       opts.done & opts.callback([])
    },
    getElements(){
        
    },
    reverseSelected(name){

    },
    isShowing(){
        return this.moving && this?.pos?.div !== undefined
    },
    selected: [],
    register(opts){
        const self = this
        self.remove(opts.name)
        self.list.push(Object.assign({
            dbclickUnset: true, // 双击后取消中选
            beforeSelected(el, active, from){ // 选中前
                el.data('selection',  active ? this.selectedClass : undefined)
                return this.onSelected(el, active, from)
            },
            onSelected: () => {}, // 选中时
            callback: () => {},
            done(list){ // 选中后
                self.selected = list
                // this.selected = list
                this.callback(list)
            },
            onUnset: () => {},
            getSelected(){
                return $(this.container).find('.'+this.selectedClass)
            }
        }, opts))
    },
}

function getInsidePostion(pos, rect){
    let left = pos.x - rect.left
    let {width, height} = rect
    if(left > width) left = width - left
    let top = pos.y - rect.top
    if(top > height) top = height - top
    return {left, top}
}

function isElementEnterArea(rect1, rect2) {
    return !(rect1.bottom < rect2.top || rect1.top > rect2.bottom || rect1.right < rect2.left || rect1.left > rect2.right) // 有一部分在范围
}

function isRectOverlap(rect1, rect2) {
    // 判断两个RECT是否水平上有重叠
    const xOverlap = Math.max(0, Math.min(rect1.right, rect2.right) - Math.max(rect1.left, rect2.left));
    // 判断两个RECT是否垂直上有重叠
    const yOverlap = Math.max(0, Math.min(rect1.bottom, rect2.bottom) - Math.max(rect1.top, rect2.top));
    // 两个RECT有重叠部分的条件是水平垂直上均有重叠
    return xOverlap > 0 && yOverlap > 0;
  }

function isElementInViewport (el) {
    var rect = el.getBoundingClientRect();
    return (
        rect.top >= 0 &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) && 
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)
    );
}

g_selection.init()
