
var g_scrollText = {
    init() {
        const self = this
        g_style.addStyle('scrollText', `
            .scrollDiv {
                overflow: hidden;
            }

            .scrollText {
                display: inline-block;
                white-space: nowrap;
            }

            @keyframes wordsLoop {
                0% {
                    transform: translateX(-50px);
                    -webkit-transform: translateX(-50px);
                }

                100% {
                    transform: translateX(-100%);
                    -webkit-transform: translateX(-100%);
                }
            }

            @-webkit-keyframes wordsLoop {
                0% {
                    transform: translateX(-50px);
                    -webkit-transform: translateX(-50px);
                }

                100% {
                    transform: translateX(-100%);
                    -webkit-transform: translateX(-100%);
                }
            }
        
        `)


        $(document)
            .on("mouseenter", '.scrollDiv', function () {
                self.switch(this, true)
            })
            .on("mouseleave", '.scrollDiv', function () {
                self.switch(this)
            })

        $(() => self.refresh())
    },

    switch(container, paused) {
        for (let dom of $(container).find('.scrollText')) {
            if(dom.offsetWidth <= dom.parentElement.offsetWidth) return // 没有溢出
            dom = $(dom)
            let second = dom.text().length / 2;
            if(second > 10) second = 10
            dom.css({
                "animation": second + "s wordsLoop linear infinite " + (paused ? 'paused' : 'normal')
            })
        }
    },
    refresh() {
        $('.scrollDiv').each((i, dom) => this.switch(dom))
    },
}

g_scrollText.init()

