const TASK_WAITTING = 0
const TASK_RUNNING = 1
const TASK_COMPLETED = 2
const TASK_ERROR = 3

class Queue {
    timer = -1
    tasks = {}
    constructor(name, opts) {
        this.name = name
        opts = this.opts = Object.assign({
            inst: this,
            max: 10,
            interval: 1000,
            timeout: -1,
            onStatusChange: () => { }, // 任务状态变更事件
            onAdd: () => {}, // 任务添加事件
            onRemove: () => { }, // 任务移除事件
            onUpdate: () => { }, // 任务更新事件
            onCompleted: () => { }, // 任务完成事件
            onEnded: () => {}, // 队列结束后事件
            autoRunning: true, // 是否自运行 
            autoClear: false, // 任务结束后是否自动清空队列
            keepRunning: false, // 添加任务后是否自动运行
        }, opts)
        opts.autoRunning && this.setRunning(true)
        g_queue.register(name, this)
    }

    destroy(){
        this.setRunning(false)
        g_queue.unregister(this.name)
        delete this
    }

    add(id, vals = {}) {
        if(this.opts.onAdd(id, vals) === false) return
        // let old = this.get(id)
        this.tasks[id] = Object.assign({
            status: TASK_WAITTING,
            primary: 0,
        }, vals)
        // return old != undefined && old.status != TASK_WAITTING
    }

    remove(id){
        let item = this.get(id)
        if(item){
            delete this.tasks[id]
            item.onRemove && items.onRemove()
            this.opts.onRemove(id)
        }
    }

    count(){
        return this.keys().length
    }

    clear(stop = false){
        this.tasks = {}
        stop && this.setRunning(false)
    }

    get(id) {
        return this.tasks[id]
    }

    keys() {
        return Object.keys(this.tasks)
    }

    values() {
        return Object.values(this.tasks)
    }

    entries() {
        return Object.entries(this.tasks)
    }

    each(cb){
        let i = 0
        for(let id in this.tasks){
            let item = this.tasks[id]
            if(cb(id, item, i++) === false) return false
        }
    }

    setVal(id, k, v) {
        let item = this.get(id)
        if (item[k] == v) return

        item[k] = v
        if (k == 'status') {
            if(item.timeout_id){
                clearTimeout(item.timeout_id)
                delete item.timeout_id
            }
            item.onStatusChange && item.onStatusChange(v, status => this.setVal(id, k, status), id)
            this.opts.onStatusChange(id, v)
        }
    }

    callEvent() {

    }

    setStatus(id, status) {
        return this.setVal(id, 'status', status)
    }

    isRunning(){
        return this.timer > 0
    }

    setMax(max){
        this.opts.max = parseInt(max)
    }

    setRunning(running, next = false) {
        running ??= !this.isRunning()
        call(this.opts.onRunningChanged, running)

        if (!running){
            clearInterval(this.timer)
            this.timer = -1
            return
        }
        const cb = () => {
            let all = this.count()
            let list = this.getListStatus()
            let errors = list[TASK_ERROR]
            let runnings = list[TASK_RUNNING]
            let waittings = list[TASK_WAITTING]
            let completed = list[TASK_COMPLETED]

            let i_wait =  waittings.length
            let i_run =  runnings.length
            let {max, timeout, onEnded} = this.opts
            let allow =  Math.min(Math.min(max - runnings.length, max || 999), i_wait)
            if(allow > 0){
                for (let i = 0; i < allow; i++) {
                    let id = waittings.shift()
                    this.setStatus(id, TASK_RUNNING)
                    if(timeout > 0){
                        let item = this.get(id)
                        item.timeout_id = setTimeout(() => this.setStatus(id, TASK_ERROR) & console.log('任务超时:'+id), timeout)
                    }
                }
            }else
            if(this.lastAllow > 0 && !i_wait && !i_run && this.isRunning()){ // 空闲状态
                if(this.opts.autoClear) this.clear(onEnded ? onEnded.call(this) : false)
            }
            this.lastAllow = allow
            this.opts.onUpdate({ waittings, runnings, errors, allow, completed, list, all })
        }
        this.timer = setInterval(cb, this.opts.interval)
        next && cb()
    }

    getListStatus(){
         let ret = {[TASK_ERROR]: [], [TASK_COMPLETED]: [], [TASK_RUNNING]: [], [TASK_WAITTING]: []}
         this.entries().forEach(([id, item]) => ret[item.status].push(id))
         return ret
    }

    clearStatus(status){
        let cnt = 0
        let list = this.getListStatus()
        toArr(status).forEach(statu => {
            cnt++
            list[statu].forEach(id => this.remove(id))
        })
        return cnt
    }

    toStauts(i) {
        switch (i) {
            case TASK_COMPLETED:
                return '已完成'

            case TASK_ERROR:
                return '错误'

            case TASK_RUNNING:
                return '运行中'

            case TASK_WAITTING:
                return '等待中'

            default:
                return '未知'
        }
    }

    search(cb, source) {
        source ??= this.entries()
        return source.filter(([id, item]) => cb(item, id))
    }
}

var g_queue = {
    init(){
        Object.getOwnPropertyNames(Queue.prototype).forEach(method => {
            if(!['constructor'].includes(method) && !method.startsWith('_')){
                this[method] = (id, ...args) => this.method(id, method, ...args)
            }
        })
    },

    list: {},

    register(name, opts){
        this.list[name] = opts
    },

    unregister(name, opts){
        delete this.list[name]
    },

    getInst(id){
        return this.list[id]
    },

    method(id, method, ...args){
        let inst = this.getInst(id)
        if(inst){
            return inst[method].apply(inst, args)
        }
    },
}

g_queue.init()
