
if(typeof(basedata) == 'undefined'){
    basedata = require('./basedata.js')
    var {local_readJson, local_saveJson, assignInstance, guid, copyObj} = require('./until_server.js')
}
var g_plugin = new basedata({
    name: 'plugins',
    defaultList: [],
    primarykey: 'namespace',
    list: local_readJson('plugins', []),
    saveData: data => local_saveJson('plugins', data),

    require(name) {
        return nodejs.require(this.getSciptPath() + 'node_modules/' + name)
    },

    getSciptPath() {
        return nodejs.dir + "/scripts/"
    },

    pluginLoaded(name) {
        return this.getPlugins().find(script => getFileName(script, false) == name) != undefined
    },

    // 加载所有插件
    initPlugins() {
        let list = this.getPlugins()
        let cb = () => {
            console.log(`[plugins] 成功加载所有插件`);
            this.callEvent('onPluginsLoaded', {list})
        }
        return list.length ? loadRes(list, cb) : cb();
    },

    async getScriptContent(file, defV) {
        // TODO 缓存
        if (file.startsWith('http')) return (await (await fetch(file)).text()) || defV
        return nodejs.files.read(file, defV)
    },

    // 更新插件信息
    async refreshPlugins(update) {
        const readMeta = async url => await (await fetch(url)).text()
        Promise.all(this.getPlugins(true).map(file => {
            return this.getScriptContent(file).then(async content => {
                try {
                    let { meta } = this.parseScript(content)
                    if (meta) {
                        if (!isEmpty(meta.updateURL) && update) {
                            let obj1 = this.parseScript(await readMeta(meta.updateURL))
                            if (obj1.meta.version > meta.version && obj1.meta.namespace == meta.namespace) {
                                if (obj1.meta.directURL) obj1.code = await readMeta(obj1.meta.directURL)

                                delete obj1.meta.directURL
                                nodejs.files.write(file, this.formatScript(obj1))
                                toast(`插件【${meta.name}】 ${meta.version} 成功更新至 ${obj1.meta.version}`, 'success')
                                Object.assign(meta, obj1.meta)
                            }
                        }
                        this.merge(meta.namespace, meta)
                    }
                } catch (err) { toast(err.toString(), 'danger') }
            })
        })).then(() => alert('检测更新完成!'))
    },

    // 获取所有插件
    getPlugins(all = false) {
        return this.values().filter(plugin => all || plugin.enable)
        .sort((a, b) => {
            let a1 = a.primary ? parseInt(a.primary) : 0
            let b1 = b.primary ? parseInt(b.primary) : 0
            return b1 - a1
        }).map(plugin =>  this.getSciptFile(plugin))
    },

    init(opts = {}) {
        if(typeof(window) == 'undefined') return
        const _key = (hide = true) => {
            let key = g_dropdown.getValue('plugin_dropdown')
            hide && g_dropdown.hide('plugin_dropdown');
            return key
        }

        g_dropdown.register('plugin_dropdown', {
            position: 'top-end',
            dataKey: dom => getParentData(dom, 'key'),
            list(dataKey){
                return {
                    edit: {
                        icon: 'pencil',
                        title: '编辑',
                        action: 'plugin_item_edit'
                    },
                    group: {
                        icon: 'inbox',
                        title: '分组',
                        action: 'plugin_item_group'
                    },
                    // update: {
                    //     icon: 'arrow-big-up',
                    //     title: '检查更新',
                    //     action: 'plugin_item_update'
                    // },
                    ...(g_action.list['plugin_'+dataKey] ? {
                        setting: {
                            icon: 'settings',
                            title: '插件设置',
                            action: 'plugin_ui,'+dataKey
                        }
                    } : {}),
                    delete: {
                        icon: 'trash',
                        title: '删除',
                        class: 'text-danger',
                        action: 'plugin_item_delete'
                    },
                }
            }
        })

        g_dropdown.register('plugin_group', {
            position: 'end-top',
            parent: ['plugin_dropdown', 'group'],
            list: () => {
                let list = {}
                let key = _key(false)
                let current = this.get(key).group
                console.log({key, current})
                this.values().forEach(({group}) => {
                    console.log(group)
                    if(!isEmpty(group) && !list[group]) list[group] = {
                        title: group,
                        class: current == group ? 'active' : '',
                        action: 'plugin_group_setGroup,'+group,
                    }
                })
                console.log(list)
                return Object.assign({
                    new: {
                        title: '新建组',
                        action: 'plugin_group_new',
                    },
                    drive: {type: 'divider'}
                }, list, !isEmpty(current) ? {
                    drive: {type: 'divider'},
                    empty: {
                        title: '取消分组',
                        action: 'plugin_group_empty',
                    },
                } : {})
            },
        })

        g_action.registerAction({
            modal_plugin: () => this.modal_show(),
            plugin_item_edit: () => this.prompt_add(_key()),
            plugin_item_delete: () => this.prompt_delete(_key()),
            plugin_item_update: () => this.prompt_delete(_key()),
            plugin_enable: dom => this.setVal(getParentAttr(dom, 'data-key'), 'enable', dom.checked, false),
            plugin_ui: (dom, action) => g_dropdown.hide('plugin_dropdown') & doAction('plugin_'+action[1], dom),

            plugin_group_active: dom => {
                let div = $(dom).parents('[data-group]')
                div.getEle({change: 'plugin_enable'}).prop('checked', dom.checked).trigger('change');
            }
        })

        let actions = ['plugin_group_setGroup', 'plugin_group_new', 'plugin_group_empty']
        g_action.registerAction(actions, (dom, action) => {
            let key = _key()
            g_dropdown.hide('plugin_group');
            const setGroupName = name => this.merge(key, {group: name}) & this.refresh()
            switch(actions.indexOf(action[0])){
                case 0:
                    return setGroupName(action[1])
                case 1:
                    return prompt('', {title: '输入插件组'}).then(name => {
                        if(!isEmpty(name)) setGroupName(name)
                    })
                case 2:
                    return setGroupName()
            }
        })
        assignInstance(this, opts)

        typeof(g_launch) != 'undefined' && g_launch.registerLaunchParam('plugin_import', async data => {
            if(data.url){
                showMessage('下载插件中...', data.url)
                downloadFile({url: data.url, proxy: await nodejs.files.getProxy(), complete: content => ipc_send('show') & this.prompt_add({content}), error: err => toast('下载插件失败!', 'danger')})
            }
        })
    },


    prompt_delete(key) {
        confirm('是否移除插件 【' + this.getVal(key, 'name') + '】 ? 只会从列表移除，不会删除本地文件!', { title: '删除插件', type: 'danger' }).then(() => {
            this.remove(key);
            $('#modal_plugins_edit').modal('hide');
            toast('删除成功', 'success');
        })
    },

    async prompt_add(d = {}) {
        g_modal.remove('plugins_edit')
        
        if (typeof(d) == 'string') d = copyObj(this.get(d))
        let key = this.getIndex(d)
        let isNew = key == undefined
        let gid = guid()
        if (isEmpty(d.content)) d.content = isNew ? `// ==UserScript==
// @name        示例插件
// @namespace   ${gid}
// @version     0.0.1
// @author      作者名称
// @description 注释说明
// @updateURL               
// @primary     1
// ==/UserScript==` : await this.getScriptContent(this.getSciptFile(d))

        g_form.confirm('plugins_edit', {
            elements: {
                file: {
                    title: '文件位置',
                    value: d.file || '',
                    type: 'file_chooser',
                },
                content: {
                    title: '代码',
                    type: 'textarea',
                    rows: 10,
                    value: d.content,
                    placeHolder: '输入代码...',
                },
                enable: {
                    title: '启用',
                    value: d.enable || false,
                    type: 'switch',
                }
            },
        }, {
            id: 'plugins_edit',
            title: '编辑插件',
            btn_ok: '保存',
            once: true,
            btn_cancel: isNew ? '取消' : '删除',
            onBtnClick: (btn, modal) => {
                if (btn.id == 'btn_ok') {
                    return this.saveScript(Object.assign(g_form.getVals('plugins_edit'), { isNew })) & toast('刷新后生效')
                }
                if (btn.id == 'btn_cancel') {
                    if (!isNew) {
                        this.prompt_delete(key);
                        return false;
                    }
                }
            }
        })
    },

    getSciptFile(d, name) {
        let path = this.getSciptPath()
        if (isEmpty(d.file)) return path + (d.name || name) + '.js'
        return d.file.replace('./', path)
    },

    async saveScript(d) {
        let { meta, code } = this.parseScript(d.content)
        d.file = this.getSciptFile(d, meta.name)

        if (!meta.namespace) {
            // 增加namespace
            meta.namespace = guid()
            d.content = this.formatScript({ meta, code })
            if (d.import && await prompt(d.content, { title: '修改确定', rows: 20 })) {
                nodejs.files.write(d.file, d.content)
            }
        }
        if (!d.import) {
            if (nodejs.files.exists(d.file) && d.isNew) {
                toast('文件名:' + d.file + '已经存在', 'danger')
                return false
            }
            nodejs.files.write(d.file, d.content)
        }

        d.file = d.file.replace(this.getSciptPath(), './')
        delete d.content;
        delete d.isNew;
        this.set(meta.namespace, Object.assign(meta, d))
    },

    refresh() {
        let div = $('#plugins_list')
        if (!div.length) return

        let list = [];
        this.keysEntries((k, v) => {
            let id = 'check_plugin_' + k;
            let {name, description, author, enable, version, group} = v
            author ??= '热心网友'
            group ??= 'default'
            description ??= '暂无注释'
            let icon = (v.icon ?? '').split(':')
            if(!list[group]) list[group] = {html: '', enabled: []}
            enable && list[group].enabled.push(k)
            list[group].html += `
                <div class="col-6 col-lg-4 mb-2" data-key="${k}">
                    <div class="card">
                        ${!isEmpty(icon[0]) ? `
                        <div class="card-stamp">
                            <div class="card-stamp-icon bg-${icon[1] ?? 'yellow'}">
                                <i class="ti ti-${icon[0]}"></i>
                            </div>
                        </div>` : ''}
                        <div class="card-body row">
                            <h3 class="card-title d-flex">
                                <label class="form-check form-switch me-2">
                                    <input class="form-check-input" type="checkbox" data-change="plugin_enable" id="${id}" ${enable ? 'checked' : ''}>
                                </label>
                                ${name}</h3>
                            <div class="text-muted">${description}</div>
                            <div class="row mt-3 align-items-center">
                                <div class="col d-flex align-items-center">
                                    <div class="avatar-list avatar-list-stacked me-3">
                                        <span class="avatar avatar-xs rounded" title="${author}">${author.substring(0, 1)}</span>
                                    </div>
                                    <span>${author}</span>
                                </div>
                                <div class="col-auto text-muted">
                                    <i class="ti ti-tag me-2"></i>
                                    <span>${version}</span>
                                </div>
                                <div class="col-auto text-muted" data-target-dropdown="plugin_dropdown">
                                    <i class="ti ti-dots"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        })
        div.html(Object.entries(list).map(([group, data]) => {
            return `
            <div class="card" data-group="${group}">
                <div class="card-header">
                    <h3 class="card-title">${group}</h3>
                    <div class="card-actions">
                        <label class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" data-change="plugin_group_active" ${data.enabled.length ? 'checked' : ''}>
                        </label>
                    </div>
                </div>
                <div class="card-body row row-deck p-0">${data.html}</div>
            </div>
            `
        }).join(''));
    },
    // 插件列表
    modal_show() {
        let before = this.getPlugins()
        this.modal = g_modal.modal_build({
            html: `<div id="plugins_list"></div>`,
            id: 'plugins',
            title: '插件列表',
            width: '80%',
            once: true,
            scrollable: true,
            buttons: [{
                    id: 'add',
                    text: '新增',
                    class: 'btn-warning',
                }, {
                    id: 'reset',
                    text: '重置',
                    class: 'btn-secondary',
                },
                {
                    id: 'refresh',
                    text: '刷新',
                    class: 'btn-primary',
                },
                {
                    id: 'open',
                    text: '导入',
                    class: 'btn-success',
                }, {
                    id: 'more',
                    text: '获取更多',
                    class: 'btn-info',
                }
            ],
            onClose: () => {
                if (!arr_equal(before, this.getPlugins())) {
                    confirm('插件需要重载才能生效,是否重载页面?', { title: '重载页面', }).then(() => location.reload())
                }
            },
            onBtnClick: (btn, modal) => {
                switch (btn.id) {
                    case 'btn_more':
                        return ipc_send('url', this.homepage);
                    case 'btn_add':
                        return this.prompt_add();
                    case 'btn_reset':
                        return confirm('确定要重置吗?').then(() => this.reset())
                    case 'btn_refresh':
                        const update = b => this.refreshPlugins(b)
                        return confirm('是否同时更新插件?').then(() => update(true), () => update(false))
                    case 'btn_open':
                        return openFileDiaglog({
                            title: '打开脚本文件',
                            properties: ['openFile'],
                            defaultPath: this.getSciptPath(),
                            filters: [{ name: 'js文件', extensions: ['js'] }, ],
                        }, path => {
                            !isEmpty(path[0]) && this.script_import(path[0])
                        })
                }
            }
        });
        this.refresh();
    },

    script_import(file) {
        return this.saveScript(Object.assign({ file, enable: false, content: nodejs.files.read(file), import: true }))
    },

})

assignInstance(g_plugin, {
    events: {},
    initEvent(eventName, callback, overwrite = false) {
        let event = this.getEvent(eventName, true);
        event.finish = callback;
        // 绑定最后执行函数
    },

    // 注册事件
    registerEvent(eventName, callback, primary = 1, id = guid()) {
        let event = this.getEvent(eventName);
        if (event) {
            event.listeners[id] = {
                id,
                callback,
                primary
            }
        }
        return id
    },

    // 取消注册事件
    unregisterEvent(id) {
        for (let eventName in this.events) {
            let obj = this.events[eventName]
            if (obj.listeners[id]) {
                delete obj.listeners[id]
            }
        }
    },

    // 获取事件
    getEvent(eventName, create = true) {
        if (create && !this.events[eventName]) {
            this.events[eventName] = {
                listeners: {},
            }
        }
        return this.events[eventName];
    },

    // 执行事件
    callEvent(eventName, data) {
        return new Promise(async (reslove) => {
            let event = g_plugin.getEvent(eventName);
            if (event) {
                // for (let k in data) {
                //     if (typeof(data[k]) == 'function') {
                //         // 执行函数取值
                //         data[k] = data[k].apply(data)
                //     }
                // }
                for (let [id, listener] of Object.entries(event.listeners).sort((a, b) => {
                        return parseInt(b[1].primary) - parseInt(a[1].primary);
                    })) {
                    if (await listener.callback(data) === false) {

                    }
                }
                event.finish && event.finish(data);
                reslove(data)
            }
        })
    },

})

assignInstance(g_plugin, {
    // 格式化脚本
    formatScript(obj) {
        let s = ''
        for (let [k, v] of Object.entries(obj.meta)) s += `// @` + k + '    ' + v + "\n"
        return `// ==UserScript==\n${s}\n// ==/UserScript==\n${obj.code}`
    },

    // 解析脚本
    parseScript(script) {
        let code = ''
        let meta = {}
        let status
        script.split('\n').forEach(text => {
            let args = text.trim().replaceAll('  ', ' ').split(' ').filter(arg => arg != '')
            if (status != 'end' && args[0] == '//') {
                if (args[1] == '==UserScript==') {
                    status = 'start'
                } else
                if (args[1] == '==/UserScript==') {
                    status = 'end'
                } else {
                    if (args[1][0] == '@') {
                        meta[args[1].substr(1, args[1].length - 1)] = arr_join_range(args, ' ', 2)
                    }
                }
            } else
            if (status == 'end') {
                code += text + "\n"
            }
        })
        return { meta, code }
    },

})

function _callEvent(k, v){
    g_plugin.callEvent(k, v)
}

if(typeof(window) == 'undefined') module.exports = g_plugin