
/*
	简单的回应模型
*/

var g_pp = {
	init: function(){

	},
	list: {},
	set: function(key, cb, opts){
		opts = Object.assign({
			once: false
		}, opts)
		this.list[key] = {cb, opts};
	},
	get: function(key){
		return this.list[key];
	},
	call: function(key, ...args){
		var d = this.get(key);
		if(!d) return;
		d.cb.apply(null, args);
		if(d.opts.once) this.del(key);
	},
	del: function(key){
		if(this.list[key]) delete list[key];
	},
	clear: function(){
		this.list = {};
	},

	timer: {},
	setTimeout(name, cb, ms = 3000, apply){
		this.clearTimeout(name, apply)
		let callback = () => {
			cb() && this.clearTimeout(name)
		}
		let timer = this.timer[name] = {
			timer: setTimeout(callback, ms),
			callback
		}
		return timer
	},

	clearTimeout(name, apply = false){
		let {timer, callback} = this.timer[name] || {}
		if(timer){
			delete this.timer[name]
			clearTimeout(timer)
			apply && callback()
		}
	},

	setInterval(name, callback, ms = 3000, apply = false){
		this.clearInterval(name)
		let fun = () => {
			if(callback() === false){
				this.clearInterval(name)
			}
		}
		this.timer[name] = setInterval(fun, ms)
		apply && fun()
	},

	clearInterval(name){
		let i = this.timer[name]
		if(i){
			clearInterval(i)
			delete this.timer[name]
		}
	},

	timerAlive(name){
		return this.timer[name] != undefined
	}
}

// g_pp.set('ping', (a, b) => {
// 	console.log(a, b)
// });
// g_pp.call('ping', 1, 2);



            