var g_modal = {
    styles: {
        default: {
            html: `
            <div class="modal" tabindex="-1">
              <div class="modal-dialog" role="document">
                <div class="modal-content">
                  <div class="modal-header">
                    <h5 class="modal-title">{title}</h5>
                    {header}
                  </div>
                  <div class="modal-body overflow-x-hidden">
                    {html}
                  </div>
                  <div class="modal-footer">
                    {footer}
                  </div>
                </div>
              </div>
            </div>
        `
        },

        danger: {
            html: `
            <div class="modal" tabindex="-1">
              <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                  {header}
                  <div class="modal-status bg-danger"></div>
                  <div class="modal-body overflow-x-hidden">
                    <h3>{title}</h3>
                    <div class="text-muted">{html}</div>
                  </div>
                  <div class="modal-footer">
                    {footer}
                    </div>
                  </div>
                </div>
              </div>
            </div>
        `
        },

        success: {
            html: `
            <div class="modal" tabindex="-1">
              <div class="modal-dialog modal-sm" role="document">
                <div class="modal-content">
                  {header}
                  <div class="modal-status bg-success"></div>
                  <div class="modal-body overflow-x-hidden">
                    <h3>{title}</h3>
                    <div class="text-muted">{html}</div>
                  </div>
                  <div class="modal-footer">
                    {footer}
                  </div>
                </div>
              </div>
            </div>
        `,
        },

        fullscreen: {
            html: `
            <div class="modal" tabindex="-1">
              <div class="modal-dialog modal-fullscreen" role="document">
                <div class="modal-content">
                  {header}
                  <div class="modal-body overflow-x-hidden">
                    {html}
                  </div>
                  <div class="modal-footer">
                   {footer}
                  </div>
                </div>
              </div>
            </div>
        `,
        },

    },

    init() {
        let self = this
        g_style.addStyle('modal', `
            html.modaled {
                overflow-y: hidden !important;
            }

            @media (max-width: 576px) {
                .modal-dialog {
                    width: 100% !important;
                }
            }
        `)

        g_action.registerAction({
            modal_close: (dom, action, ev) => {
                let id = getParentData(dom, 'modal')
                let modal = g_modal.getModal(id)
                try {
                    modal.method('close', ev)
                } catch(err){
                    g_modal.hide(id)
                }
            }
        })

        window.dialog = (html, opts = {}) => this.modal_build({html, ...opts})
        window.alert = (text, opts = {}) => {
            return new Promise((reslove, reject) => {
                let modal = self.modal_build(Object.assign({
                    title: '提示',
                    html: text,
                    type: 'default',
                    footer: '{btn}',
                    hotkey: true,
                    onClose: e => reject(),
                    buttons: [{
                        text: opts.btn_ok || '确定',
                        class: 'btn-primary',
                        default: true,
                        id: 'ok',
                        onClick: e => reslove(modal)
                    }]
                }, opts))

            });
        }

        window.confirm = (text, opts = {}) => {
            return new Promise(reslove => {
                let modal = self.modal_build(Object.assign({
                    title: '询问',
                    html: text || '确定吗?',
                    type: 'default',
                    footer: '{btn}',
                    hotkey: true,
                    onClose: e => reslove(),
                    buttons: [{
                        text: opts.btn_ok || '确定',
                        class: 'btn-primary',
                        id: 'ok',
                        default: true,
                        onClick: e => reslove(true)
                    }, {
                        text: opts.btn_cancel || '取消',
                        class: 'btn-danger',
                        id: 'cancel',
                        onClick: e => reslove(false)
                    }]
                }, opts))
            });
        }

        window.prompt = (text, opts = {}) => {
            return new Promise((reslove, reject) => {
                
                let modal = self.modal_build(Object.assign({
                    title: '请输入',
                    html: `
                        <textarea class="form-control" data-bs-toggle="autosize" rows="${opts.rows || 3}" placeholder="${opts.placeHolder || '...'}">${text}</textarea>
                    `,
                    type: 'default',
                    footer: '{btn}',
                    hotkey: true,
                    onClose: e => reject(),
                    // todo check empty val
                    buttons: [{
                        text: opts.btn_ok || '确定',
                        default: true,
                        id: 'ok',
                        class: 'btn-primary',
                        onClick: e => reslove(modal.find('textarea').val())
                    }, {
                        text: opts.btn_cancel || '取消',
                        class: 'btn-danger',
                        id: 'cancel',
                        onClick: e => reject()
                    }]
                }, opts))
            });
        }

        window.dialog = (...args) => this.modal_build.apply(this, args)

    },

    style_get(type) {
        if (!this.styles[type]) type = 'default'
        return this.styles[type]
    },

    modal_get(modal) {
        return getEle({ modal })
    },

    modals: {},
    modal_build(opts) {
        opts = Object.assign({
            title: '对话框',
            type: 'default',
            footer: '{btn}',
            header: '{closeBtn}',
            bodyClass: '',
            once: false,
            overwrite: true,
            id: new Date().getTime(),
            buttons: [],
            static: true,
            style: {},
            width: '',
            show: true,
            hotkey: true,
            btn_close: true, // 点击按钮后是否自动关闭modal
            onBtnClick: btn => { },
            onShow(e) { },
            onHide(e) { },
            onClose(e) { },
            getModal() {
                return this.modal_get(this.id)
            }
        }, opts || {})

        let id = opts.id
        let modal = getEle({ modal: id })
        if (modal.length && !opts.overwrite) return modal.show()

        if (Array.isArray(opts.extraButtons)) {
            opts.buttons.unshift(...opts.extraButtons)
        }
        let style = Object.assign({}, this.style_get(opts.type))

        // 底部footer
        let btns = '';
        opts.buttons.forEach(btn => btns += `<button type="button" ${btn.id ? `id="btn_${btn.id}"` : ''} ${btn.action ? `data-action="${btn.action}"` : ''} class="modal_btn btn mx-auto ${btn.class}" ${btn.attr || ''}>${btn.text}</button>`)
        opts.footer = opts.footer.replace('{btn}', btns)

        let html = style.html
            .replace('{title}', opts.title)
            .replace('{header}', opts.header.replace('{closeBtn}', '<button type="button" class="btn-close" data-action="modal_close"></button>'))
            .replace('{html}', opts.html)
            .replace('{footer}', opts.footer)

        modal.remove();
        modal = $(html).attr('data-modal', id).css({ backgroundColor: 'rgba(0, 0, 0, .4)' }).appendTo('body')
        
        modal.find('[data-bs-toggle="autosize"]').each((i, el) => window.autosize(el))
        let body = modal.find('.modal-body').addClass(opts.bodyClass)
        let content = modal.find('.modal-content').addClass('bg-theme-primary')
        let header = modal.find('.modal-header').addClass('bg-theme-secondary')
        let footer = modal.find('.modal-footer').toggleClass('hide', opts.footer == '').addClass('bg-theme-primary')
        if(opts.delayFooter){
            footer.addClass('hide') & setTimeout(() => footer.removeClass('hide'), opts.delayFooter)
        }
        
        let dialog = modal.find('.modal-dialog')
        opts.width && dialog.css({
            width: opts.width,
            maxWidth: 'unset'
        })
        opts.height && content.css({
            height: opts.height,
        })
        dialog.css(opts.style)
        opts.scrollable && dialog.addClass('modal-dialog-scrollable')

        // 绑定按钮事件
        let def_btn
        modal.find('.modal_btn').each((i, btn) => {
            btn.addEventListener('click', function (ev) {
                if (opts.onBtnClick(btn, modal) === false) return
                let btn_opts = opts.buttons[i]
                if (btn_opts.onClick) {
                    // onclick 是个reslove 或者 reject 函数时，无法获取callback 的返回值
                    if (btn_opts.onClick.call(ev, btn) === false) return
                }
                if (opts.btn_close && (['btn_ok', 'btn_cancel'].includes(btn.id) || btn_opts.close)) {
                    modal.method('close', ev)
                }
                if (btn_opts.default) {
                    def_btn = btn // 默认按钮
                }
            })
        })

        // 热键
        if (opts.hotkey) {
            // TODO 全局热键
            modal.on('keyup', function (e) {
                // if ($('input:focus,textarea:focus').length == 0) {
                let key = e.originalEvent.key
                // if (key == 'Enter') { // 有冲突
                //     def_btn && def_btn.click()
                // } else
                if (key == 'Escape') modal.method('hide', e)
                // }
            })
        }

        // 点击事件
        if (!opts.static) {
            modal.on('click', function (e) {
                if (!inArea(e, modal.find('.modal-content'))) {
                    modal.method('hide', e)
                }
            })
        }

        modal.method = function (method, params) {
            switch (method) {
                case 'toggle':
                    let showing = modal.css('display') != 'none'
                    return modal.method(showing ? 'hide' : 'show')
                case 'show':
                    if (toVal(opts.onShow, modal, params) === false) return
                    _callEvent('modal_show', { modal, params })
                    $('html').addClass('modaled')
                    
                    return modal.show()
                case 'hide':
                    if (opts.once) return modal.method('close')

                    if (toVal(opts.onHide, modal, params) === false) return
                    _callEvent('modal_hide', { modal, params })
                    $('html').removeClass('modaled')
                    return modal.hide()
                case 'close':
                    if (!opts.once) return modal.method('hide')

                    if (toVal(opts.onClose, modal, params) === false) return
                    _callEvent('modal_close', { modal, params })
                    return modal.remove()
            }
        }
        modal
        .find('[data-bs-dismiss="modal"]').on('click', function (e) {
            modal.method(opts.once ? 'close' : 'hide', e)
        })
       
        opts.show && modal.method('show')
        this.modals[opts.id] = modal
        return modal;
    },

    hide(id) {
        this.getModal(id)?.method('hide')
    },
    show(id){
        this.getModal(id)?.method('show')
    },
    remove(id) {
        this.getModal(id)?.method('close')
        delete this.modals[id]
    },
    toggle(id) {
        this.getModal(id)?.method('toggle')
    },
    exists(id) {
        return this.modal_get(id).length > 0
    },
    getModal(id) {
        return this.modals[id]
    },
    isShowing(id) {
        let modal = this.modal_get(id)
        return modal.length > 0 && modal.css('display') != 'none'
    }
}

g_modal.init()


const inArea = (event, target) => {
    var point = { x: event.pageX, y: event.pageY }

    var area = $(target).offset();
    area = {
        l: area.left,
        t: area.top,
        w: $(target).width(),
        h: $(target).height(),
    }

    return point.x > area.l && point.x < area.l + area.w && point.y > area.t && point.y < area.t + area.h;
}