var g_lazyload = {
    init() {
        const self = this
        this.initObserver()
        $.fn.lazyload = function (cb) {
            let list = this.hasClass('lazyload') ? this : this.find('.lazyload')
            list.each((i, el) => self.observer.observe(el))
        };
    },
    addFromContainer(div) {
        div.querySelectorAll('img.lazyload').forEach(el => this.observer.observe(el))
    },
    initObserver() {
        this.observer = new IntersectionObserver(entries => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    let el = entry.target;
                    let {src, lazyload} = el.dataset
                    if(!isEmpty(src)){
                        let img = new Image()
                        // el.classList.add('fade-in')
                        img.onload = function(ev){
                            if(!isEmpty(lazyload)) doAction(lazyload, el, ev)

                            el.classList.remove('lazyload')
                            delete el.dataset.src
                            if(src.startsWith('http')){ // TODO 其他判断选项
                                getImgBase64(this, 200).then(url => el.src = url) // 压缩图片选项
                            }else{
                                el.src = src
                            }
                        }
                        img.src = src;
                    }
                    this.observer.unobserve(el);
                }
            });
        });
    },
}
g_lazyload.init()
