var g_hotkey = new basedata({
    name: 'hotkeys',
    defaultList: [],
    primarykey: 'id',
    list(){
        let list = local_readJson('hotkeys', [])
        return list.length ? list : this.getDefaultList()
    },
    saveData: data => local_saveJson('hotkeys', data),
    getDefaultList(){
        let list = []
        this.defaultList.forEach(item => {
            // 可能有多个快捷键同一个属性（刷新）
            toArr(item.hotkey).forEach(hotkey => {
                list.push({id:guid(), ...item, hotkey})
            })
        })
        return list
    },
    event: {
        set: () => g_hotkey.initHotkeys(),
        remove: () => g_hotkey.initHotkeys(),
        reset: () => g_hotkey.initHotkeys(),
    },
    init() {
        this.initEvent();
        this.initHotkeys();
        $(() => {
            g_input.bind('hotkey_disabled', function({selected}){
                let key = getParentData(this, 'key')
                !isEmpty && g_hotkey.merge(key, {disabled: !selected})
            })

            g_action.registerAction({
                modal_hotkey: () => this.modal_show(),
                hotkey_edit: dom => this.prompt_add(getParentData(dom, 'key')),
            })
        })
    },
    hotkeys_temp: [], // 来自插件临时注册
    register(name, opts) {
        if(typeof(name) != 'object') name = {[name]: opts}
        Object.entries(name).forEach(([key, opts]) => {
            let insert = {...opts, hotkey: key}
            if(!this.hotkeys.find(item => isObjEqual(item, insert))){
                this.hotkeys_temp.push(insert)
            }
        })
        return this
    },
    register1(data){
        g_hotkey.register(keysData({
            data,
            keys: ['title', 'content', 'type']
        }))
    },
    prompt_delete(key) {
        confirm('确定删除快捷键?', {type: 'danger'}).then(() => {
            this.remove(key) & g_modal.hide('hotkey_edit')
            toast('删除成功', 'success');
        })
    },
    prompt_add(key) {
        let create = isEmpty(key)
        let d = create ? {content: '',title: '',type: 1} : this.get(key) 
        g_form.confirm1({
            id: 'hotkey_edit',
            title: (create ? '新增' : '编辑')+'动作',
            elements: {
                id: {value: key, class: 'hide'},
                title: {
                    title: '标题',
                    value: d.title,
                },
                hotkey: {
                    title: '热键',
                    value: d.hotkey,
                    placeHolder: "在这里按下要设置的快捷键",
                    required: true,
                    props: 'onkeydown="this.value=getInputCode(event);clearEventBubble(event) " readonly',
                },
                content: {
                    title: '代码',
                    type: 'textarea',
                    required: true,
                    placeHolder: "在这里按下要执行的代码",
                    value: d.content,
                },
                type: {
                    title: '作用范围',
                    type: 'select',
                    list: {1: '普通', 2: '无视输入框', 3: '全局'},
                    value: d.type,
                },
            },
            callback: ({vals}) => {
                if(!create){
                    this.remove(key)
                }else{
                    vals.id = guid()
                }
                this.merge(undefined, vals) & toast('保存成功', 'success')
            }
        }, {
            buttons: [{
                id: 'ok',
                text: '保存',
                class: 'btn-primary',
            }, {
                text: '测试',
                class: 'btn-warning',
                onClick: () => {
                    let content = g_form.getInputVal('hotkey_edit', 'content')
                    try {
                        eval(content);
                    } catch (e) {
                        alert(e.toString(), {type: 'danger'});
                    }
                    return false;
                }
            }, {
                text: '删除',
                class: 'btn-danger '+(create ? 'hide' : ''),
                onClick: () => this.prompt_delete(key) & false,
            }],
        })
    },
    getHotkeys(){
        return [...this.list, ...this.hotkeys_temp]
    },
    initHotkeys() { // 正确排序按键
        let hotkeys = []
        const getPrimary = s => {
            if (s == 'ctrl') return 4;
            if (s == 'alt') return 3;
            if (s == 'shift') return 2;
            return 1;
        }
        this.values().forEach(item => {
            toArr(item.hotkey).forEach(key => hotkeys.push({
                ...item,
                key: key.split('+').sort((a, b) => getPrimary(b) - getPrimary(a)).join('+').toLowerCase(),
            }))
        })
        this.hotkeys = [...hotkeys, ...this.hotkeys_temp];
    },
    refresh() {
        let tbody
        if(typeof(g_modal) != 'undefined' && (tbody = g_modal.modal_get('hotkey').find('tbody')).length){
            let html = this.getHotkeys().map(({id, title, hotkey, content, type, disabled}) =>  `
                <tr data-key="${id}" data-dbclick="hotkey_edit">
                    <td><input type="checkbox" name="hotkey_disabled" class="form-check" ${isEmpty(id) ? 'disabled' : ''} ${disabled !== true ? 'checked' : ''}></td>
                    <td>${title}<i class="ti ti-edit ms-2" data-action="hotkey_edit"></i></td>
                    <td>${toArr(hotkey).join(' | ')}</td>
                    <td>${({1: '普通', 2: '无视输入框', 3: '全局'})[type]}</td>
                    <td>${content}</td>
                </tr>
            `).join('') // TODO 插件注册的热键支持临时或记忆关闭
            tbody.html(html)
        }
    },
    modal_show() {
        dialog({
            html: `
                <table class="table">
                    <thead>
                        <tr>
                            <th scope="col">开启</th>
                            <th scope="col">说明</th>
                            <th scope="col">按键</th>
                            <th scope="col">类型</th>
                            <th class="w-1">动作</th>
                        </tr>
                    </thead>
                    <tbody></tbody>
                </table>
            `,
            id: 'hotkey',
            title: '快捷键列表',
            width: '80%',
            scrollable: true,
            btn_close: false,
            buttons: [{
                text: '新增',
                class: 'btn-warning',
                onClick: () => this.prompt_add()
            }, {
                text: '重置',
                class: 'btn-secondary',
                onClick: () =>  confirm('确定要重置吗?').then(() =>this.reset() & setTimeout(() => location.reload(), 1000))
            }],
            onShow: () => this.refresh()
        });
    },
    keydown: {},
    initEvent() {
        window.addEventListener('keydown', e => {
            g_hotkey.keydown = e
            let key = getInputCode(e, 'key')
            // console.log(key);
            // if ([16, 17, 18, 91, 9, 27, 13, 8, 20, 93].includes(e.keyCode)) { // 忽略功能按键
            //     return;
            // }
            let editing = isInputFocus();
            [key, getInputCode(e, 'code')].some(keyName => {
                let found = this.getHotkeys().filter(({hotkey, type}) => hotkey == keyName && !(editing && type == 1))
                let len = found.length
                if (!len || (typeof(g_modal) != 'undefined' && g_modal.isShowing('hotkey_edit'))) return
                
                g_pp.setTimeout('hotkey_active_'+keyName, () => { // 避免按住时重复触发
                    let cb = i => {
                        let {content} = found[i]
                        if(eval(content) !== false){
                            clearEventBubble(e);
                        }
                    }
                    if(len == 1) return cb(0)

                    let list = {}
                    let name = 'hotkey_select_one'
                    found.forEach(({title}, i) => list[i] = title)
                    // 一个按键绑定了多个动作，弹窗让用户选择执行哪个
                    alert(g_tabler.build_radio_list({name, list}), {
                        title: '选择你要执行的动作',scrollable: true}
                    ).then(() => cb($('[name="'+name+'"]:checked').val()))
                }, 20)
                return true;
            })
        })
        window.addEventListener('keyup', () => setTimeout(() => delete this.keydown, 200))
    },
  
    // 是否按键状态
    is(keys){
        // todo 完全匹配模式
        return this.keydown && toArr(keys).every(k => this.keydown[k] == true)
    }
})


const getInputCode = (e, type = 'key') => {
    let a = [];
    if (e.metaKey) a.push('meta');
    if (e.ctrlKey) a.push('ctrl');
    if (e.altKey) a.push('alt');
    if (e.shiftKey) a.push('shift');
    e[type] && a.push(e[type].toLowerCase());
    return a.join('+');
}