
class _Form {
    constructor(opts) {
        opts = this.opts = Object.assign({
            elements: {},
            class: '',
        }, opts)
        opts.name ??= 'form_' + guid()
        g_form.list[opts.name] = this
        this.update()
    }

    // 获取html结构
    getHTML() {
        let html = ''
        let elements = this.opts.elements
        Object.keys(elements).
            sort((a, b) => (elements[b].primary || 0) - (elements[a].primary || 0)).
            forEach(child => html += this.buildElement(child, elements[child]))
        return html
    }

    rebuildElement(name, item) {
        item ??= this.opts.elements[name]
        this.getElement(name).replaceWith(this.buildElement(name, item))
    }

    // 获取element结构
    buildElement(name, item) {
        return `
        <div data-formInput="${name}" class="form_element ${joinClass(this.opts.element_class, item.class)}">
            ${item.html || `<div class="${joinClass('mt-3 mb-3', this.opts.element_bodyClass, item.bodyClass)}">${g_form.getPreset(item.type, item)}</div>`}
        </div>`
    }

    // 获取外div
    getContainer(insert = true) {
        let { name, target, class: classes, autoFocus } = this.opts
        return insertEl(
            { tag: 'fieldset', text: () => this.getHTML(), props: { id: name, class: 'form-fieldset row ' + classes } },
            {
                target, method: 'appendTo', insert, onInit: () => {
                    !isEmpty(autoFocus) && g_pp.setTimeout('form_input_focus', () => this.getInput(autoFocus).focus(), 200)
                    this.callEvent('append')
                }
            }
        )
    }

    // 触发事件
    callEvent(eventName, ...args) {
        let fun = this.opts[eventName]
        if(fun){
           return fun.apply(this, args)
        }
        // console.log(eventName, args)
    }

    // 展示
    show() {
        this.toggle(true)
    }

    // 隐藏
    hide() {
        this.toggle(false)
    }

    // 切换隐藏
    toggle(show) {
        show ??= this.isShowing()
        this.getContainer().toggleClass('hide', !show)
        this.callEvent('show', !show)
    }

    // 是否显示
    isShowing() {
        let container = this.getContainer(false)
        return container && !container.hasClass('hide')
    }

    // 刷新结构
    refresh() {
        this.getContainer().replaceWith(this.getHTML())
        this.callEvent('refresh')
    }

    // 删除
    remove() {
        this.getContainer().remove()
        delete g_form.list[this.opts.name]
        this.callEvent('remove')
    }

    // 清空输入
    clear(){
        this.entriesElement((child, item) => {
            item.value = item.preset.value
            this.update(child)
        })
    }

    // 更新element
    update(targets = []) {
        let vals = {}
        targets = toArr(targets)
        this.entriesElement(async (child, item) => {
            if (targets.length && !targets.includes(child)) return

            let input = this.getInput(child)[0]
            if (!input) return

            let preset = item.preset
            let val = await call(item, preset.getValue || item.value)
            vals[child] = val
            this.setInputVal(item.type, input, val)
            
            if(preset.onInit) preset.onInit({val, input, item})
        })
        if (!this.defaultVals) { // 初始化
            this.defaultVals = vals
            this.callEvent('init', vals)
            let div = this.getContainer()
            if (typeof (bootstrap) != 'undefined') {
                div.find('[data-bs-toggle="popover"]').each((i, el) => new bootstrap.Popover(el))
                div.find('[data-mask]').each((i, el) => new IMask(el, {
                    mask: el.dataset.mask,
                    lazy: el.dataset['mask-visible'] === 'true'
                }))
            }
        }
        this.callEvent('update', targets)
    }

    // 获取改变
    getChanges() {
        let r = {}
        let vals = this.defaultVals
        for (let [k, v] of Object.entries(this.getVals(false))) {
            if (v != vals[k]) {
                r[k] = v
            }
        }
        return r
    }

    getElementItem(name) {
        return this.opts.elements[name]
    }

    // 获取子元素
    getElement(name, container) {
        return (container ?? this.getContainer()).find('[data-formInput="' + name + '"]')
    }

    // 获取子元素输入对象
    getInput(name, container) {
        return this.getElement(name, container).find('.form_input')
    }

    getInputVal(name, container, check) {
        let input = this.getInput(name, container)
        if (input.length) {
            let attr = this.opts.elements[name]
            let val = attr.preset.getVal(input[0])
            if (attr.required) {
                let invaild = isEmpty(val) || toVal(attr.check, val) === false
                input.toggleClass('is-invalid', invaild)
                if (invaild && check) return new Error('非法数据')
            }
            return val
        }
    }

    // 设置子元素输入值
    setInputVal(type, dom, val) {
        let preset = g_form.getPreset(type)
        return preset.setVal(dom, val)
    }

    setElementVal(name, val, k = 'value') {
        return this.assignElementVal(name, { [k]: val })
    }

    // 合并子element数据并更新
    assignElementVal(name, vals = {}) {
        let data = this.opts.elements[name]
        Object.assign(data, vals)
        this.rebuildElement(name) // 重载HTML结构（如有list属性等等）
        this.update([name]) // 更新当前显示值
    }

    assignElements(list) {
        let updated = []
        Object.entries(list).forEach(([k, v]) => {
            let val = this.opts.elements[k]
            if (val && v != undefined) {
                Object.assign(val, typeof (v) == 'object' ? v : { value: v })
                this.rebuildElement(k)
                updated.push(k)
            }
        })
        this.update(updated)
    }

    // 获取所有值
    getVals(check = true) {
        let r = {}
        let container = this.getContainer()
        Object.keys(this.opts.elements).forEach(child => {
            let val = this.getInputVal(child, container, check)
            if (val instanceof Error) {
                throw (val)
            }
            r[child] = val
        })
        return r
    }

    // 遍历子元素
    entriesElement(callback) {
        let elements = this.opts.elements
        for (let child in elements) {
            if (callback(child, elements[child]) === false) return
        }
    }


}

var g_form = {
    list: {},
    preset: {},
    // 注册form输入类型
    registerPreset(name, callback) {
        assignActions(this.preset, name, callback)
        return this
    },
    init() {
        Object.getOwnPropertyNames(_Form.prototype).forEach(method => {
            if (!['constructor'].includes(method) && !method.startsWith('_')) {
                g_form[method] = (id, ...args) => this.method(id, method, ...args)
            }
        })
    },
    // 获取自定义类型
    getPreset(name, item) {
        name ??= 'text'
        let preset = this.preset[name]
        if (preset) {
            if (!item) return preset
            item.props ??= ''
            if (!item.preset) item.preset = { ...preset, ...(item.defaultPreset || {}), item }

            let { getPreset } = item.preset
            // TODO 改良toval，支持调用call
            let html = typeof (getPreset) == 'function' ? getPreset.call(preset, item) : getPreset

            if(item.action) item.props += ' data-action="'+item.action+'" '
            return html
                .replaceAll('{id}', 'form_item_' + name)
                .replaceAll('{title}', item.title || '')
                .replaceAll('{rows}', item.rows || 3)
                .replaceAll('{props}', item.props)
                .replaceAll('{size}', item.size ? `form-${item.type == 'select' ? 'select' : 'control'}-${item.size}` : '')
                .replaceAll('{required}', item.required ? 'required' : '')
                .replaceAll('{help}', item.help ? `<span class="form-help ms-1" data-bs-toggle="popover" data-bs-trigger="hover focus" data-bs-placement="right" data-bs-html="true" data-bs-content="${item.help}">?</span>` : '')
                .replaceAll('{placeholder}', item.placeHolder || '')
        }
    },
    // 获取inst
    get(id) {
        return this.list[id]
    },
    // 执行方法
    method(id, method, ...args) {
        let inst = this.get(id)
        if (inst) {
            return inst[method].apply(inst, args)
        }
    },
    // 是否存在
    exists(id) {
        return this.get(id) != undefined
    },
    build(id, opts) {
        opts.name = id
        return new _Form(opts)
    },
    // 获取dom所在formID
    getFormID(dom) {
        return $(dom).parents('.form-fieldset').attr('id')
    },
    // 获取dom所在form信息
    getFormByDom(dom) {
        dom = $(dom)
        let id = this.getFormID(dom)
        if (id != undefined) {
            let inst = this.get(id)
            let name = getParentAttr(dom, 'data-formInput')
            return { id, name, item: inst.opts.elements[name] }
        }
    },
    confirm(name, form_opts, modal_opts) {
        form_opts.id = name
        return this.confirm1(form_opts, modal_opts)
    },
    // 对话框展示
    confirm1(opts, modal_opts = {}) {
        let { id, elements, title, btn_ok, once, autoFocus } = Object.assign({
            title: '',
            once: true,
            btn_ok: '确定',
        }, opts)

        if (modal_opts.once === false) modal_opts.overwrite = false // 不重新生成form
        // g_modal.remove(id)
        let form_opts = { elements }
        modal_opts = Object.assign({
            id, title, btn_ok, once, scrollable: true,
            html: '<div class="modal_form"></div>',
            onBtnClick: (btn, modal) => {
                if (btn.id == 'btn_ok') {
                    let vals = this.method(id, 'getVals', true)
                    if (vals === false) return false
                    if (opts.callback({ btn, modal, vals, changes: this.method(id, 'getChanges') }) === false) return false
                    return true
                }
                if (opts.onBtnClick) opts.onBtnClick(btn)
            }
        }, modal_opts)

        let onShow = modal_opts.onShow
        modal_opts.onShow = modal => {
            let div = this.getContainer(id, false)
            if (!div) {
                this.build(id, Object.assign(form_opts, {
                    target: modal.find('.modal_form'),
                    autoFocus,
                }))
            }
            onShow && onShow()
        }

        // let onHide = modal_opts.onHide
        // modal_opts.onHide = modal => {
        //     if(!modal_opts.once)
        //     this.remove(id)
        //     onClose && onClose()
        // }

        let onClose = modal_opts.onClose
        modal_opts.onClose = modal => {
            this.remove(id)
            onClose && onClose()
        }

        confirm(modal_opts.html, modal_opts)
    },
}
g_form.init()

g_form.registerPreset({
    textarea: {
        setVal: (dom, val) => dom.value = val || '',
        getVal: dom => dom.value,
        value: '',
        getPreset: `
            <label class="form-label {required}">{title}{help}</label>
            <textarea spellcheck="false" autocomplete="off" autocorrect="off" id="{id}" rows="{rows}" placeholder="{placeholder}" class="form-control form_input {size}" {props}/></textarea>
        `
    },
    text: {
        setVal: (dom, val) => dom.value = val || '',
        getVal: dom => {
            let val = dom.value
            if (dom.type == 'number') val = val * 1
            return val
        },
        value: '',
        getPreset: `
            <label class="form-label {required}">{title}{help}</label>
            <input spellcheck="false" autocomplete="off" autocorrect="off" id="{id}" placeholder="{placeholder}" class="form-control form_input {size}" {props}"/>
        `
    },
    inputmask: {
        setVal: (dom, val) => dom.value = val || '',
        getVal: dom => dom.value,
        value: '',
        getPreset: d => `
            <label class="form-label {required}">{title}{help}</label>
            <input id="{id}" placeholder="{placeholder}" type="text" class="form-control form_input {size}" data-mask="${d.mask}" data-mask-visible="true" autocomplete="off" autocorrect="off" spellcheck="false" {props} />
        `
    },
    file: {
        setVal: (dom, val) => {
            if (!isEmpty(val)) dom.value = val
        },
        getVal: dom => dom.value,
        value: '',
        getPreset: `
        <div class="mb-3">
           <div class="form-label {required}">{title}{help}</div>
           <input type="file" id="{id}" class="form-control form_input {size}" placeholder="{placeholder}" {props}>
        </div>`
    },
    date: {
        constructor: () => {
            g_preload.register('datepicker', {
                list: ['index.umd.min.js', 'core.js','base-plugin.js','range.js','preset.js'].map(file => '../public/plugins/litepicker/'+file),
                check: () =>  typeof(easepick) !== 'undefined'
            })
        },
        onInit({input, item}){
            g_preload.check('datepicker', () => {
                let picker = new easepick.create(Object.assign({
                    element: input,
                    lang: 'zh-CN',
                    // inline: true,
                    date: new Date(item.value),
                    css: ['index.css', 'range.css', 'preset.css'].map(file => '../public/plugins/litepicker/'+file),
                    // plugins: ["RangePlugin", "PresetPlugin"],
                    zIndex: 17,
                    buttonText: {
                        previousMonth: `<i class="ti ti-chevron-left"></i>`,
                        nextMonth: `<i class="ti ti-chevron-right"></i>`,
                    },
                    PresetPlugin: {
                        position: 'bottom',
                    },
                }, item.opts || {}));
                picker.on('select', date => {
                    // let start = picker.getStartDate().getTime()
                    // let end = picker.getEndDate().getTime()
                });
                this.picker = picker
            })
        },
        setVal: (dom, val) => dom.value = val,
        getVal: dom => dom.value,
        value: '',
        getPreset: `
        <div class="form-label {required}">{title}{help}</div>
        <div class="input-icon">
          <input class="form-control datepicker form_input {size}" placeholder="{placeholder}" id="{id}" {props}>
          <span class="input-icon-addon" data-action="form_date_show">
            <i class="ti ti-calendar"></i>
          </span>
        </div>
         `
    },
    file_chooser: {
        setVal: (dom, val) => dom.value = val,
        getVal: dom => dom.value,
        value: '',
        getPreset: `
         <div class="mb-3">
            <label class="form-label {required}">{title}{help}</label>
            <div class="input-group mb-2">
              <span class="input-group-text cursor-pointer" data-action="form_chooseFile" title="打开选择器">
                <i class="ti ti-folder me-2"></i>
                <span>选择</span>
              </span>
              <input type="text" class="form-control form_input {size}" id="{id}" placeholder="{placeholder}" {props}>
            </div>
          </div>`,
    },
    checkbox: {
        setVal: (dom, val) => dom.checked = Boolean(val),
        getVal: dom => dom.checked,
        value: false,
        getPreset: `
        <label class="form-check">
            <input id="{id}" type="checkbox" class="form-check-input form_input {size}" {props}>
            <span class="form-check-label {required}">{title}{help}</span>
        </label>`
    },
    switch: {
        setVal: (dom, val) => dom.checked = Boolean(val),
        getVal: dom => dom.checked,
        value: false,
        getPreset: `
        <label class="form-check form-switch">
          <input id="{id}" class="form-check-input form_input {size}" type="checkbox" {props}>
          <span class="form-check-label {required}">{title}{help}</span>
        </label>`
    },
    radio: {
        setVal: (dom, val) => dom.checked = Boolean(val),
        getVal: dom => dom.checked,
        value: false,
        getPreset: `
        <label class="form-check form-check-inline">
            <input id="{id}" class="form-check-input form_input {size}" type="radio" {props}>
            <span class="form-check-label {required}">{title}{help}</span>
        </label>`
    },
    radios: {
        setVal: (dom, val) => $(dom).find('input[value="'+val+'"]').prop('checked', true),
        getVal: dom => $(dom).find('input:checked').val(),
        value: '',
        list: [],
        getPreset: d => {
            d.id ??= guid()
            return `
            <div class="mb-3" >
                <div class="form-label {required}">{title}{help}</div>
                <div>
                    <label class="form-check form_input" id="{id}">
                        ${entriesObject(d.list).map(([k, v]) => {
                            return `
                            <label class="form-check ${d.inline ? 'form-check-inline' : ''}">
                                <input class="form-check-input" type="radio" name="${d.id}" value="${k}" ${k == d.value ? 'checked' : ''}>
                                <span class="form-check-label">${checkEmpty(v,k,'无')}</span>
                            </label>
                            `
                        }).join('')}
                    </label>
                </div>
            </div>`
        }
    },
    datalist: {
        setVal: (dom, val) => dom.value = val,
        getVal: dom => dom.value,
        value: '',
        list: [],
        getPreset: d => `
            <label class="form-label">{title}{help}</label>
            <input id="{id}" class="form-control form_input {size}" list="detalist_{id}" placeholder="{placeholder}" {props}>
            <datalist id="detalist_{id}">
            ${(() => {
                let h = ''
                let vals = Object.values(d.list)
                let keys = Array.isArray(d.list) ? [...vals] : Object.keys(d.list)
                keys.forEach((k, i) => {
                    h += `<option value="${k}" ${k == d.value ? 'selected' : ''}>${vals[i]}</option>`
                })
                return h
            })()}
            </datalist>
        `
    },
    range: {
        setVal: (dom, val) => {
            dom.value = val || 0
            let lable = $(dom).parent('.form_element').find('.range_lable')
            if (lable.length) lable.html(dom.value)
        },
        getVal: dom => dom.value * 1,
        value: 0,
        getPreset: d => {
            opts = Object.assign({ min: 0, max: 100, step: 1, format: '%s' }, d.opts)
            return `
             <label class="form-label {required}">{title}{help}
                <span class='range_lable text-muted ms-2'>${d.value}</span>
            </label>
             <input  id="{id}" type="range" class="form-range form_input {size}" min="${opts.min}" max="${opts.max}" step="${opts.step}" oninput="this.previousElementSibling.querySelector('.range_lable').innerHTML = this.value" {props}>
            `
        }
    },
    checkbox_list: {
        setVal: (dom, val) => $(dom).find('input[value="' + val + '"]').prop('checked', true),
        getVal: dom => getElementsValues($(dom).find('input:checked')),
        value: [],
        list: [],
        getPreset: d => {
            let h = ''
            let vals = Object.values(d.list)
            let keys = Array.isArray(d.list) ? [...vals] : Object.keys(d.list)
            keys.forEach((k, i) => {
                h += `
                <label class="form-check form-check-inline">
                  <input class="form-check-input" type="checkbox" value="${k}" ${d.value.includes(k) ? 'checked' : ''} {props}>
                  <span class="form-check-label">${checkEmpty(vals[i], '无')}</span>
                </label>
                `
            })
            return `
                <div class="form-label">{title}{help}</div>
                <div id="{id}" class="form_input {size}">
                    ${h || `什么都没有...`}
                </div>
            `
        }
    },
    colorInputs: {
        setVal: (dom, val) => $(dom).find('input[value="' + val + '"]').prop('checked', true),
        getVal: dom => $(dom).find('input:checked').val(),
        value: '',
        list: [],
        getPreset: d => {
            let h = ''
            let list = toVal(d.list)
            let name = d.name || 'colorinput'
            let vals = Object.values(list)
            let keys = Array.isArray(list) ? [...vals] : Object.keys(list)
            keys.forEach((k, i) => {
                h += `
                <div class="col-auto">
                    <label class="form-colorinput border-1" title="${k}">
                        <input name="${name}" type="radio" value="${k}" class="form-colorinput-input" ${k == d.value ? 'checked' : ''} {props}>
                        <span class="form-colorinput-color" style="background: ${vals[i]} !important"></span>
                    </label>
                </div>
                `
            })
            return `
                <div class="form-label">{title}{help}</div>
                <div id="{id}" class="row g-2 form_input">${h}</div>
            `
        }
    },
    cropper: {
        constructor: () => {
            g_preload.register('cropper', {
                list: ['../public/js/cropper.min.js', '../public/css/cropper.min.css'],
                check: () =>  typeof(Cropper) !== 'undefined'
            })
        },
        onInit({input, item}){
            g_preload.check('cropper', () => {
                item.cropper = new Cropper(input, Object.assign({
                    // aspectRatio: 1 / 1,
                    viewMode: 3,
                }, item.opts || {}))
            })
        },
        setVal: (dom, val) => {
            dom.src = val || ''
        },
        getVal(dom){
            let {cropper, format = 'png'} = this.item
            return cropper.getCroppedCanvas().toDataURL('image/' + format)
            // let {width, height} = cropper.getCropBoxData()
            // callback(data, parseInt(width), parseInt(height))
        },
        format: 'png',
        value: '',
        getPreset: `
            <label class="form-label {required}">{title}{help}</label>
            <img id="{id}" class="w-full form_input" {props}>
        `
    },
    tom_select: {
        constructor: () => {
            g_preload.register('tom_select', {
                list: ['../public/js/tom-select.complete.min.js', '../public/css/tom-select.min.css'],
                check: () => typeof(TomSelect) !== 'undefined'
            })
        },
        setVal: (dom, val) => dom?.tomselect?.setValue(val ?? ''),
        getVal: dom => dom?.tomselect?.getValue(),
        onInit: ({val, input, item}) => {
            g_preload.check('tom_select', () => {
                const onCreateItem = function (data, escape) {
                    let { img, html, format } = item.list.find(({ value }) => value == data.value) || {img: '', html: ''}
                    return `
                     <div>
                        <span class="dropdown-item-indicator">${!isEmpty(img) ? `<span class="avatar avatar-xs" style="background-image: url(${img})"></span>` : (html || '')
                        }</span>
                        ${escape(data.text)}    
                    </div>`;
                }
                item.inst = new TomSelect(input, Object.assign({
                    options: item.list.map(({ value, text }) => {
                        return { value, text }
                    }),
                    onInitialize() {
                        $(this.wrapper).find('.ts-control').addClass('p-0 border-0')
                        item.onInit && item.onInit.call(this)
                    },
                    onChange: item.onChange,
                    items: toArr(item.value),
                    maxOptions: null,
                    maxItems: null,
                    placeholder: item.placeHolder ?? '',
                    render: {
                        item: onCreateItem,
                        option: onCreateItem,
                    }
                }, item.opts ?? {}))
            })
        },
        list: [],
        value: [],
        getPreset: d => {
            return `
                <label class="form-label">{title}{help}</label>
                <input id="{id}" class="form-control form_input {size}" {props}"/>
            `
        }
    },
    select: {
        setVal: (dom, val) => dom.value = val || '',
        getVal: dom => dom.value,
        value: '',
        list: [],
        getPreset: d => {
            let h = ''
            let vals = Object.values(d.list)
            let keys = Array.isArray(d.list) ? [...vals] : Object.keys(d.list)
            keys.forEach((k, i) => {
                h += `<option value="${k}" ${k == d.value ? 'selected' : ''}>${typeof (vals[i]) == 'object' ? k : vals[i]}</option>`
            })
            
            return `
                <label class="form-label">{title}{help}</label>
                <select id="{id}" class="form-select form_input {size}" placeholder="{placeholder}" {props}>${h}</select>
            `
        }
    },
    breadcrumb: {
        setVal(val) {
            this.value = val
        },
        getVal(dom) {
            let { id, name } = g_form.getFormByDom(dom)
            return getEle('form_breadcrumb_bread', '.active', g_form.getElement(id, name)).data('value')
        },
        value: '',
        list: [],
        parseItem: (name) => {
            return `
            <p>
                <a href="#" data-action="form_breadcrumb_bread" data-value="${name}">${name}</a>
            </p>`
        },
        getParents(list, id, self = false) {
            let ret = []
            if (self && id != '') ret.push(id)
            while (true) {
                let find = Object.entries(list).find(([k, v]) => toVal(v.list).includes(id))
                if (!find) return ret
                id = find[0]
                ret.unshift(id)
            }
        },
        getChildItems(list, id) {
            return list[id]?.list || Object.entries(list)
                .filter(([k, v]) => this.getParents(list, k).length == 0)
                .map(([k, v]) => k)
        },
        getItem(id) {
            return this.list[id]
        },
        getItemTitle(id) {
            return this.getItem()?.title ?? id
        },
        setItemSelected({ id, target }) {
            let activeClass = 'active'
            $('.' + activeClass.replaceAll(' ', '.')).removeClass(activeClass)
            target.addClass(activeClass)
        },
        getPreset(d) {
            let { list, value, preset } = d
            let item_html = preset.getChildItems(list, value).map(child => preset.parseItem(child)).join('')
            let bread_list = ['...', ...preset.getParents(list, value, true)]
            let bread_html = bread_list.map((id, i) => {
                return `
                <li class="breadcrumb-item">
                    <a class="${i > 0 && i == bread_list.length - 1 ? 'active' : ''}" href="#" data-action="form_breadcrumb_bread" data-value="${id}">${preset.getItemTitle(id)}</a>
                </li>`
            }).join('')

            return `
                <label class="form-label">{title}{help}</label>
                <ol id="{id}" class="breadcrumb form-select form_input border-0 p-2 border-bottom" placeholder="{placeholder}" {props}>
                    ${bread_html}
                </ol>
                <div class="p-2">
                    ${item_html}
                </div>
            `
        },
        onSelectedItem({ id, name, dom }) {
            g_form.setElementVal(id, name, dom.dataset.value)
        },
    },
    html: {
        setVal: (dom, val) => $(dom).html(toVal(val)),
        getVal: dom => dom.innerHTML,
        value: '',
        getPreset: `<div id="{id}" class="form_input" {props}></div>`
    },
    image: {
        setVal: (dom, val) => $(dom).find('img').attr('src', val),
        getVal: dom => $(dom).find('img').attr('src'),
        value: '',
        getPreset: `
         <div class="mb-3 text-center form_input" id="{id}">
            <img class="avatar-rounded" title="点击上传图片" data-action="form_image" width="50">
          </div>`,
    },
})

g_action.registerAction('form_chooseFile', dom => {
    let { item } = g_form.getFormByDom(dom)
    let opts = Object.assign({ id: 'form_chooseFile', defaultPath: item.value }, item.opts || {})
    let input = dom.nextElementSibling
    openFileDiaglog(opts, path => {
        input.value = path.join(',')
    })
})

g_action.registerAction('form_image', dom => {
    g_form.confirm1({
        id: 'form_image',
        title: '输入地址',
        elements: {
            src: {
                title: '地址',
                type: 'file_chooser',
                required: true,
                value: dom.src,
                opts: {
                    title: '选择图片',
                    properties: ['openFile'],
                    defaultPath: dom.src,
                    filters: [
                        { name: 'Images', extensions: ['jpg', 'jpeg', 'png', 'gif'] },
                    ],
                }
            },
        },
        callback({ vals }) {
            getEle('form_image').attr('src', vals.src)
        }
    }, { once: true })
})

g_action.registerAction('form_breadcrumb_bread', dom => {
    let opts = g_form.getFormByDom(dom)
    if (opts.item.preset.onSelectedItem({ ...opts, dom }) !== false) {
        let value = dom.dataset.value
        let target = g_form.getContainer(opts.id).getEle({ action: 'form_breadcrumb_bread', value })
        opts.item.preset.setItemSelected({ target, dom, id: value })
    }
})


/*
$(function () {
    g_form.confirm1({
        id: 'form_test',
        elements: {
            breadcrumb: {
                title: '目录树',
                type: 'breadcrumb',
                value: 'a',
                list: {
                    a: {list: ['b']},
                    b: {list: ['c']},
                    c: {list: []},
                },
                defaultPreset: {
                    // getPreset(){
                    //     console.log('getPreset')
                    //     return ''
                    // },
                    onSelectedItem(opts){
                        console.log('onSelectedItem')
                        return g_form.getPreset('breadcrumb').onSelectedItem(opts)
                    },
                }
            },
        },
        callback({vals}){
            console.log(vals)
        }
    })
});
*/