

class floatDIV {
    constructor(opts) {
      
    }

}

var g_floatDiv = {

    init(){
        const self = this
        Object.getOwnPropertyNames(floatDIV.prototype).forEach(method => {
            if (!['constructor'].includes(method) && !method.startsWith('_')) {
                self[method] = (id, ...args) => self.method(id, method, ...args)
            }
        })

        let selector = '.resizable-draggable-div'
        let header = selector + ' .ft_header'
        g_style.addStyle('floatDiv', `
        ${selector} {
            position: fixed;
            z-index: 99999;
            min-width: 200px;
            min-height: 200px;
            resize: both;
            overflow: auto;
          }

          ${header} {
            min-height: 30px;
          }
        `)
        
        let isDragging = false;
        let lastX, lastY;
        $(document)
        .on('mousedown', header, function({clientX, clientY, offsetX, offsetY}){
            // let offset = 10
            // let sizing = offsetX <= offset || offsetY <= offset || this.offsetWidth - offsetX <= offset || this.offsetHeight - offsetY <= offset
            isDragging =  true;
            lastX = clientX;
            lastY = clientY;
        })
        .on('mouseenter', header, function(e){
            this.style.cursor = 'move'
        })
        .on('mouseleave', header, function(e){
            this.style.cursor = 'none'
        })
        .on('mousemove', selector, function({clientX, clientY}){
          if (isDragging) {
            let {left, top} = this.getBoundingClientRect()
            const deltaX = clientX - lastX;
            const deltaY = clientY - lastY;
            this.style.left = `${left + deltaX}px`;
            this.style.top = `${top + deltaY}px`;
            lastX = clientX;
            lastY = clientY;
          }
        })
        .on('mouseup', selector, () => isDragging = false)
    },
      // 获取inst
    get(id) {
        return this.list[id]
    },
    // 执行方法
    method(id, method, ...args) {
        let inst = this.get(id)
        if (inst) {
            return inst[method].apply(inst, args)
        }
    },
    // 是否存在
    exists(id) {
        return this.get(id) != undefined
    },

}

g_floatDiv.init()
