var g_fileDrop = {
    list: {},
    init() {
        g_style.addStyle('filedrop', `
            .filedrop_layout {
                position: fixed;
                z-index: 99999;
                width: 100vw;
                height: 100vh;
                overflow: hidden;
                display: none;
                top: 0;
                left: 0;
                pointer-events: none;
            }
        `)
        window.addEventListener('mousemove', e => g_cache.mouse = e)
        $(document).
            // on('dragstart', '[data-files]', function(e) {
            //     clearEventBubble(e)
            //     g_cache.draging = true
            //     setDragingFiles(e.currentTarget.dataset.files.split(','))
            // }).
            // 拖拽文件
            on('dragstart', '[data-file]', function (e) {
                clearEventBubble(e)

                let dom = $(e.currentTarget)
                // TODO 保持顺序
                let r = {
                    dom,
                    keys: [],
                    files: [],
                    icon: getParentAttr(dom, 'data-icon') || dom.attr('src') || dom.find('img').attr('src'),
                }
                let parEl = getParent(dom, '.item_selected')
                if (parEl.length) { // 区分拖一个还是多个
                    for (let target of parEl.siblings('.item_selected').add(parEl)) {
                        let md5 = getChildAttr(target, 'data-md5')
                        let file = getChildAttr(target, 'data-file')
                        file && r.files.push(file)
                        md5 && r.keys.push(md5)
                    }
                } else {
                    r.keys.push(getParentAttr(dom, 'data-md5'))
                    r.files.push(getParentAttr(dom, 'data-file'))
                }
                g_plugin.callEvent('beforeDragingFile', r).then(({ files, keys, icon }) => {
                    g_cache.dragingMD5s = keys
                    setDragingFiles(files, icon)
                })
            })
        g_cache.dragingFile = []
    },
    register(name, opts) {
        let { selector, onUpdateTarget, target = $('body') } = this.list[name] = opts
        const container = insertEl({ tag: 'div', text: '', props: { id: 'filedrop_layout_'+name, class: 'filedrop_layout'} }, { target, method: 'prependTo' })
        const fileDragHover = ({ originalEvent: ev }) => {
            let { type, dataTransfer } = ev
            // Files, text/plain'
            if (g_cache.draging) {
                if (type == 'dragleave') g_plugin.callEvent('afterDraggedFile') // 放手事件
            } else {
                let show = opts.acceptTypes && !arr_include(dataTransfer.types, opts.acceptTypes) ? false : (type == 'dragleave' ? inArea(ev, $(selector)) : true)
                container.toggleClass('show', show)
                onUpdateTarget && onUpdateTarget(ev)
            }
            clearEventBubble(ev)
        }

        const getTargetCard = e => {
            for(let card of container.find('[data-action]')){
                if(inArea(e, card)) return card
            }
        }

        let timer, over_event
        let lastTarget
        $(document).
            on('dragleave', selector, fileDragHover).
            on('dragenter', selector, () => {
                timer && clearInterval(timer)
                if(!container.hasClass('show')) container.html(toVal(opts.layout))

                timer = setInterval(() => {
                    let target
                    if(over_event && (target = getTargetCard(over_event)) && target != lastTarget){
                        lastTarget = target
                        triggerAction(target)
                    }
                }, 250)
            }).
            on('dragover', selector, ev => {
                over_event = ev
                fileDragHover(ev)
            }).
            on('drop', selector, ({ originalEvent: e }) => {
                timer && clearInterval(timer)

                this.hideAll()
                let { target, dataTransfer: dt } = e
                this.parseData(name, {
                    text: dt.getData('text/plain'),
                    uri: dt.getData('text/uri-list'),
                    html: dt.getData('text/html'),
                    file: dt.files,
                }, target, getTargetCard(e));
                // e.target.files
                g_cache.draging = false & delete g_cache.dragingFile;
                clearEventBubble(e)
            })
    },
    getLayout(name) {
        return $('#filedrop_layout_' + name)
    },
    getShowing() {
        return $(".filedrop_layout.show")
    },
    hide(name){
        this.getLayout(name).toggleClass('hide')
    },
    hideAll() {
        this.getShowing().removeClass('show')
    },
    remove(name) {
        delete this.list[name]
    },
    get(name) {
        return this.list[name]
    },
    async parseData(name, data, target, targetCard) {
        let d = this.get(name)
        for (let type in data) {
            let r
            let vals = data[type]
            if (type == 'file') {
                r = { dirs: [], files: [] }
                for (let i = 0, f; f = vals[i]; i++) {
                    let ext
                    if (f.path) { // 从electron接受文件
                        if ((g_cache.dragingFile || []).includes(f.path)) continue;

                        if (nodejs.files.isDir(f.path)) { // 目录
                            r.dirs.push(f.path)
                            continue;
                        }
                        f.file = f.path.replaceAll('\\', '/').replaceAll('file:///', '')
                        ext = getExtName(f.file)
                    } else
                    if(d.reviceFileObject) { // 接受File对象（网页拖动来的文件，没有本地路径）
                        f.file = await fileReader({
                            type: 'DataURL',
                            input: f
                        })
                        ext = popString(f.type, '/')
                    }else{
                        return
                    }
                    if ((d.exts && !d.exts.includes(ext)) || (d.ingone && d.ingone.includes(ext))) continue
                    r.files.push(f.file)
                }
            }
            data[type] = {data: vals, items: r}
        }
        d.onParse(data, target, targetCard)
    },
    parseFolder() {

    }
}

function setDragingFiles(files, icon) {
    g_cache.draging = true; // 全局拖拽事件，只允许外部文件触发filedrop
    g_cache.dragingFile = files
    ipc_send('ondragstart', {
        files: files.map(file => file.replace('./', nodejs.dir + '/')),
        icon: (icon || '').replace('file:///', '').replace('./', nodejs.dir + '/'),
    });
}