


var g_ffmpeg = {
    init() {
       
    },
    async markCover(opts, cb) {
            let {md5, input, output, data, params, scale} = opts
            data ??= await g_data.data_get(md5)
            md5 ??= data.md5
            input ??= await g_item.item_getVal('file', data)

            // if (!nodejs.files.exists(input)) return
            let type = getFileType(input)

            let args = {type, scale, input, md5, data, output,id: 'cover_'+type+'_'+md5}
            args.scale ??= '-1:225'

            g_plugin.callEvent('markCover', {type, args, cb}).then(({args}) => {
                switch (type) {
                    case 'video':
                    case 'image':
                    case 'audio':
                        args['time'] = params ?? 0
                        break;
                    case 'font':
                        break
                    case 'document':
                        args['-frames:v'] = 1
                        break;
                    default:
                        return
                }
                g_ffmpeg.video_cover(args, err => {
                    setTimeout(() => {
                       if(!nodejs.files.exists(output)){
                            saveThumb(input, output).then(() => cb(output))  // 实在无法生成则调用原生
                       }else{
                           cb(output)
                       }
                    }, 1000)
                })
            })
    },

    // 裁剪视频
    video_cut(opts, onProgress, callback) {
        nodejs.files.makeSureDir(opts.output)
        opts.id ??= guid()
        
        const setStaus = status => this.mgr.setStatus(opts.id, status)
        let ffmpeg = new nodejs.cli.ffmpeg(opts.input, Object.assign(opts, { progress: true }))
        .on('start', cmd => onProgress('waitting'))
        .on('progress', progress => onProgress(parseInt(toTime(progress) / opts.duration * 100) + '%'))
        .on('error', err => setStaus(TASK_ERROR) & callback(err))
        .on('end', str => setStaus(TASK_COMPLETED) & callback())
        
        this.mgr.add(opts.id, {
            obj: ffmpeg,
            onStatusChange(status, cb) {
                // TODO 立即执行选项
                if (status == TASK_RUNNING) this.obj.save(opts.output)
            }
        })



    },

    // 封面裁剪
    async video_cover(opts, callback) {
        let {input, output, id, type = 'video'} = opts
        let ext = getExtName(input).toLowerCase()
        let proc
        const addTask = (proc, id) => {
            id ??= guid()
            this.mgr.add(id, {
                obj: proc,
                onStatusChange(status, cb) {
                    if (status == TASK_RUNNING) {
                        this.obj.start()
                    }
                }
            })
        }
        const setStaus = status => this.mgr.setStatus(opts.id, status)
        if(type == 'image'){
            // imageMagick
            // '-flatten', // psd 合并成一张
            proc = nodejs.cli.imageMagick([
                `"${input}"`,
                '-resize', '255',
                '-define', 'webp:lossless=false',
                '-define', 'webp:method=4',
                '-define', 'webp:alpha-quality=50',
                '-quality', '40',
                `"${output}"`
            ], err => {
                if(opts.md5) g_item.item_getVal('preview', opts.data) // 检测是否现需要
                setStaus(TASK_COMPLETED) & callback()
            })
        }else
        if(type == 'font'){
            let text = 'Hello,world!'
            proc = nodejs.cli.imageMagick([
                '-size', '400x200',
                // '-background', 'transparent',
                '-fill', 'black',
                '-font', `${input}`,
                '-pointsize', '20',
                '-gravity', 'center',
                `caption:"${text}"`,
                // '-alpha', 'set',
                // '-channel', 'RGBA',
                `"${output}"`
            ], err => {
                setStaus(TASK_COMPLETED) & callback()
            })
        }else
        if(ext == 'pdf'){
            // TODO 单独添加到pdfc
            nodejs.files.makeSureDir(output)
            proc = nodejs.cli.imageMagick([
                `"${input}[0]"`,
                '-resize', '255',
                '-define', 'webp:lossless=false',
                '-define', 'webp:method=4',
                '-define', 'webp:alpha-quality=50',
                '-quality', '40',
                `"${output}"`
            ], err => {
                setStaus(TASK_COMPLETED) & callback()
            })
        }else{
            proc = new nodejs.cli.ffmpeg(input)
            // .on('start', console.log)
            .on('end', () => setStaus( TASK_COMPLETED) & callback())
            .on('error', err => setStaus( TASK_ERROR) & callback(err))
            if(type == 'audio'){
                let filename = getFileName(output, false)
                if(filename == 'wave'){ // 波形图
                    proc
                    .setParam('-filter_complex', 'showwavespic=s=640x120')
                    .setParam('-frames:v', '1')
                }
                proc.save(output) // 封面图直接输入jpg就行
            }else{
                proc.screenshots1(opts)
            }
        }
        addTask(proc, opts.id)
    },

    // 封面裁剪
    video_screenshots(opts, callback) {
        nodejs.files.makeSureDir(opts.output)
            new nodejs.cli.ffmpeg(opts.input, opts)
            .screenshots({
                timestamps: opts.params,
                folder: this.path.dirname(opts.output),
                filename: this.path.basename(opts.output),
                size: opts.size
            }).on('end', function() {
                callback();
            }).on('error', function() {})
    },

    // 视频信息
    video_meta(input, callback) {
        return new Promise(reslove => {
            nodejs.cli.ffprobe(input, {env: getProxy()}).then(metadata => {
                typeof(callback) == 'function' ? callback(metadata): reslove(metadata)
            });
        })
    },


}

g_ffmpeg.init()
